-- Generated by re2hs
{-# LANGUAGE RecordWildCards #-}
#1 "haskell/fill/02_fill.re"
-- re2hs $INPUT -o $OUTPUT
{-# OPTIONS_GHC -Wno-unused-record-wildcards #-}
{-# LANGUAGE OverloadedStrings #-}

import Control.Monad
import qualified Data.ByteString as BS
import GHC.IO.Handle
import System.Directory
import System.IO

chunk_size :: Int
chunk_size = 4096

data State = State {
    _file :: !Handle,
    _yyinput :: !BS.ByteString,
    _yycursor :: !Int,
    _yylimit :: !Int,
    _token :: !Int,
    _eof :: !Bool,
    _count :: !Int
}


#29 "haskell/fill/02_fill.hs"
yy0 :: State -> IO Int
yy0 !State{..} = do
    State{..} <- fill State{..} 1
    yych <- return $ BS.index _yyinput _yycursor
    _yycursor <- return $ _yycursor + 1
    case yych of
        _c | 0x00 == _c -> do
            yy1 State{..}
        _c | 0x20 == _c -> do
            yy3 State{..}
        _c | 0x27 == _c -> do
            yy5 State{..}
        _c | True -> do
            yy2 State{..}

yy1 :: State -> IO Int
yy1 !State{..} = do
#37 "haskell/fill/02_fill.re"
    return $ if _yycursor == _yylimit - yymaxfill + 1 then _count else (-1)
#49 "haskell/fill/02_fill.hs"

yy2 :: State -> IO Int
yy2 !State{..} = do
#36 "haskell/fill/02_fill.re"
    return (-1)
#55 "haskell/fill/02_fill.hs"

yy3 :: State -> IO Int
yy3 !State{..} = do
    State{..} <- fill State{..} 1
    yych <- return $ BS.index _yyinput _yycursor
    case yych of
        _c | 0x20 == _c -> do
            _yycursor <- return $ _yycursor + 1
            yy3 State{..}
        _c | True -> do
            yy4 State{..}

yy4 :: State -> IO Int
yy4 !State{..} = do
#39 "haskell/fill/02_fill.re"
    lexer State{_token = _yycursor, ..}
#72 "haskell/fill/02_fill.hs"

yy5 :: State -> IO Int
yy5 !State{..} = do
    State{..} <- fill State{..} 1
    yych <- return $ BS.index _yyinput _yycursor
    _yycursor <- return $ _yycursor + 1
    case yych of
        _c | 0x27 == _c -> do
            yy6 State{..}
        _c | 0x5C == _c -> do
            yy7 State{..}
        _c | True -> do
            yy5 State{..}

yy6 :: State -> IO Int
yy6 !State{..} = do
#38 "haskell/fill/02_fill.re"
    lexer State{_token = _yycursor, _count = _count + 1, ..}
#91 "haskell/fill/02_fill.hs"

yy7 :: State -> IO Int
yy7 !State{..} = do
    State{..} <- fill State{..} 1
    _yycursor <- return $ _yycursor + 1
    yy5 State{..}

lexer :: State -> IO Int
lexer !State{..} = do
    yy0 State{..}

#40 "haskell/fill/02_fill.re"


yymaxfill :: Int
#107 "haskell/fill/02_fill.hs"
yymaxfill = 1
#43 "haskell/fill/02_fill.re"


fill :: State -> Int -> IO State
fill !st@State{..} !need =
    if _yylimit - _yycursor >= need then
        return st
    else case _eof of
        True -> error "fill failed"
        False -> do
            -- Discard everything up to the current token, cut off terminating null,
            -- read new chunk from file and reappend terminating null at the end.
            chunk <- BS.hGet _file chunk_size
            let !eof = BS.length chunk < need -- end of file ?
            let !buf = BS.concat [
                    BS.drop _token _yyinput,
                    chunk,
                    if eof then (BS.replicate yymaxfill 0) else BS.empty]
            return State {
                _yyinput = buf,
                _yycursor = _yycursor - _token,
                _yylimit = BS.length buf,
                _token = 0,
                _eof = eof,
                ..}

main :: IO ()
main = do
    let fname = "input"

    -- Prepare input file.
    BS.writeFile fname $ BS.concat ["'qu\0tes' 'are' 'fine: \\'' " | _ <- [1..chunk_size]]
    let expect = 3 * chunk_size -- the total number of strings in file

    -- Run lexer on the prepared file.
    fh <- openFile fname ReadMode
    let st = State {
        _file = fh,
        _yyinput = BS.empty,
        _yycursor = 0,
        _token = 0,
        _yylimit = 0,
        _eof = False,
        _count = 0
    }
    result <- lexer st
    hClose fh

    -- Cleanup.
    removeFile fname

    -- Check result.
    when (result /= expect) $ error $ "expected " ++ show expect ++ ", got " ++ show result
    return ()
