/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.io.FileFilter;
import java.math.BigInteger;

public class NumberFilter
implements FileFilter {
    private String pre;
    private String post;

    public NumberFilter(String pre, String post) {
        this.pre = pre;
        this.post = post;
    }

    public BigInteger getNumber(String name) {
        if (!name.startsWith(this.pre) || !name.endsWith(this.post)) {
            return null;
        }
        int ndx = this.pre.length();
        int end = name.length() - this.post.length();
        try {
            return new BigInteger(name.substring(ndx, end));
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public boolean accept(String name) {
        return this.getNumber(name) != null;
    }

    public boolean accept(File pathname) {
        return this.accept(pathname.getName());
    }
}

