/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.File;
import java.io.IOException;

public class GribIndexName {
    public static final String currentSuffix = ".gbx8";
    public static final String oldSuffix = ".gbx";
    public static boolean updateToCurrent = false;
    public static boolean createCurrent = true;
    public static String cache = null;

    public static String getCurrentSuffix(String gribName) {
        return GribIndexName.getIndex(gribName, false);
    }

    public static String get(String gribName) {
        return GribIndexName.getIndex(gribName, true);
    }

    public static String getIndex(String gribName, boolean includeOld) {
        File fidx;
        if (gribName.endsWith(oldSuffix)) {
            gribName = gribName.replace(oldSuffix, "");
        }
        if ((fidx = gribName.endsWith(currentSuffix) ? new File(gribName) : new File(gribName + currentSuffix)).exists()) {
            return fidx.getPath();
        }
        if (includeOld && (fidx = new File(gribName + oldSuffix)).exists()) {
            return fidx.getPath();
        }
        fidx = new File(gribName + currentSuffix);
        try {
            if (fidx.createNewFile()) {
                fidx.delete();
                return fidx.getPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (cache != null) {
            return cache + gribName + currentSuffix;
        }
        return gribName + currentSuffix;
    }

    public static boolean isUpdateToCurrent() {
        return updateToCurrent;
    }

    public static void setUpdateToCurrent(boolean updateToCurrent) {
        GribIndexName.updateToCurrent = updateToCurrent;
    }

    public static boolean isCreateCurrent() {
        return createCurrent;
    }

    public static void setCreateCurrent(boolean createCurrent) {
        GribIndexName.createCurrent = createCurrent;
    }

    public static String getCache() {
        return cache;
    }

    public static void setCache(String cache) {
        GribIndexName.cache = cache;
    }
}

