/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.Float64PrimitiveVector;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.FieldImpl;
import visad.FlatField;
import visad.Gridded1DDoubleSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.VisADException;
import visad.data.dods.NumericVectorAdapter;
import visad.data.dods.Valuator;
import visad.data.dods.VariableAdapterFactory;
import visad.data.in.ArithProg;

public class Float64VectorAdapter
extends NumericVectorAdapter {
    private final Valuator valuator;

    public Float64VectorAdapter(Float64PrimitiveVector vector, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        super((PrimitiveVector)vector, das, factory);
        this.valuator = Valuator.valuator(Float64VectorAdapter.attributeTable(das, vector.getTemplate()), 9);
    }

    public final void setField(PrimitiveVector vector, FieldImpl field, boolean copy) throws VisADException, RemoteException {
        if (field.isFlatField()) {
            ((FlatField)field).setSamples(new double[][]{this.getDoubles(vector, copy)}, false);
        } else {
            field.setSamples(new double[][]{this.getDoubles(vector, copy)});
        }
    }

    public GriddedSet griddedSet(PrimitiveVector vector) throws VisADException, RemoteException {
        double[] vals = this.getDoubles(vector, true);
        ArithProg ap = new ArithProg();
        ap.accumulate(vals);
        return ap.isConsistent() ? new Linear1DSet(this.getMathType(), ap.getFirst(), ap.getLast(), (int)ap.getNumber()) : Gridded1DDoubleSet.create(this.getMathType(), vals, null, null, null);
    }

    public double[] getDoubles(PrimitiveVector vec, boolean copy) {
        Float64PrimitiveVector vector = (Float64PrimitiveVector)vec;
        double[] values = new double[vector.getLength()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = vector.getValue(i);
        }
        return this.valuator.process(values);
    }
}

