#/bin/sh

FRDIR=`dirname $0`
REVISIONINFOFILE=src/revisioninfo.h

# this will already contain the quotes needed in the header file
GITHASH="";
if [ -x "$(command -v git 2>/dev/null)" ]; then
    GITHASH=`git log -1 --pretty=format:%h $FRDIR 2>/dev/null`
    if [ "$GITHASH" != "" ]; then
        GITHASH="\"$GITHASH\""
    fi
fi
#if [ "$GITHASH" != "" ]; then
#    echo "git hash $GITHASH"
#else
#    echo "no git hash found"
#fi


if test -f $REVISIONINFOFILE ; then
    HEADER_GITHASH=`awk '/FR_GIT_HASH/{print $3}' $REVISIONINFOFILE`
    if [ "$HEADER_GITHASH" != "$GITHASH" ]; then
        echo "git hash has changed from $HEADER_GITHASH to $GITHASH"
        WRITE_HEADER="y"
    fi
else
    echo "$REVISIONINFOFILE not found"
    WRITE_HEADER="y"
fi

if [ "$WRITE_HEADER" = "y" ]; then
    echo "// auto-generated by update-revision-info script" > $REVISIONINFOFILE

    if [ "$GITHASH" != "" ]; then
        echo "Writing git hash $GITHASH to $REVISIONINFOFILE"
        echo "#define FR_GIT_HASH $GITHASH" >> $REVISIONINFOFILE
    else
        echo "Writing no git hash to $REVISIONINFOFILE"
        echo "#undef FR_GIT_HASH" >> $REVISIONINFOFILE
    fi
fi
