# -*- coding: iso-8859-1 -*-
# -----------------------------------------------------------------------
# a pop-up box that asks a question and prompts for ok/cancel
# -----------------------------------------------------------------------
# $Id: ConfirmBox.py 11836 2011-02-18 21:58:19Z adam $
#
# Notes:
# Todo:
#
# -----------------------------------------------------------------------
# Freevo - A Home Theater PC framework
# Copyright (C) 2003 Krister Lagerstrom, et al.
# Please see the file freevo/Docs/CREDITS for a complete list of authors.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MER-
# CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# -----------------------------------------------------------------------


import config
from event import *

from GUIObject import *
from PopupBox  import *
from Button    import *


class ConfirmBox(PopupBox):
    """
    """
    def __init__(self, text, handler=None, handler_message=None, default_choice=0,
                 x=None, y=None, width=0, height=0, icon=None, vertical_expansion=1,
                 text_prop=None, parent='osd'):
        """
        Initialise an instance of a ConfirmBox

        @ivar text: String to print.
        @ivar handler: Handler call-back for the box
        @ivar handler_message: If 'handler_message' is set, the box will transform
          into a normal pop-up showing this text while 'handler' is called and will
          destroy itself after that.
        @ivar x: x coordinate. Integer
        @ivar y: y coordinate. Integer
        @ivar width: Integer
        @ivar height: Integer
        @ivar icon: icon
        @ivar text_prop: A dict of 4 elements composing text proprieties::

                  { 'align_h': align_h, 'align_v': align_v, 'mode': mode, 'hfill': hfill }
                     align_v = text vertical alignment
                     align_h = text horizontal alignment
                     mode    = hard (break at chars); soft (break at words)
                     hfill   = True (don't shorten width) or False
        """

        PopupBox.__init__(self, text, handler, x, y, width, height, icon, vertical_expansion, text_prop, parent)

        self.handler_message = handler_message

        # XXX: It may be nice if we could choose between
        #      OK/CANCEL and YES/NO

        self.b0 = Button(_('OK'), width=(self.width-60)/2)
        self.b0.set_h_align(Align.NONE)
        self.add_child(self.b0)

        self.b1 = Button(_('CANCEL'), width=(self.width-60)/2)
        self.b1.set_h_align(Align.NONE)
        self.add_child(self.b1)
        select = 'self.b%s.toggle_selected()' % default_choice
        eval(select)


    def send_enter_event(self):
        self.eventhandler(INPUT_ENTER)


    def __toggle_selected(self):
        self.b0.toggle_selected()
        self.b1.toggle_selected()
        self.draw()


    def __b0_selected(self):
        if self.handler and self.handler_message:
            self.content.children = []
            self.label = Label(self.handler_message, self, Align.CENTER,
                               Align.CENTER, text_prop=self.text_prop)
            self.draw()
        else:
            self.destroy()

        if self.handler:
            self.handler()
            if self.handler_message:
                self.destroy()


    def eventhandler(self, event):
        if event in (INPUT_LEFT, INPUT_RIGHT, INPUT_UP, INPUT_DOWN):
            self.__toggle_selected()
            return True

        elif event == INPUT_EXIT:
            self.destroy()
            return True

        elif event == INPUT_ENTER:
            if self.b0.selected:
                self.__b0_selected()
            else:
                self.destroy()
            return True
        
        elif event == MOUSE_MOTION:
            if self.b0.rect.collidepoint(event.pos):
                if not self.b0.selected:
                    self.__toggle_selected()
                return True
            elif self.b1.rect.collidepoint(event.pos):
                if not app.b1.selected:
                    self.__toggle_selected()
                return True

        elif event == MOUSE_BTN_PRESS:
            if event.button == 1:
                if self.b0.rect.collidepoint(event.pos):
                    self.__b0_selected()
                    return True

                if self.b1.rect.collidepoint(event.pos):
                    self.destroy()
                    return True
            
            elif event.button == 3:
                self.destroy()
                return True

        return False
