/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.ui.JConsole;
import gr.zeus.ui.JMessage;
import gr.zeus.util.GUIUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JConsoleTester
extends JFrame {
    private JConsole m_consoleFrame = new JConsole();
    private boolean m_realExit = true;

    public JConsoleTester() {
        this.initComponents();
        GUIUtils.centerOnScreen(this);
    }

    public void setExitMode(boolean exit) {
        this.m_realExit = exit;
    }

    private void myExit(int code) {
        if (code != 0) {
            try {
                JConsole.getConsole().dumpConsole("dump.log", false);
            }
            catch (IOException ex) {
                JMessage.showErrorMessage(this, "Error saving logfile!", ex);
            }
            JMessage.showErrorMessage(this, "Application Error!\nCheck dump.log for details!");
        }
        JConsole.getConsole().destroyConsole();
        System.out.println("Hello again from stdout");
        System.err.println("Hello again from stderr");
        if (this.m_realExit) {
            System.exit(code);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void initComponents() {
        JPanel panel1 = new JPanel();
        JButton helloButton = new JButton();
        JButton errorButton = new JButton();
        JButton exceptionButton = new JButton();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem consoleMenuItem = new JMenuItem();
        JMenuItem errorExitMenuItem = new JMenuItem();
        JMenuItem normalExitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Sample Application to demonstrate JConsole");
        helloButton.setText("hello");
        helloButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsoleTester.this.helloButtonActionPerformed(evt);
            }
        });
        panel1.add(helloButton);
        errorButton.setText("error");
        errorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsoleTester.this.errorButtonActionPerformed(evt);
            }
        });
        panel1.add(errorButton);
        exceptionButton.setText("exception");
        exceptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsoleTester.this.exceptionButtonActionPerformed(evt);
            }
        });
        panel1.add(exceptionButton);
        this.getContentPane().add((Component)panel1, "South");
        fileMenu.setText("File");
        consoleMenuItem.setText("Show Console");
        consoleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsoleTester.this.consoleMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(consoleMenuItem);
        errorExitMenuItem.setText("Exit with error code");
        errorExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsoleTester.this.errorExitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(errorExitMenuItem);
        normalExitMenuItem.setText("Normal Exit");
        normalExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JConsoleTester.this.normalExitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(normalExitMenuItem);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    private void exceptionButtonActionPerformed(ActionEvent evt) {
        String numS = "this is not a number!";
        int num = Integer.parseInt(numS);
        System.out.println("num=" + num);
    }

    private void errorButtonActionPerformed(ActionEvent evt) {
        System.err.println("Hello new stderr!");
    }

    private void helloButtonActionPerformed(ActionEvent evt) {
        System.out.println("Hello new stdout!");
    }

    private void normalExitMenuItemActionPerformed(ActionEvent evt) {
        this.myExit(0);
    }

    private void errorExitMenuItemActionPerformed(ActionEvent evt) {
        this.myExit(1);
    }

    private void consoleMenuItemActionPerformed(ActionEvent evt) {
        this.m_consoleFrame.setVisible(true);
    }

    private static void init_console() {
        System.out.println("Hello and goodbye from stdout");
        System.err.println("Hello and goodbye from stderr");
        JConsole.getConsole().setAppendFirstTime(false);
        JConsole.getConsole().setAutoSave(true);
        JConsole.getConsole().startConsole();
        System.out.println("This is the very first message logged to JConsole (stdout)");
        System.err.println("This is the very first message logged to JConsole (stderr)");
    }

    private static void init_lnf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JConsole.getConsole().updateLNF();
        }
        catch (Exception e) {
            System.err.println("Cannot initialize the look & feel");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JConsoleTester.init_lnf();
        JConsoleTester.init_console();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JConsoleTester().setVisible(true);
            }
        });
    }
}

