/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ScrolledText_H
#include "ScrolledText.h"
#endif

#ifndef XMString_H
#include "XMString.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef Tokenizer_H
#include "Tokenizer.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif



#include <mars.h>

ScrolledText::ScrolledText(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UIScrolledText_c>(owner,param),
	changed_(false)
{
}

ScrolledText::~ScrolledText()
{
}

void ScrolledText::refresh(const vector<string>& values)
{
	string s;
	for(vector<string>::const_iterator j = values.begin(); j != values.end(); ++j)
	{
			if(s.length()) s += "/";
			s += *j;
	}
	
	XMText text(text_);
	text.set(s);

	changed_ = false;
}

void ScrolledText::apply()
{
	if(changed_) {
		changed_ = false;
		owner_.changed(*this);
	}
}

void ScrolledText::set(Request& r)
{
	XMText text(text_);

	Tokenizer parse("/");
	vector<string> v;

	//parse(text.get(),v); //-- this removes leading '/' from path values!!

	string s = text.get();
	if( s[0] == '/' )      //-- handle 'path name candidates' here!
	  {
	    cout << ">>> (ScrolledText::set) Q&D hack: "
		 << s.c_str()
		 << " is now treated as path!"
		 << endl;
	    v.push_back(s);
	  }
	else
	  {
	    parse(s,v);        //-- all other parameters here!
	  }

	r.set(param_.name(),v);

	changed_ = false;
}

void ScrolledText::activateCB(Widget,XtPointer)
{
	changed_ = false;
	owner_.changed(*this);
}

void ScrolledText::changedCB(Widget,XtPointer)
{
	changed_ = true;
	decache();
}

void ScrolledText::update()
{
	if(changed_) 
	{
		changed_ = false;
		owner_.changed(*this,false);
	}
	RequestPanelItem::update();
}

static LineMaker<ScrolledText> maker1("scrolled_text");
