/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

# ifndef LAYOUTP_H
#   define LAYOUTP_H
#include "Paper.h"

typedef struct _PaperClassPart {
	int		ignore;
} PaperClassPart;

typedef struct _PaperClassRec {
	CoreClassPart	core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
	XmManagerClassPart manager_class;
	XmDrawingAreaClassPart drawing_area_class;
	PaperClassPart paper_class;
} PaperClassRec;

extern		PaperClassRec paperClassRec;


typedef struct {

	XtCallbackList join_cb;
	XtCallbackList split_cb;
	XtCallbackList group_cb;
	XtCallbackList ungroup_cb;
	XtCallbackList delete_cb;
	XtCallbackList draw_cb;
	XtCallbackList change_cb;
	XtCallbackList dblclick_cb;

	PaperRectangle *rects;

	int		hmargin;
	int		vmargin;
	Pixel		dash;
	Pixel		selected;
	Pixel		foreground;
	Pixel           white;
	Pixel           grid_color;
	GC		gc;
	GC		selected_gc;
	GC		white_gc;
	GC		dash_gc;
	GC		xor_gc;
	GC		grid_gc;
	int		what;
	int		startx;
	int		starty;
	int		lastx;
	int		lasty;
	Pixmap          pixmap;
	Boolean         offscreen;
	Boolean         dirty;
	Boolean         editable;
	XRectangle	sel;
	XRectangle      page;
	double          hpage;
	double          vpage;

	PaperGraphics   graphics;
	Time            last_click;
	Boolean         constraint;
	int             which_constraint;
	Boolean         free_moves;
	PaperRectangle  *drag;

	Boolean  handles;

	Boolean         grid;
	Boolean         snap;
	double          page_grid_x;
	double          page_grid_y;
	int             grid_x;
	int             grid_y;

} PaperPart;

typedef struct _PaperRec {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
	XmManagerPart	manager;
	XmDrawingAreaPart   drawing_area;
	PaperPart	paper;
	} PaperRec;
# endif 


