/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQNewIconWidget_H
#define MvQNewIconWidget_H

#include <QDialog>
#include <QListWidget>
#include <QMap>
#include <QStyledItemDelegate>

class QAbstractButton;

#include "IconClass.h"

#include "MvQRecentIcons.h"

class QButtonGroup;
class QComboBox;
class QLineEdit;
class QListWidget;
class QMouseEvent;
class QStackedWidget;

class MvQNewIconListWidget : public QListWidget
{
    Q_OBJECT

public:
    MvQNewIconListWidget(QWidget* parent = 0);
signals:
    void iconCreated(QString);

protected:
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);

    QPoint startPos_;
};

class MvQNewIconPanel : public QWidget, public ClassScanner, public RecentIconsObserver
{
    Q_OBJECT

public:
    enum SelectionMode
    {
        PanelMode,
        DialogMode
    };

    MvQNewIconPanel(SelectionMode, QWidget* parent = 0);
    ~MvQNewIconPanel();

    void next(const IconClass&);
    void setCurrentMode(int);
    int currentMode() const;
    QString currentSelection() const;

    //Observer method
    void notifyRecentChanged();

public slots:
    void slotTypeChanged(int);
    void slotIconSelected(QListWidgetItem*);
    void slotSearch(QString);
    void slotChangeMode(QAbstractButton*);
    void slotAddToRecentIcons(QString);

signals:
    void iconSelected(QString);
    void closePanel(bool b = true);

protected:
    void keyPressEvent(QKeyEvent* event);
    void updateRecentList();
    void paintEvent(QPaintEvent*);

    QStackedWidget* mainPanel_;
    MvQNewIconListWidget* recentList_;
    QComboBox* typeCb_;
    QStackedWidget* iconPanel_;
    QMap<QString, MvQNewIconListWidget*> iconLists_;
    QLineEdit* searchLine_;
    MvQNewIconListWidget* searchList_;
    vector<const IconClass*> iconClasses_;
    QButtonGroup* modeBg_;
    SelectionMode selectionMode_;
};

class MvQNewIconDialog : public QDialog
{
    Q_OBJECT

public:
    MvQNewIconDialog(QWidget* parent = 0);
    ~MvQNewIconDialog();
    const IconClass& selected();

public slots:
    void accept();
    void reject();
    void slotIconSelected(QString);

private:
    void writeSettings();
    void readSettings();

    MvQNewIconPanel* iconWidget_;
    QString selected_;
};


#endif
