﻿//
// WebFormsSyntaxModeTests.cs
//
// Author:
//       Matt Ward <matt.ward@xamarin.com>
//
// Copyright (c) 2015 Xamarin Inc. (http://xamarin.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

using System.Linq;
using NUnit.Framework;
using Mono.TextEditor;
using Mono.TextEditor.Highlighting;
using MonoDevelop.AspNet.WebForms;

namespace MonoDevelop.AspNet.Tests.WebForms
{
	[TestFixture]
	class WebFormsSyntaxModeTests
	{
		[Test]
		public void InvalidMimeTypeInScriptTypeAttribute ()
		{
			var doc = new TextDocument ();
			var syntaxMode = new WebFormsSyntaxMode ();
			syntaxMode.Document = doc;
			doc.Text = 
@"<%@ Page Language=""C#"" Inherits=""AspnetTest.Default"" %>
<!DOCTYPE html>
<html>
<head runat=""server"">
	<title>Default</title>
</head>
<body>
	<form id=""form1"" runat=""server"">
		<asp:Button id=""button1"" runat=""server"" Text=""Click me!"" OnClick=""button1Clicked"" />
	</form>
	<script type=""></script>
</body>
</html>
";
			var style = new ColorScheme ();
			foreach (DocumentLine line in doc.Lines) {
				Assert.DoesNotThrow (() => syntaxMode.GetChunks (style, line, line.Offset, line.Length).ToList ());
			}
		}
	}
}

