//------------------------------------------------------------------------------
//   Programmer: Adam M Phillippy, The Institute for Genomic Research
//         File: sw_alignscore.hh
//         Date: 8 / 08 / 2002
//
//   Description: Scoring information for nucleotide and amino acid alignments
//
//   Please report bugs and suggestions to <aphillip@tigr.edu>
//------------------------------------------------------------------------------

#ifndef __SW_ALIGNSCORE_HH
#define __SW_ALIGNSCORE_HH

//-- * equals O for easy hashing
const char STOP_CHAR = 'O';

//-------------------------------------------------- Scoring Matrix Types ----//
const int NUCLEOTIDE = 0;
const int BLOSUM45 = 1;
const int BLOSUM62 = 2;
const int BLOSUM80 = 3;

// dna scores 3,-7 m,mm by default. zero slope at 70% idy
// substitute 7,-7 m,mm for zero slope at 50% idy
const int GOOD_SCORE [4] = {3, 10, 8, 8};
const int OPEN_GAP_SCORE [4] = {-10, -10, -10, -10};
const int CONT_GAP_SCORE [4] = {-7, -1, -1, -1};
const int MATCH_SCORE [4][26][26] =
{{
//A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z
{+3,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,+3,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,+3,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,+3,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7},
{-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7}
},{
//A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z
{ 5,-1,-1,-2,-1,-2, 0,-2,-1, 0,-1,-1,-1,-1,-5,-1,-1,-2, 1, 0, 0, 0,-2, 0,-2,-1},
{-1, 4,-2, 5, 1,-3,-1, 0,-3,-1, 0,-3,-2, 4,-5,-2, 0,-1, 0, 0,-1,-3,-4,-1,-2, 2},
{-1,-2,12,-3,-3,-2,-3,-3,-3,-2,-3,-2,-2,-2,-5,-4,-3,-3,-1,-1,-2,-1,-5,-2,-3,-3},
{-2, 5,-3, 7, 2,-4,-1, 0,-4,-1, 0,-3,-3, 2,-5,-1, 0,-1, 0,-1,-1,-3,-4,-1,-2, 1},
{-1, 1,-3, 2, 6,-3,-2, 0,-3,-1, 1,-2,-2, 0,-5, 0, 2, 0, 0,-1,-1,-3,-3,-1,-2, 4},
{-2,-3,-2,-4,-3, 8,-3,-2, 0,-1,-3, 1, 0,-2,-5,-3,-4,-2,-2,-1,-1, 0, 1,-1, 3,-3},
{ 0,-1,-3,-1,-2,-3, 7,-2,-4,-1,-2,-3,-2, 0,-5,-2,-2,-2, 0,-2,-1,-3,-2,-1,-3,-2},
{-2, 0,-3, 0, 0,-2,-2,10,-3,-1,-1,-2, 0, 1,-5,-2, 1, 0,-1,-2,-1,-3,-3,-1, 2, 0},
{-1,-3,-3,-4,-3, 0,-4,-3, 5,-1,-3, 2, 2,-2,-5,-2,-2,-3,-2,-1,-1, 3,-2,-1, 0,-3},
{ 0,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-5,-1,-1,-1, 0, 0,-1,-1,-2,-1,-1,-1},
{-1, 0,-3, 0, 1,-3,-2,-1,-3,-1, 5,-3,-1, 0,-5,-1, 1, 3,-1,-1,-1,-2,-2,-1,-1, 1},
{-1,-3,-2,-3,-2, 1,-3,-2, 2,-1,-3, 5, 2,-3,-5,-3,-2,-2,-3,-1,-1, 1,-2,-1, 0,-2},
{-1,-2,-2,-3,-2, 0,-2, 0, 2,-1,-1, 2, 6,-2,-5,-2, 0,-1,-2,-1,-1, 1,-2,-1, 0,-1},
{-1, 4,-2, 2, 0,-2, 0, 1,-2,-1, 0,-3,-2, 6,-5,-2, 0, 0, 1, 0,-1,-3,-4,-1,-2, 0},
{-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5},
{-1,-2,-4,-1, 0,-3,-2,-2,-2,-1,-1,-3,-2,-2,-5, 9,-1,-2,-1,-1,-1,-3,-3,-1,-3,-1},
{-1, 0,-3, 0, 2,-4,-2, 1,-2,-1, 1,-2, 0, 0,-5,-1, 6, 1, 0,-1,-1,-3,-2,-1,-1, 4},
{-2,-1,-3,-1, 0,-2,-2, 0,-3,-1, 3,-2,-1, 0,-5,-2, 1, 7,-1,-1,-1,-2,-2,-1,-1, 0},
{ 1, 0,-1, 0, 0,-2, 0,-1,-2, 0,-1,-3,-2, 1,-5,-1, 0,-1, 4, 2, 0,-1,-4, 0,-2, 0},
{ 0, 0,-1,-1,-1,-1,-2,-2,-1, 0,-1,-1,-1, 0,-5,-1,-1,-1, 2, 5, 0, 0,-3, 0,-1,-1},
{ 0,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-5,-1,-1,-1, 0, 0,-1,-1,-2,-1,-1,-1},
{ 0,-3,-1,-3,-3, 0,-3,-3, 3,-1,-2, 1, 1,-3,-5,-3,-3,-2,-1, 0,-1, 5,-3,-1,-1,-3},
{-2,-4,-5,-4,-3, 1,-2,-3,-2,-2,-2,-2,-2,-4,-5,-3,-2,-2,-4,-3,-2,-3,15,-2, 3,-2},
{ 0,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-5,-1,-1,-1, 0, 0,-1,-1,-2,-1,-1,-1},
{-2,-2,-3,-2,-2, 3,-3, 2, 0,-1,-1, 0, 0,-2,-5,-3,-1,-1,-2,-1,-1,-1, 3,-1, 8,-2},
{-1, 2,-3, 1, 4,-3,-2, 0,-3,-1, 1,-2,-1, 0,-5,-1, 4, 0, 0,-1,-1,-3,-2,-1,-2, 4}
},{
//A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z
{ 4,-2, 0,-2,-1,-2, 0,-2,-1, 0,-1,-1,-1,-2,-4,-1,-1,-1, 1, 0, 0, 0,-3, 0,-2,-1},
{-2, 4,-3, 4, 1,-3,-1, 0,-3,-1, 0,-4,-3, 3,-4,-2, 0,-1, 0,-1,-1,-3,-4,-1,-3, 1},
{ 0,-3, 9,-3,-4,-2,-3,-3,-1,-2,-3,-1,-1,-3,-4,-3,-3,-3,-1,-1,-2,-1,-2,-2,-2,-3},
{-2, 4,-3, 6, 2,-3,-1,-1,-3,-1,-1,-4,-3, 1,-4,-1, 0,-2, 0,-1,-1,-3,-4,-1,-3, 1},
{-1, 1,-4, 2, 5,-3,-2, 0,-3,-1, 1,-3,-2, 0,-4,-1, 2, 0, 0,-1,-1,-2,-3,-1,-2, 4},
{-2,-3,-2,-3,-3, 6,-3,-1, 0,-1,-3, 0, 0,-3,-4,-4,-3,-3,-2,-2,-1,-1, 1,-1, 3,-3},
{ 0,-1,-3,-1,-2,-3, 6,-2,-4,-1,-2,-4,-3, 0,-4,-2,-2,-2, 0,-2,-1,-3,-2,-1,-3,-2},
{-2, 0,-3,-1, 0,-1,-2, 8,-3,-1,-1,-3,-2, 1,-4,-2, 0, 0,-1,-2,-1,-3,-2,-1, 2, 0},
{-1,-3,-1,-3,-3, 0,-4,-3, 4,-1,-3, 2, 1,-3,-4,-3,-3,-3,-2,-1,-1, 3,-3,-1,-1,-3},
{ 0,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-4,-2,-1,-1, 0, 0,-1,-1,-2,-1,-1,-1},
{-1, 0,-3,-1, 1,-3,-2,-1,-3,-1, 5,-2,-1, 0,-4,-1, 1, 2, 0,-1,-1,-2,-3,-1,-2, 1},
{-1,-4,-1,-4,-3, 0,-4,-3, 2,-1,-2, 4, 2,-3,-4,-3,-2,-2,-2,-1,-1, 1,-2,-1,-1,-3},
{-1,-3,-1,-3,-2, 0,-3,-2, 1,-1,-1, 2, 5,-2,-4,-2, 0,-1,-1,-1,-1, 1,-1,-1,-1,-1},
{-2, 3,-3, 1, 0,-3, 0, 1,-3,-1, 0,-3,-2, 6,-4,-2, 0, 0, 1, 0,-1,-3,-4,-1,-2, 0},
{-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4},
{-1,-2,-3,-1,-1,-4,-2,-2,-3,-2,-1,-3,-2,-2,-4, 7,-1,-2,-1,-1,-2,-2,-4,-2,-3,-1},
{-1, 0,-3, 0, 2,-3,-2, 0,-3,-1, 1,-2, 0, 0,-4,-1, 5, 1, 0,-1,-1,-2,-2,-1,-1, 3},
{-1,-1,-3,-2, 0,-3,-2, 0,-3,-1, 2,-2,-1, 0,-4,-2, 1, 5,-1,-1,-1,-3,-3,-1,-2, 0},
{ 1, 0,-1, 0, 0,-2, 0,-1,-2, 0, 0,-2,-1, 1,-4,-1, 0,-1, 4, 1, 0,-2,-3, 0,-2, 0},
{ 0,-1,-1,-1,-1,-2,-2,-2,-1, 0,-1,-1,-1, 0,-4,-1,-1,-1, 1, 5, 0, 0,-2, 0,-2,-1},
{ 0,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-4,-2,-1,-1, 0, 0,-1,-1,-2,-1,-1,-1},
{ 0,-3,-1,-3,-2,-1,-3,-3, 3,-1,-2, 1, 1,-3,-4,-2,-2,-3,-2, 0,-1, 4,-3,-1,-1,-2},
{-3,-4,-2,-4,-3, 1,-2,-2,-3,-2,-3,-2,-1,-4,-4,-4,-2,-3,-3,-2,-2,-3,11,-2, 2,-3},
{ 0,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-4,-2,-1,-1, 0, 0,-1,-1,-2,-1,-1,-1},
{-2,-3,-2,-3,-2, 3,-3, 2,-1,-1,-2,-1,-1,-2,-4,-3,-1,-2,-2,-2,-1,-1, 2,-1, 7,-2},
{-1, 1,-3, 1, 4,-3,-2, 0,-3,-1, 1,-3,-1, 0,-4,-1, 3, 0, 0,-1,-1,-2,-3,-1,-2, 4}
},{
//A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z
{ 5,-2,-1,-2,-1,-3, 0,-2,-2,-1,-1,-2,-1,-2,-6,-1,-1,-2, 1, 0,-1, 0,-3,-1,-2,-1},
{-2, 4,-4, 4, 1,-4,-1,-1,-4,-2,-1,-4,-3, 4,-6,-2, 0,-2, 0,-1,-2,-4,-5,-2,-3, 0},
{-1,-4, 9,-4,-5,-3,-4,-4,-2,-3,-4,-2,-2,-3,-6,-4,-4,-4,-2,-1,-3,-1,-3,-3,-3,-4},
{-2, 4,-4, 6, 1,-4,-2,-2,-4,-2,-1,-5,-4, 1,-6,-2,-1,-2,-1,-1,-2,-4,-6,-2,-4, 1},
{-1, 1,-5, 1, 6,-4,-3, 0,-4,-1, 1,-4,-2,-1,-6,-2, 2,-1, 0,-1,-1,-3,-4,-1,-3, 4},
{-3,-4,-3,-4,-4, 6,-4,-2,-1,-2,-4, 0, 0,-4,-6,-4,-4,-4,-3,-2,-2,-1, 0,-2, 3,-4},
{ 0,-1,-4,-2,-3,-4, 6,-3,-5,-2,-2,-4,-4,-1,-6,-3,-2,-3,-1,-2,-2,-4,-4,-2,-4,-3},
{-2,-1,-4,-2, 0,-2,-3, 8,-4,-2,-1,-3,-2, 0,-6,-3, 1, 0,-1,-2,-2,-4,-3,-2, 2, 0},
{-2,-4,-2,-4,-4,-1,-5,-4, 5,-2,-3, 1, 1,-4,-6,-4,-3,-3,-3,-1,-2, 3,-3,-2,-2,-4},
{-1,-2,-3,-2,-1,-2,-2,-2,-2,-1,-1,-2,-1,-1,-6,-2,-1,-1,-1,-1,-1,-1,-3,-1,-2,-1},
{-1,-1,-4,-1, 1,-4,-2,-1,-3,-1, 5,-3,-2, 0,-6,-1, 1, 2,-1,-1,-1,-3,-4,-1,-3, 1},
{-2,-4,-2,-5,-4, 0,-4,-3, 1,-2,-3, 4, 2,-4,-6,-3,-3,-3,-3,-2,-2, 1,-2,-2,-2,-3},
{-1,-3,-2,-4,-2, 0,-4,-2, 1,-1,-2, 2, 6,-3,-6,-3, 0,-2,-2,-1,-1, 1,-2,-1,-2,-2},
{-2, 4,-3, 1,-1,-4,-1, 0,-4,-1, 0,-4,-3, 6,-6,-3, 0,-1, 0, 0,-1,-4,-4,-1,-3, 0},
{-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 4,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6},
{-1,-2,-4,-2,-2,-4,-3,-3,-4,-2,-1,-3,-3,-3,-6, 8,-2,-2,-1,-2,-2,-3,-5,-2,-4,-2},
{-1, 0,-4,-1, 2,-4,-2, 1,-3,-1, 1,-3, 0, 0,-6,-2, 6, 1, 0,-1,-1,-3,-3,-1,-2, 3},
{-2,-2,-4,-2,-1,-4,-3, 0,-3,-1, 2,-3,-2,-1,-6,-2, 1, 6,-1,-1,-1,-3,-4,-1,-3, 0},
{ 1, 0,-2,-1, 0,-3,-1,-1,-3,-1,-1,-3,-2, 0,-6,-1, 0,-1, 5, 1,-1,-2,-4,-1,-2, 0},
{ 0,-1,-1,-1,-1,-2,-2,-2,-1,-1,-1,-2,-1, 0,-6,-2,-1,-1, 1, 5,-1, 0,-4,-1,-2,-1},
{-1,-2,-3,-2,-1,-2,-2,-2,-2,-1,-1,-2,-1,-1,-6,-2,-1,-1,-1,-1,-1,-1,-3,-1,-2,-1},
{ 0,-4,-1,-4,-3,-1,-4,-4, 3,-1,-3, 1, 1,-4,-6,-3,-3,-3,-2, 0,-1, 4,-3,-1,-2,-3},
{-3,-5,-3,-6,-4, 0,-4,-3,-3,-3,-4,-2,-2,-4,-6,-5,-3,-4,-4,-4,-3,-3,11,-3, 2,-4},
{-1,-2,-3,-2,-1,-2,-2,-2,-2,-1,-1,-2,-1,-1,-6,-2,-1,-1,-1,-1,-1,-1,-3,-1,-2,-1},
{-2,-3,-3,-4,-3, 3,-4, 2,-2,-2,-3,-2,-2,-3,-6,-4,-2,-3,-2,-2,-2,-2, 2,-2, 7,-3},
{-1, 0,-4, 1, 4,-4,-3, 0,-4,-1, 1,-3,-2, 0,-6,-2, 3, 0, 0,-1,-1,-3,-4,-1,-3, 4}
}};

#endif // #ifndef __SW_ALIGNSCORE_HH
