<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [goBack](./puppeteer.page.goback.md)

## Page.goBack() method

This method navigate to the previous page in history.

<b>Signature:</b>

```typescript
goBack(options?: WaitForOptions): Promise<HTTPResponse | null>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [WaitForOptions](./puppeteer.waitforoptions.md) | Navigation parameters |

<b>Returns:</b>

Promise&lt;[HTTPResponse](./puppeteer.httpresponse.md) \| null&gt;

Promise which resolves to the main resource response. In case of multiple redirects, the navigation will resolve with the response of the last redirect. If can not go back, resolves to `null`.

## Remarks

The argument `options` might have the following properties:

- `timeout` : Maximum navigation time in milliseconds, defaults to 30 seconds, pass 0 to disable timeout. The default value can be changed by using the [page.setDefaultNavigationTimeout(timeout)](./puppeteer.page.setdefaultnavigationtimeout.md) or [page.setDefaultTimeout(timeout)](./puppeteer.page.setdefaulttimeout.md) methods.

- `waitUntil` : When to consider navigation succeeded, defaults to `load`. Given an array of event strings, navigation is considered to be successful after all events have been fired. Events can be either:<br/> - `load` : consider navigation to be finished when the load event is fired.<br/> - `domcontentloaded` : consider navigation to be finished when the DOMContentLoaded event is fired.<br/> - `networkidle0` : consider navigation to be finished when there are no more than 0 network connections for at least `500` ms.<br/> - `networkidle2` : consider navigation to be finished when there are no more than 2 network connections for at least `500` ms.

