//                                               -*- C++ -*-
/**
 * @file  t_ComputedNumericalMathEvaluationImplementation_std.cxx
 * @brief The test file of class ComputedNumericalMathEvaluationImplementation for standard methods
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012)
 */
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try
  {

    try
    {
      // Test basic functionnalities
      //checkClassWithClassName<ComputedNumericalMathEvaluationImplementation>();


      // Test function operator ()
      // ComputedNumericalMathEvaluationImplementation myFunction("wrapper");
      ComputedNumericalMathEvaluationImplementation myFunctionImpl = ComputedNumericalMathEvaluationImplementation( "wrapper", WrapperFile::FindWrapperByName( "wrapper" ) );
      NumericalPoint inPoint(3);
      inPoint[0] = 10;
      inPoint[1] = 20;
      inPoint[1] = 30;
      NumericalPoint outPoint = myFunctionImpl( inPoint );
      fullprint << myFunctionImpl.getName() << "( " << inPoint << " ) = " << outPoint << std::endl;

      // Normally, we should never go here
      throw TestFailed("Exception has NOT been thrown or catched !");

    }
    catch (NoWrapperFileFoundException & ex)
    {
      throw TestFailed(ex.__repr__());
    }
    catch (InvalidArgumentException & ex)
    {
      // Nothing to do
    }


  }
  catch (TestFailed & ex)
  {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
