/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseSensorNode
extends AbstractNode
implements VRMLSensorNodeType {
    protected static final int FIELD_ENABLED = 1;
    protected static final int FIELD_IS_ACTIVE = 2;
    protected static final int LAST_SENSOR_INDEX = 2;
    protected boolean vfEnabled = true;
    protected boolean vfIsActive = false;

    protected BaseSensorNode(String string) {
        super(string);
    }

    protected void copy(VRMLSensorNodeType vRMLSensorNodeType) {
        try {
            int n = vRMLSensorNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLSensorNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.vfEnabled) {
            this.vfEnabled = bl;
            if (!this.inSetup) {
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
            }
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 1: {
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }
}

