# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationUpdateContract(Model):
    """Api Operation Update Contract details.

    :param template_parameters: Collection of URL template parameters.
    :type template_parameters:
     list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML
     formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies
    :type policies: str
    :param display_name: Operation Name.
    :type display_name: str
    :param method: A Valid HTTP Operation Method. Typical Http Methods like
     GET, PUT, POST but not limited by only them.
    :type method: str
    :param url_template: Relative URL template identifying the target resource
     for this operation. May include parameters. Example:
     /customers/{cid}/orders/{oid}/?date={date}
    :type url_template: str
    """

    _validation = {
        'description': {'max_length': 1000},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'properties.templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'RequestContract'},
        'responses': {'key': 'properties.responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'properties.policies', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
        'url_template': {'key': 'properties.urlTemplate', 'type': 'str'},
    }

    def __init__(self, *, template_parameters=None, description: str=None, request=None, responses=None, policies: str=None, display_name: str=None, method: str=None, url_template: str=None, **kwargs) -> None:
        super(OperationUpdateContract, self).__init__(**kwargs)
        self.template_parameters = template_parameters
        self.description = description
        self.request = request
        self.responses = responses
        self.policies = policies
        self.display_name = display_name
        self.method = method
        self.url_template = url_template
