
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Prs3d_Drawer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <HLRBRep_Data.hxx>
#include <TopoDS_Shape.hxx>
#include <HLRAlgo_Projector.hxx>
#include <BRepAdaptor_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_ArrayOfSegments.hxx>
#include <Graphic3d_ArrayOfTriangles.hxx>
#include <TopoDS_Shape.hxx>
#include <BRep_Builder.hxx>
#include <TopoDS_Compound.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Bnd_Box.hxx>
#include <Poly_Triangulation.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Polygon3D.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Point.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Prs3d_Drawer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Vertex.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_ArrayOfPoints.hxx>
#include <Adaptor2d_Curve2d.hxx>

// module includes
#include <StdPrs_BndBox.hxx>
#include <StdPrs_BRepFont.hxx>
#include <StdPrs_BRepTextBuilder.hxx>
#include <StdPrs_Curve.hxx>
#include <StdPrs_DeflectionCurve.hxx>
#include <StdPrs_HLRPolyShape.hxx>
#include <StdPrs_HLRShape.hxx>
#include <StdPrs_HLRShapeI.hxx>
#include <StdPrs_HLRToolShape.hxx>
#include <StdPrs_Isolines.hxx>
#include <StdPrs_Plane.hxx>
#include <StdPrs_Point.hxx>
#include <StdPrs_PoleCurve.hxx>
#include <StdPrs_ShadedShape.hxx>
#include <StdPrs_ShadedSurface.hxx>
#include <StdPrs_ShapeTool.hxx>
#include <StdPrs_ToolPoint.hxx>
#include <StdPrs_ToolRFace.hxx>
#include <StdPrs_ToolTriangulatedShape.hxx>
#include <StdPrs_ToolVertex.hxx>
#include <StdPrs_Vertex.hxx>
#include <StdPrs_Volume.hxx>
#include <StdPrs_WFDeflectionRestrictedFace.hxx>
#include <StdPrs_WFDeflectionSurface.hxx>
#include <StdPrs_WFPoleSurface.hxx>
#include <StdPrs_WFRestrictedFace.hxx>
#include <StdPrs_WFShape.hxx>
#include <StdPrs_WFSurface.hxx>

// template related includes

// ./opencascade/StdPrs_Point.hxx
#include "Prs3d_tmpl.hxx"

// ./opencascade/StdPrs_Vertex.hxx
#include "Prs3d_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_StdPrs(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StdPrs"));
py::object klass;

//Python trampoline classes
    class Py_StdPrs_HLRShapeI : public StdPrs_HLRShapeI{
    public:
        using StdPrs_HLRShapeI::StdPrs_HLRShapeI;


        // public pure virtual
        void ComputeHLR(const opencascade::handle<Prs3d_Presentation> & thePrs,const TopoDS_Shape & theShape,const opencascade::handle<Prs3d_Drawer> & theDrawer,const opencascade::handle<Graphic3d_Camera> & theProjector) const  override { PYBIND11_OVERLOAD_PURE(void,StdPrs_HLRShapeI,ComputeHLR,thePrs,theShape,theDrawer,theProjector) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class StdPrs_BRepFont from ./opencascade/StdPrs_BRepFont.hxx
    klass = m.attr("StdPrs_BRepFont");


    // nested enums

    static_cast<py::class_<StdPrs_BRepFont ,opencascade::handle<StdPrs_BRepFont>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const NCollection_Utf8String &,const Standard_Real,const Standard_Integer >()  , py::arg("theFontPath"),  py::arg("theSize"),  py::arg("theFaceId")=static_cast<const Standard_Integer>(0) )
        .def(py::init<  const NCollection_Utf8String &,const Font_FontAspect,const Standard_Real,const Font_StrictLevel >()  , py::arg("theFontName"),  py::arg("theFontAspect"),  py::arg("theSize"),  py::arg("theStrictLevel")=static_cast<const Font_StrictLevel>(Font_StrictLevel_Any) )
    // custom constructors
    // methods
        .def("Release",
             (void (StdPrs_BRepFont::*)() ) static_cast<void (StdPrs_BRepFont::*)() >(&StdPrs_BRepFont::Release),
             R"#(Release currently loaded font.)#" 
          )
        .def("Init",
             (bool (StdPrs_BRepFont::*)(  const NCollection_Utf8String & ,  const Standard_Real ,  const Standard_Integer  ) ) static_cast<bool (StdPrs_BRepFont::*)(  const NCollection_Utf8String & ,  const Standard_Real ,  const Standard_Integer  ) >(&StdPrs_BRepFont::Init),
             R"#(Initialize the font.)#"  , py::arg("theFontPath"),  py::arg("theSize"),  py::arg("theFaceId")
          )
        .def("FindAndInit",
             (bool (StdPrs_BRepFont::*)( const TCollection_AsciiString & ,  const Font_FontAspect ,  const Standard_Real ,  const Font_StrictLevel  ) ) static_cast<bool (StdPrs_BRepFont::*)( const TCollection_AsciiString & ,  const Font_FontAspect ,  const Standard_Real ,  const Font_StrictLevel  ) >(&StdPrs_BRepFont::FindAndInit),
             R"#(Find (using Font_FontMgr) and initialize the font from the given name. Please take into account that size is specified NOT in typography points (pt.). If you need to specify size in points, value should be converted. Formula for pt. -> m conversion: aSizeMeters = 0.0254 * theSizePt / 72.0)#"  , py::arg("theFontName"),  py::arg("theFontAspect"),  py::arg("theSize"),  py::arg("theStrictLevel")=static_cast<const Font_StrictLevel>(Font_StrictLevel_Any)
          )
        .def("RenderGlyph",
             (TopoDS_Shape (StdPrs_BRepFont::*)( const Standard_Utf32Char &  ) ) static_cast<TopoDS_Shape (StdPrs_BRepFont::*)( const Standard_Utf32Char &  ) >(&StdPrs_BRepFont::RenderGlyph),
             R"#(Render single glyph as TopoDS_Shape.)#"  , py::arg("theChar")
          )
        .def("SetCompositeCurveMode",
             (void (StdPrs_BRepFont::*)( const Standard_Boolean  ) ) static_cast<void (StdPrs_BRepFont::*)( const Standard_Boolean  ) >(&StdPrs_BRepFont::SetCompositeCurveMode),
             R"#(Setup glyph geometry construction mode. By default algorithm creates independent TopoDS_Edge for each original curve in the glyph (line segment or Bezie curve). Algorithm might optionally create composite BSpline curve for each contour which reduces memory footprint but limits curve class to C0. Notice that altering this flag clears currently accumulated cache!)#"  , py::arg("theToConcatenate")
          )
        .def("SetWidthScaling",
             (void (StdPrs_BRepFont::*)( const float  ) ) static_cast<void (StdPrs_BRepFont::*)( const float  ) >(&StdPrs_BRepFont::SetWidthScaling),
             R"#(Setup glyph scaling along X-axis. By default glyphs are not scaled (scaling factor = 1.0))#"  , py::arg("theScaleFactor")
          )
        .def("Ascender",
             (Standard_Real (StdPrs_BRepFont::*)() const) static_cast<Standard_Real (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::Ascender),
             R"#(Returns vertical distance from the horizontal baseline to the highest character coordinate.)#" 
          )
        .def("Descender",
             (Standard_Real (StdPrs_BRepFont::*)() const) static_cast<Standard_Real (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::Descender),
             R"#(Returns vertical distance from the horizontal baseline to the lowest character coordinate.)#" 
          )
        .def("LineSpacing",
             (Standard_Real (StdPrs_BRepFont::*)() const) static_cast<Standard_Real (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::LineSpacing),
             R"#(Returns default line spacing (the baseline-to-baseline distance).)#" 
          )
        .def("PointSize",
             (Standard_Real (StdPrs_BRepFont::*)() const) static_cast<Standard_Real (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::PointSize),
             R"#(Configured point size)#" 
          )
        .def("AdvanceX",
             (Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char  ) ) static_cast<Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char  ) >(&StdPrs_BRepFont::AdvanceX),
             R"#(Compute advance to the next character with kerning applied when applicable. Assuming text rendered horizontally.)#"  , py::arg("theUCharNext")
          )
        .def("AdvanceX",
             (Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char ,  const Standard_Utf32Char  ) ) static_cast<Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char ,  const Standard_Utf32Char  ) >(&StdPrs_BRepFont::AdvanceX),
             R"#(Compute advance to the next character with kerning applied when applicable. Assuming text rendered horizontally.)#"  , py::arg("theUChar"),  py::arg("theUCharNext")
          )
        .def("AdvanceY",
             (Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char  ) ) static_cast<Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char  ) >(&StdPrs_BRepFont::AdvanceY),
             R"#(Compute advance to the next character with kerning applied when applicable. Assuming text rendered vertically.)#"  , py::arg("theUCharNext")
          )
        .def("AdvanceY",
             (Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char ,  const Standard_Utf32Char  ) ) static_cast<Standard_Real (StdPrs_BRepFont::*)( const Standard_Utf32Char ,  const Standard_Utf32Char  ) >(&StdPrs_BRepFont::AdvanceY),
             R"#(Compute advance to the next character with kerning applied when applicable. Assuming text rendered vertically.)#"  , py::arg("theUChar"),  py::arg("theUCharNext")
          )
        .def("Scale",
             (Standard_Real (StdPrs_BRepFont::*)() const) static_cast<Standard_Real (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::Scale),
             R"#(Returns scaling factor for current font size.)#" 
          )
        .def("Init",
             (bool (StdPrs_BRepFont::*)(  const NCollection_Utf8String & ,  const Font_FontAspect ,  const Standard_Real  ) ) static_cast<bool (StdPrs_BRepFont::*)(  const NCollection_Utf8String & ,  const Font_FontAspect ,  const Standard_Real  ) >(&StdPrs_BRepFont::Init),
             R"#(Find (using Font_FontMgr) and initialize the font from the given name. Alias for FindAndInit() for backward compatibility.)#"  , py::arg("theFontName"),  py::arg("theFontAspect"),  py::arg("theSize")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdPrs_BRepFont::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdPrs_BRepFont::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("FindAndCreate_s",
                    (opencascade::handle<StdPrs_BRepFont> (*)( const TCollection_AsciiString & ,  const Font_FontAspect ,  const Standard_Real ,  const Font_StrictLevel  ) ) static_cast<opencascade::handle<StdPrs_BRepFont> (*)( const TCollection_AsciiString & ,  const Font_FontAspect ,  const Standard_Real ,  const Font_StrictLevel  ) >(&StdPrs_BRepFont::FindAndCreate),
                    R"#(Find the font Initialize the font.)#"  , py::arg("theFontName"),  py::arg("theFontAspect"),  py::arg("theSize"),  py::arg("theStrictLevel")=static_cast<const Font_StrictLevel>(Font_StrictLevel_Any)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdPrs_BRepFont::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::DynamicType),
             R"#(None)#"
             
         )
       .def("FTFont",
             (const opencascade::handle<Font_FTFont> & (StdPrs_BRepFont::*)() const) static_cast<const opencascade::handle<Font_FTFont> & (StdPrs_BRepFont::*)() const>(&StdPrs_BRepFont::FTFont),
             R"#(Return wrapper over FreeType font.)#"
             
         )
       .def("Mutex",
             (Standard_Mutex & (StdPrs_BRepFont::*)() ) static_cast<Standard_Mutex & (StdPrs_BRepFont::*)() >(&StdPrs_BRepFont::Mutex),
             R"#(Returns mutex.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class StdPrs_BRepTextBuilder from ./opencascade/StdPrs_BRepTextBuilder.hxx
    klass = m.attr("StdPrs_BRepTextBuilder");

    // default constructor
    register_default_constructor<StdPrs_BRepTextBuilder , shared_ptr<StdPrs_BRepTextBuilder>>(m,"StdPrs_BRepTextBuilder");

    // nested enums

    static_cast<py::class_<StdPrs_BRepTextBuilder , shared_ptr<StdPrs_BRepTextBuilder>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Perform",
             (TopoDS_Shape (StdPrs_BRepTextBuilder::*)( StdPrs_BRepFont & ,  const opencascade::handle<Font_TextFormatter> & ,  const gp_Ax3 &  ) ) static_cast<TopoDS_Shape (StdPrs_BRepTextBuilder::*)( StdPrs_BRepFont & ,  const opencascade::handle<Font_TextFormatter> & ,  const gp_Ax3 &  ) >(&StdPrs_BRepTextBuilder::Perform),
             R"#(Render text as BRep shape.)#"  , py::arg("theFont"),  py::arg("theFormatter"),  py::arg("thePenLoc")=static_cast<const gp_Ax3 &>(gp_Ax3 ( ))
          )
        .def("Perform",
             (TopoDS_Shape (StdPrs_BRepTextBuilder::*)( StdPrs_BRepFont & ,   const NCollection_Utf8String & ,  const gp_Ax3 & ,  const Graphic3d_HorizontalTextAlignment ,  const Graphic3d_VerticalTextAlignment  ) ) static_cast<TopoDS_Shape (StdPrs_BRepTextBuilder::*)( StdPrs_BRepFont & ,   const NCollection_Utf8String & ,  const gp_Ax3 & ,  const Graphic3d_HorizontalTextAlignment ,  const Graphic3d_VerticalTextAlignment  ) >(&StdPrs_BRepTextBuilder::Perform),
             R"#(Render text as BRep shape.)#"  , py::arg("theFont"),  py::arg("theString"),  py::arg("thePenLoc")=static_cast<const gp_Ax3 &>(gp_Ax3 ( )),  py::arg("theHAlign")=static_cast<const Graphic3d_HorizontalTextAlignment>(Graphic3d_HTA_LEFT),  py::arg("theVAlign")=static_cast<const Graphic3d_VerticalTextAlignment>(Graphic3d_VTA_BOTTOM)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_Curve from ./opencascade/StdPrs_Curve.hxx
    klass = m.attr("StdPrs_Curve");

    // default constructor
    register_default_constructor<StdPrs_Curve , shared_ptr<StdPrs_Curve>>(m,"StdPrs_Curve");

    // nested enums

    static_cast<py::class_<StdPrs_Curve , shared_ptr<StdPrs_Curve>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) >(&StdPrs_Curve::Add),
                    R"#(Adds to the presentation aPresentation the drawing of the curve aCurve. The aspect is defined by LineAspect in aDrawer. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("aDrawer"),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) >(&StdPrs_Curve::Add),
                    R"#(Adds to the presentation aPresentation the drawing of the curve aCurve. The aspect is defined by LineAspect in aDrawer. The drawing will be limited between the points of parameter U1 and U2. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("aDrawer"),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Boolean  ) >(&StdPrs_Curve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve. The aspect is the current aspect. aDeflection is used in the circle case. Points give a sequence of curve points. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("aDrawer"),  py::arg("Points"),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Integer ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Integer ,  const Standard_Boolean  ) >(&StdPrs_Curve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve. The aspect is the current aspect. The drawing will be limited between the points of parameter U1 and U2. aDeflection is used in the circle case. Points give a sequence of curve points. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("Points"),  py::arg("aNbPoints")=static_cast<const Standard_Integer>(30),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_Curve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the drawing of the curve is less than aDistance.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) >(&StdPrs_Curve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the drawing of the curve is less than aDistance.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("aDeflection"),  py::arg("aLimit"),  py::arg("aNbPoints")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_Curve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the drawing of the curve aCurve is less than aDistance. The drawing is considered between the points of parameter U1 and U2;)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) >(&StdPrs_Curve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the drawing of the curve aCurve is less than aDistance. The drawing is considered between the points of parameter U1 and U2;)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("aDeflection"),  py::arg("aNbPoints")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_DeflectionCurve from ./opencascade/StdPrs_DeflectionCurve.hxx
    klass = m.attr("StdPrs_DeflectionCurve");

    // default constructor
    register_default_constructor<StdPrs_DeflectionCurve , shared_ptr<StdPrs_DeflectionCurve>>(m,"StdPrs_DeflectionCurve");

    // nested enums

    static_cast<py::class_<StdPrs_DeflectionCurve , shared_ptr<StdPrs_DeflectionCurve>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) >(&StdPrs_DeflectionCurve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve with respect to the maximal chordial deviation defined by the drawer aDrawer. The aspect is defined by LineAspect in aDrawer. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("aDrawer"),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) >(&StdPrs_DeflectionCurve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve with respect to the maximal chordial deviation defined by the drawer aDrawer. The aspect is defined by LineAspect in aDrawer. The drawing will be limited between the points of parameter U1 and U2. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("aDrawer"),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean  ) >(&StdPrs_DeflectionCurve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve with respect to the maximal chordial deviation aDeflection. The aspect is the current aspect If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("aDeflection"),  py::arg("aLimit"),  py::arg("anAngle")=static_cast<const Standard_Real>(0.2),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Boolean  ) >(&StdPrs_DeflectionCurve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve with respect to the maximal chordial deviation aDeflection. The aspect is the current aspect Points give a sequence of curve points. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("aDeflection"),  py::arg("aDrawer"),  py::arg("Points"),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Real ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  NCollection_Sequence<gp_Pnt> & ,  const Standard_Real ,  const Standard_Boolean  ) >(&StdPrs_DeflectionCurve::Add),
                    R"#(adds to the presentation aPresentation the drawing of the curve aCurve with respect to the maximal chordial deviation aDeflection. The aspect is the current aspect The drawing will be limited between the points of parameter U1 and U2. Points give a sequence of curve points. If drawCurve equals Standard_False the curve will not be displayed, it is used if the curve is a part of some shape and PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("aDeflection"),  py::arg("Points"),  py::arg("anAngle")=static_cast<const Standard_Real>(0.2),  py::arg("drawCurve")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_DeflectionCurve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the drawing of the curve aCurve with respect of the maximal chordial deviation defined by the drawer aDrawer is less then aDistance.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_DeflectionCurve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the drawing of the curve aCurve with respect of the maximal chordial deviation defined by the drawer aDrawer is less then aDistance. The drawing is considered between the points of parameter U1 and U2;)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("U1"),  py::arg("U2"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) >(&StdPrs_DeflectionCurve::Match),
                    R"#(Returns true if the distance between the point (theX, theY, theZ) and the drawing with respect of the maximal chordial deviation theDeflection is less then theDistance.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ"),  py::arg("theDistance"),  py::arg("theCurve"),  py::arg("theDeflection"),  py::arg("theLimit"),  py::arg("theAngle")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) >(&StdPrs_DeflectionCurve::Match),
                    R"#(Returns true if the distance between the point (theX, theY, theZ) and the drawing with respect of the maximal chordial deviation theDeflection is less then theDistance. The drawing is considered between the points of parameter theU1 and theU2.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ"),  py::arg("theDistance"),  py::arg("theCurve"),  py::arg("theU1"),  py::arg("theU2"),  py::arg("theDeflection"),  py::arg("theAngle")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_HLRShapeI from ./opencascade/StdPrs_HLRShapeI.hxx
    klass = m.attr("StdPrs_HLRShapeI");


    // nested enums

    static_cast<py::class_<StdPrs_HLRShapeI ,opencascade::handle<StdPrs_HLRShapeI> ,Py_StdPrs_HLRShapeI , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ComputeHLR",
             (void (StdPrs_HLRShapeI::*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const opencascade::handle<Graphic3d_Camera> &  ) const) static_cast<void (StdPrs_HLRShapeI::*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const opencascade::handle<Graphic3d_Camera> &  ) const>(&StdPrs_HLRShapeI::ComputeHLR),
             R"#(Compute presentation for specified shape.)#"  , py::arg("thePrs"),  py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theProjector")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdPrs_HLRShapeI::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdPrs_HLRShapeI::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdPrs_HLRShapeI::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdPrs_HLRShapeI::*)() const>(&StdPrs_HLRShapeI::DynamicType),
             R"#(None)#"
             
         )
;

    // Class StdPrs_HLRToolShape from ./opencascade/StdPrs_HLRToolShape.hxx
    klass = m.attr("StdPrs_HLRToolShape");


    // nested enums

    static_cast<py::class_<StdPrs_HLRToolShape , shared_ptr<StdPrs_HLRToolShape>  >>(klass)
    // constructors
        .def(py::init< const TopoDS_Shape &,const HLRAlgo_Projector & >()  , py::arg("TheShape"),  py::arg("TheProjector") )
    // custom constructors
    // methods
        .def("NbEdges",
             (Standard_Integer (StdPrs_HLRToolShape::*)() const) static_cast<Standard_Integer (StdPrs_HLRToolShape::*)() const>(&StdPrs_HLRToolShape::NbEdges),
             R"#(None)#" 
          )
        .def("InitVisible",
             (void (StdPrs_HLRToolShape::*)( const Standard_Integer  ) ) static_cast<void (StdPrs_HLRToolShape::*)( const Standard_Integer  ) >(&StdPrs_HLRToolShape::InitVisible),
             R"#(None)#"  , py::arg("EdgeNumber")
          )
        .def("MoreVisible",
             (Standard_Boolean (StdPrs_HLRToolShape::*)() const) static_cast<Standard_Boolean (StdPrs_HLRToolShape::*)() const>(&StdPrs_HLRToolShape::MoreVisible),
             R"#(None)#" 
          )
        .def("NextVisible",
             (void (StdPrs_HLRToolShape::*)() ) static_cast<void (StdPrs_HLRToolShape::*)() >(&StdPrs_HLRToolShape::NextVisible),
             R"#(None)#" 
          )
        .def("InitHidden",
             (void (StdPrs_HLRToolShape::*)( const Standard_Integer  ) ) static_cast<void (StdPrs_HLRToolShape::*)( const Standard_Integer  ) >(&StdPrs_HLRToolShape::InitHidden),
             R"#(None)#"  , py::arg("EdgeNumber")
          )
        .def("MoreHidden",
             (Standard_Boolean (StdPrs_HLRToolShape::*)() const) static_cast<Standard_Boolean (StdPrs_HLRToolShape::*)() const>(&StdPrs_HLRToolShape::MoreHidden),
             R"#(None)#" 
          )
        .def("NextHidden",
             (void (StdPrs_HLRToolShape::*)() ) static_cast<void (StdPrs_HLRToolShape::*)() >(&StdPrs_HLRToolShape::NextHidden),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
        .def("Visible",
             []( StdPrs_HLRToolShape &self , BRepAdaptor_Curve & TheEdge ){
                 Standard_Real  U1;
                Standard_Real  U2;

                 self.Visible(TheEdge,U1,U2);
                 
                 return std::make_tuple(U1,U2); },
             R"#(None)#"  , py::arg("TheEdge")
          )
        .def("Hidden",
             []( StdPrs_HLRToolShape &self , BRepAdaptor_Curve & TheEdge ){
                 Standard_Real  U1;
                Standard_Real  U2;

                 self.Hidden(TheEdge,U1,U2);
                 
                 return std::make_tuple(U1,U2); },
             R"#(None)#"  , py::arg("TheEdge")
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_Isolines from ./opencascade/StdPrs_Isolines.hxx
    klass = m.attr("StdPrs_Isolines");

    // default constructor
    register_default_constructor<StdPrs_Isolines , shared_ptr<StdPrs_Isolines>>(m,"StdPrs_Isolines");

    // nested enums

    static_cast<py::class_<StdPrs_Isolines , shared_ptr<StdPrs_Isolines>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real  ) >(&StdPrs_Isolines::Add),
                    R"#(Computes isolines presentation for a TopoDS face. This method chooses proper version of isoline builder algorithm : on triangulation or surface depending on the flag passed from Prs3d_Drawer attributes. This method is a default way to display isolines for a given TopoDS face.)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawer"),  py::arg("theDeflection")
          )
        .def_static("Add_s",
                    (void (*)( const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<void (*)( const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&StdPrs_Isolines::Add),
                    R"#(Computes isolines presentation for a TopoDS face. This method chooses proper version of isoline builder algorithm : on triangulation or surface depending on the flag passed from Prs3d_Drawer attributes. This method is a default way to display isolines for a given TopoDS face.)#"  , py::arg("theFace"),  py::arg("theDrawer"),  py::arg("theDeflection"),  py::arg("theUPolylines"),  py::arg("theVPolylines")
          )
        .def_static("AddOnTriangulation_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_Isolines::AddOnTriangulation),
                    R"#(Computes isolines on triangulation and adds them to a presentation.)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawer")
          )
        .def_static("AddOnTriangulation_s",
                    (void (*)( const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<void (*)( const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&StdPrs_Isolines::AddOnTriangulation),
                    R"#(Computes isolines on triangulation.)#"  , py::arg("theFace"),  py::arg("theDrawer"),  py::arg("theUPolylines"),  py::arg("theVPolylines")
          )
        .def_static("AddOnTriangulation_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Poly_Triangulation> & ,  const opencascade::handle<Geom_Surface> & ,  const TopLoc_Location & ,  const opencascade::handle<Prs3d_Drawer> & ,   const NCollection_Sequence<Standard_Real> & ,   const NCollection_Sequence<Standard_Real> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Poly_Triangulation> & ,  const opencascade::handle<Geom_Surface> & ,  const TopLoc_Location & ,  const opencascade::handle<Prs3d_Drawer> & ,   const NCollection_Sequence<Standard_Real> & ,   const NCollection_Sequence<Standard_Real> &  ) >(&StdPrs_Isolines::AddOnTriangulation),
                    R"#(Computes isolines on triangulation and adds them to a presentation.)#"  , py::arg("thePresentation"),  py::arg("theTriangulation"),  py::arg("theSurface"),  py::arg("theLocation"),  py::arg("theDrawer"),  py::arg("theUIsoParams"),  py::arg("theVIsoParams")
          )
        .def_static("AddOnSurface_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real  ) >(&StdPrs_Isolines::AddOnSurface),
                    R"#(Computes isolines on surface and adds them to presentation.)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawer"),  py::arg("theDeflection")
          )
        .def_static("AddOnSurface_s",
                    (void (*)( const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<void (*)( const TopoDS_Face & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&StdPrs_Isolines::AddOnSurface),
                    R"#(Computes isolines on surface and adds them to presentation.)#"  , py::arg("theFace"),  py::arg("theDrawer"),  py::arg("theDeflection"),  py::arg("theUPolylines"),  py::arg("theVPolylines")
          )
        .def_static("AddOnSurface_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real ,   const NCollection_Sequence<Standard_Real> & ,   const NCollection_Sequence<Standard_Real> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Real ,   const NCollection_Sequence<Standard_Real> & ,   const NCollection_Sequence<Standard_Real> &  ) >(&StdPrs_Isolines::AddOnSurface),
                    R"#(Computes isolines on surface and adds them to presentation.)#"  , py::arg("thePresentation"),  py::arg("theSurface"),  py::arg("theDrawer"),  py::arg("theDeflection"),  py::arg("theUIsoParams"),  py::arg("theVIsoParams")
          )
    // static methods using call by reference i.s.o. return
        .def_static("UVIsoParameters_s",
            [](const TopoDS_Face & theFace,const Standard_Integer theNbIsoU,const Standard_Integer theNbIsoV,const Standard_Real theUVLimit,NCollection_Sequence<Standard_Real> & theUIsoParams,NCollection_Sequence<Standard_Real> & theVIsoParams ){
                Standard_Real  theUmin;
                Standard_Real  theUmax;
                Standard_Real  theVmin;
                Standard_Real  theVmax;

                StdPrs_Isolines::UVIsoParameters(theFace,theNbIsoU,theNbIsoV,theUVLimit,theUIsoParams,theVIsoParams,theUmin,theUmax,theVmin,theVmax);
                
return std::make_tuple(theUmin,theUmax,theVmin,theVmax); },
            R"#(Evaluate sequence of parameters for drawing uv isolines for a given face.)#"  , py::arg("theFace"),  py::arg("theNbIsoU"),  py::arg("theNbIsoV"),  py::arg("theUVLimit"),  py::arg("theUIsoParams"),  py::arg("theVIsoParams")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_Plane from ./opencascade/StdPrs_Plane.hxx
    klass = m.attr("StdPrs_Plane");

    // default constructor
    register_default_constructor<StdPrs_Plane , shared_ptr<StdPrs_Plane>>(m,"StdPrs_Plane");

    // nested enums

    static_cast<py::class_<StdPrs_Plane , shared_ptr<StdPrs_Plane>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_Plane::Add),
                    R"#(Defines display of infinite planes. The infinite plane aPlane is added to the display aPresentation, and the attributes of the display are defined by the attribute manager aDrawer.)#"  , py::arg("aPresentation"),  py::arg("aPlane"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_Plane::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the plane is less than aDistance.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aPlane"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_PoleCurve from ./opencascade/StdPrs_PoleCurve.hxx
    klass = m.attr("StdPrs_PoleCurve");

    // default constructor
    register_default_constructor<StdPrs_PoleCurve , shared_ptr<StdPrs_PoleCurve>>(m,"StdPrs_PoleCurve");

    // nested enums

    static_cast<py::class_<StdPrs_PoleCurve , shared_ptr<StdPrs_PoleCurve>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_PoleCurve::Add),
                    R"#(Defines display of BSpline and Bezier curves. Adds the 3D curve aCurve to the StdPrs_PoleCurve algorithm. This shape is found in the presentation object aPresentation, and its display attributes are set in the attribute manager aDrawer. The curve object from Adaptor3d provides data from a Geom curve. This makes it possible to use the surface in a geometric algorithm.)#"  , py::arg("aPresentation"),  py::arg("aCurve"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_PoleCurve::Match),
                    R"#(returns true if the distance between the point (X,Y,Z) and the broken line made of the poles is less then aDistance.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("aDrawer")
          )
        .def_static("Pick_s",
                    (Standard_Integer (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Integer (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Adaptor3d_Curve & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_PoleCurve::Pick),
                    R"#(returns the pole the most near of the point (X,Y,Z) and returns its range. The distance between the pole and (X,Y,Z) must be less then aDistance. If no pole corresponds, 0 is returned.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aCurve"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_ShadedShape from ./opencascade/StdPrs_ShadedShape.hxx
    klass = m.attr("StdPrs_ShadedShape");

    // default constructor
    register_default_constructor<StdPrs_ShadedShape , shared_ptr<StdPrs_ShadedShape>>(m,"StdPrs_ShadedShape");

    // nested enums

    static_cast<py::class_<StdPrs_ShadedShape , shared_ptr<StdPrs_ShadedShape>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const StdPrs_Volume ,  const opencascade::handle<Graphic3d_Group> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const StdPrs_Volume ,  const opencascade::handle<Graphic3d_Group> &  ) >(&StdPrs_ShadedShape::Add),
                    R"#(Shades <theShape>.)#"  , py::arg("thePresentation"),  py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theVolume")=static_cast<const StdPrs_Volume>(StdPrs_Volume_Autodetection),  py::arg("theGroup")=static_cast<const opencascade::handle<Graphic3d_Group> &>(NULL)
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean ,  const gp_Pnt2d & ,  const gp_Pnt2d & ,  const gp_Pnt2d & ,  const StdPrs_Volume ,  const opencascade::handle<Graphic3d_Group> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean ,  const gp_Pnt2d & ,  const gp_Pnt2d & ,  const gp_Pnt2d & ,  const StdPrs_Volume ,  const opencascade::handle<Graphic3d_Group> &  ) >(&StdPrs_ShadedShape::Add),
                    R"#(Shades <theShape> with texture coordinates.)#"  , py::arg("thePresentation"),  py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theHasTexels"),  py::arg("theUVOrigin"),  py::arg("theUVRepeat"),  py::arg("theUVScale"),  py::arg("theVolume")=static_cast<const StdPrs_Volume>(StdPrs_Volume_Autodetection),  py::arg("theGroup")=static_cast<const opencascade::handle<Graphic3d_Group> &>(NULL)
          )
        .def_static("ExploreSolids_s",
                    (void (*)( const TopoDS_Shape & ,  const BRep_Builder & ,  TopoDS_Compound & ,  TopoDS_Compound & ,  const Standard_Boolean  ) ) static_cast<void (*)( const TopoDS_Shape & ,  const BRep_Builder & ,  TopoDS_Compound & ,  TopoDS_Compound & ,  const Standard_Boolean  ) >(&StdPrs_ShadedShape::ExploreSolids),
                    R"#(Searches closed and unclosed subshapes in shape structure and puts them into two compounds for separate processing of closed and unclosed sub-shapes)#"  , py::arg("theShape"),  py::arg("theBuilder"),  py::arg("theClosed"),  py::arg("theOpened"),  py::arg("theIgnore1DSubShape")
          )
        .def_static("AddWireframeForFreeElements_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_ShadedShape::AddWireframeForFreeElements),
                    R"#(Computes wireframe presentation for free wires and vertices)#"  , py::arg("thePrs"),  py::arg("theShape"),  py::arg("theDrawer")
          )
        .def_static("AddWireframeForFacesWithoutTriangles_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_ShadedShape::AddWireframeForFacesWithoutTriangles),
                    R"#(Computes special wireframe presentation for faces without triangulation.)#"  , py::arg("thePrs"),  py::arg("theShape"),  py::arg("theDrawer")
          )
        .def_static("FillTriangles_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const TopoDS_Shape &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const TopoDS_Shape &  ) >(&StdPrs_ShadedShape::FillTriangles),
                    R"#(Create primitive array with triangles for specified shape.)#"  , py::arg("theShape")
          )
        .def_static("FillTriangles_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const TopoDS_Shape & ,  const Standard_Boolean ,  const gp_Pnt2d & ,  const gp_Pnt2d & ,  const gp_Pnt2d &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const TopoDS_Shape & ,  const Standard_Boolean ,  const gp_Pnt2d & ,  const gp_Pnt2d & ,  const gp_Pnt2d &  ) >(&StdPrs_ShadedShape::FillTriangles),
                    R"#(Create primitive array of triangles for specified shape.)#"  , py::arg("theShape"),  py::arg("theHasTexels"),  py::arg("theUVOrigin"),  py::arg("theUVRepeat"),  py::arg("theUVScale")
          )
        .def_static("FillFaceBoundaries_s",
                    (opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const TopoDS_Shape & ,  GeomAbs_Shape  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const TopoDS_Shape & ,  GeomAbs_Shape  ) >(&StdPrs_ShadedShape::FillFaceBoundaries),
                    R"#(Define primitive array of boundary segments for specified shape.)#"  , py::arg("theShape"),  py::arg("theUpperContinuity")=static_cast<GeomAbs_Shape>(GeomAbs_CN)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_ShadedSurface from ./opencascade/StdPrs_ShadedSurface.hxx
    klass = m.attr("StdPrs_ShadedSurface");

    // default constructor
    register_default_constructor<StdPrs_ShadedSurface , shared_ptr<StdPrs_ShadedSurface>>(m,"StdPrs_ShadedSurface");

    // nested enums

    static_cast<py::class_<StdPrs_ShadedSurface , shared_ptr<StdPrs_ShadedSurface>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_ShadedSurface::Add),
                    R"#(Adds the surface aSurface to the presentation object aPresentation. The surface's display attributes are set in the attribute manager aDrawer. The surface object from Adaptor3d provides data from a Geom surface in order to use the surface in an algorithm.)#"  , py::arg("aPresentation"),  py::arg("aSurface"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_ShapeTool from ./opencascade/StdPrs_ShapeTool.hxx
    klass = m.attr("StdPrs_ShapeTool");


    // nested enums

    static_cast<py::class_<StdPrs_ShapeTool , shared_ptr<StdPrs_ShapeTool>  >>(klass)
    // constructors
        .def(py::init< const TopoDS_Shape &,const Standard_Boolean >()  , py::arg("theShape"),  py::arg("theAllVertices")=static_cast<const Standard_Boolean>(Standard_False) )
    // custom constructors
    // methods
        .def("InitFace",
             (void (StdPrs_ShapeTool::*)() ) static_cast<void (StdPrs_ShapeTool::*)() >(&StdPrs_ShapeTool::InitFace),
             R"#(None)#" 
          )
        .def("MoreFace",
             (Standard_Boolean (StdPrs_ShapeTool::*)() const) static_cast<Standard_Boolean (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::MoreFace),
             R"#(None)#" 
          )
        .def("NextFace",
             (void (StdPrs_ShapeTool::*)() ) static_cast<void (StdPrs_ShapeTool::*)() >(&StdPrs_ShapeTool::NextFace),
             R"#(None)#" 
          )
        .def("FaceBound",
             (Bnd_Box (StdPrs_ShapeTool::*)() const) static_cast<Bnd_Box (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::FaceBound),
             R"#(None)#" 
          )
        .def("IsPlanarFace",
             (Standard_Boolean (StdPrs_ShapeTool::*)() const) static_cast<Standard_Boolean (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::IsPlanarFace),
             R"#(None)#" 
          )
        .def("InitCurve",
             (void (StdPrs_ShapeTool::*)() ) static_cast<void (StdPrs_ShapeTool::*)() >(&StdPrs_ShapeTool::InitCurve),
             R"#(None)#" 
          )
        .def("MoreCurve",
             (Standard_Boolean (StdPrs_ShapeTool::*)() const) static_cast<Standard_Boolean (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::MoreCurve),
             R"#(None)#" 
          )
        .def("NextCurve",
             (void (StdPrs_ShapeTool::*)() ) static_cast<void (StdPrs_ShapeTool::*)() >(&StdPrs_ShapeTool::NextCurve),
             R"#(None)#" 
          )
        .def("CurveBound",
             (Bnd_Box (StdPrs_ShapeTool::*)() const) static_cast<Bnd_Box (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::CurveBound),
             R"#(None)#" 
          )
        .def("Neighbours",
             (Standard_Integer (StdPrs_ShapeTool::*)() const) static_cast<Standard_Integer (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::Neighbours),
             R"#(None)#" 
          )
        .def("FacesOfEdge",
             (opencascade::handle<TopTools_HSequenceOfShape> (StdPrs_ShapeTool::*)() const) static_cast<opencascade::handle<TopTools_HSequenceOfShape> (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::FacesOfEdge),
             R"#(None)#" 
          )
        .def("InitVertex",
             (void (StdPrs_ShapeTool::*)() ) static_cast<void (StdPrs_ShapeTool::*)() >(&StdPrs_ShapeTool::InitVertex),
             R"#(None)#" 
          )
        .def("MoreVertex",
             (Standard_Boolean (StdPrs_ShapeTool::*)() const) static_cast<Standard_Boolean (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::MoreVertex),
             R"#(None)#" 
          )
        .def("NextVertex",
             (void (StdPrs_ShapeTool::*)() ) static_cast<void (StdPrs_ShapeTool::*)() >(&StdPrs_ShapeTool::NextVertex),
             R"#(None)#" 
          )
        .def("HasSurface",
             (Standard_Boolean (StdPrs_ShapeTool::*)() const) static_cast<Standard_Boolean (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::HasSurface),
             R"#(None)#" 
          )
        .def("CurrentTriangulation",
             (opencascade::handle<Poly_Triangulation> (StdPrs_ShapeTool::*)( TopLoc_Location &  ) const) static_cast<opencascade::handle<Poly_Triangulation> (StdPrs_ShapeTool::*)( TopLoc_Location &  ) const>(&StdPrs_ShapeTool::CurrentTriangulation),
             R"#(None)#"  , py::arg("l")
          )
        .def("HasCurve",
             (Standard_Boolean (StdPrs_ShapeTool::*)() const) static_cast<Standard_Boolean (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::HasCurve),
             R"#(None)#" 
          )
        .def("Polygon3D",
             (opencascade::handle<Poly_Polygon3D> (StdPrs_ShapeTool::*)( TopLoc_Location &  ) const) static_cast<opencascade::handle<Poly_Polygon3D> (StdPrs_ShapeTool::*)( TopLoc_Location &  ) const>(&StdPrs_ShapeTool::Polygon3D),
             R"#(None)#"  , py::arg("l")
          )
    // methods using call by reference i.s.o. return
        .def("PolygonOnTriangulation",
             []( StdPrs_ShapeTool &self , Poly_PolygonOnTriangulation& Indices,Poly_Triangulation& T,TopLoc_Location & l ){
                 opencascade::handle<Poly_PolygonOnTriangulation>  Indices_ptr; Indices_ptr = &Indices;
                opencascade::handle<Poly_Triangulation>  T_ptr; T_ptr = &T;

                 self.PolygonOnTriangulation(Indices_ptr,T_ptr,l);
                 if ( Indices_ptr.get() != &Indices ) copy_if_copy_constructible(Indices, *Indices_ptr);
                if ( T_ptr.get() != &T ) copy_if_copy_constructible(T, *T_ptr);

                 return std::make_tuple(); },
             R"#(None)#"  , py::arg("Indices"),  py::arg("T"),  py::arg("l")
          )
    // static methods
        .def_static("IsPlanarFace_s",
                    (Standard_Boolean (*)( const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Face &  ) >(&StdPrs_ShapeTool::IsPlanarFace),
                    R"#(None)#"  , py::arg("theFace")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetFace",
             (const TopoDS_Face & (StdPrs_ShapeTool::*)() const) static_cast<const TopoDS_Face & (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::GetFace),
             R"#(None)#"
             
         )
       .def("GetCurve",
             (const TopoDS_Edge & (StdPrs_ShapeTool::*)() const) static_cast<const TopoDS_Edge & (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::GetCurve),
             R"#(None)#"
             
         )
       .def("GetVertex",
             (const TopoDS_Vertex & (StdPrs_ShapeTool::*)() const) static_cast<const TopoDS_Vertex & (StdPrs_ShapeTool::*)() const>(&StdPrs_ShapeTool::GetVertex),
             R"#(None)#"
             
         )
;

    // Class StdPrs_ToolPoint from ./opencascade/StdPrs_ToolPoint.hxx
    klass = m.attr("StdPrs_ToolPoint");

    // default constructor
    register_default_constructor<StdPrs_ToolPoint , shared_ptr<StdPrs_ToolPoint>>(m,"StdPrs_ToolPoint");

    // nested enums

    static_cast<py::class_<StdPrs_ToolPoint , shared_ptr<StdPrs_ToolPoint>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
        .def_static("Coord_s",
            [](const opencascade::handle<Geom_Point> & aPoint ){
                Standard_Real  X;
                Standard_Real  Y;
                Standard_Real  Z;

                StdPrs_ToolPoint::Coord(aPoint,X,Y,Z);
                
return std::make_tuple(X,Y,Z); },
            R"#(None)#"  , py::arg("aPoint")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_ToolRFace from ./opencascade/StdPrs_ToolRFace.hxx
    klass = m.attr("StdPrs_ToolRFace");


    // nested enums

    static_cast<py::class_<StdPrs_ToolRFace , shared_ptr<StdPrs_ToolRFace>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<BRepAdaptor_Surface> & >()  , py::arg("aSurface") )
    // custom constructors
    // methods
        .def("IsOriented",
             (Standard_Boolean (StdPrs_ToolRFace::*)() const) static_cast<Standard_Boolean (StdPrs_ToolRFace::*)() const>(&StdPrs_ToolRFace::IsOriented),
             R"#(Return TRUE indicating that iterator looks only for oriented edges.)#" 
          )
        .def("Init",
             (void (StdPrs_ToolRFace::*)() ) static_cast<void (StdPrs_ToolRFace::*)() >(&StdPrs_ToolRFace::Init),
             R"#(Move iterator to the first element.)#" 
          )
        .def("More",
             (Standard_Boolean (StdPrs_ToolRFace::*)() const) static_cast<Standard_Boolean (StdPrs_ToolRFace::*)() const>(&StdPrs_ToolRFace::More),
             R"#(Return TRUE if iterator points to the curve.)#" 
          )
        .def("Next",
             (void (StdPrs_ToolRFace::*)() ) static_cast<void (StdPrs_ToolRFace::*)() >(&StdPrs_ToolRFace::Next),
             R"#(Go to the next curve in the face.)#" 
          )
        .def("Orientation",
             (TopAbs_Orientation (StdPrs_ToolRFace::*)() const) static_cast<TopAbs_Orientation (StdPrs_ToolRFace::*)() const>(&StdPrs_ToolRFace::Orientation),
             R"#(Return current edge orientation.)#" 
          )
        .def("IsInvalidGeometry",
             (Standard_Boolean (StdPrs_ToolRFace::*)() const) static_cast<Standard_Boolean (StdPrs_ToolRFace::*)() const>(&StdPrs_ToolRFace::IsInvalidGeometry),
             R"#(Return TRUE if NULL curves have been skipped.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const Adaptor2d_Curve2d & (StdPrs_ToolRFace::*)() const) static_cast<const Adaptor2d_Curve2d & (StdPrs_ToolRFace::*)() const>(&StdPrs_ToolRFace::Value),
             R"#(Return current curve.)#"
             
         )
       .def("Edge",
             (const TopoDS_Edge & (StdPrs_ToolRFace::*)() const) static_cast<const TopoDS_Edge & (StdPrs_ToolRFace::*)() const>(&StdPrs_ToolRFace::Edge),
             R"#(Return current edge.)#"
             
         )
;

    // Class StdPrs_ToolTriangulatedShape from ./opencascade/StdPrs_ToolTriangulatedShape.hxx
    klass = m.attr("StdPrs_ToolTriangulatedShape");

    // default constructor
    register_default_constructor<StdPrs_ToolTriangulatedShape , shared_ptr<StdPrs_ToolTriangulatedShape>>(m,"StdPrs_ToolTriangulatedShape");

    // nested enums

    static_cast<py::class_<StdPrs_ToolTriangulatedShape , shared_ptr<StdPrs_ToolTriangulatedShape>  , BRepLib_ToolTriangulatedShape >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsTriangulated_s",
                    (Standard_Boolean (*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape &  ) >(&StdPrs_ToolTriangulatedShape::IsTriangulated),
                    R"#(Similar to BRepTools::Triangulation() but without extra checks.)#"  , py::arg("theShape")
          )
        .def_static("IsClosed_s",
                    (Standard_Boolean (*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape &  ) >(&StdPrs_ToolTriangulatedShape::IsClosed),
                    R"#(Checks back faces visibility for specified shape (to activate back-face culling).)#"  , py::arg("theShape")
          )
        .def_static("GetDeflection_s",
                    (Standard_Real (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Real (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_ToolTriangulatedShape::GetDeflection),
                    R"#(Computes the absolute deflection value depending on the type of deflection in theDrawer: Aspect_TOD_RELATIVE: the absolute deflection is computed using the relative deviation coefficient from theDrawer and the shape's bounding box; Aspect_TOD_ABSOLUTE: the maximal chordial deviation from theDrawer is returned. In case of the type of deflection in theDrawer computed relative deflection for shape is stored as absolute deflection. It is necessary to use it later on for sub-shapes. This function should always be used to compute the deflection value for building discrete representations of the shape (triangulation, wireframe) to avoid inconsistencies between different representations of the shape and undesirable visual artifacts.)#"  , py::arg("theShape"),  py::arg("theDrawer")
          )
        .def_static("IsTessellated_s",
                    (Standard_Boolean (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_ToolTriangulatedShape::IsTessellated),
                    R"#(Checks whether the shape is properly triangulated for a given display settings.)#"  , py::arg("theShape"),  py::arg("theDrawer")
          )
        .def_static("Tessellate_s",
                    (Standard_Boolean (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_ToolTriangulatedShape::Tessellate),
                    R"#(Validates triangulation within the shape and performs tessellation if necessary.)#"  , py::arg("theShape"),  py::arg("theDrawer")
          )
        .def_static("ClearOnOwnDeflectionChange_s",
                    (void (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean  ) >(&StdPrs_ToolTriangulatedShape::ClearOnOwnDeflectionChange),
                    R"#(If presentation has own deviation coefficient and IsAutoTriangulation() is true, function will compare actual coefficients with previous values and will clear triangulation on their change (regardless actual tessellation quality). Function is placed here for compatibility reasons - new code should avoid using IsAutoTriangulation().)#"  , py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theToResetCoeff")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_ToolVertex from ./opencascade/StdPrs_ToolVertex.hxx
    klass = m.attr("StdPrs_ToolVertex");

    // default constructor
    register_default_constructor<StdPrs_ToolVertex , shared_ptr<StdPrs_ToolVertex>>(m,"StdPrs_ToolVertex");

    // nested enums

    static_cast<py::class_<StdPrs_ToolVertex , shared_ptr<StdPrs_ToolVertex>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
        .def_static("Coord_s",
            [](const TopoDS_Vertex & aPoint ){
                Standard_Real  X;
                Standard_Real  Y;
                Standard_Real  Z;

                StdPrs_ToolVertex::Coord(aPoint,X,Y,Z);
                
return std::make_tuple(X,Y,Z); },
            R"#(None)#"  , py::arg("aPoint")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_WFDeflectionRestrictedFace from ./opencascade/StdPrs_WFDeflectionRestrictedFace.hxx
    klass = m.attr("StdPrs_WFDeflectionRestrictedFace");

    // default constructor
    register_default_constructor<StdPrs_WFDeflectionRestrictedFace , shared_ptr<StdPrs_WFDeflectionRestrictedFace>>(m,"StdPrs_WFDeflectionRestrictedFace");

    // nested enums

    static_cast<py::class_<StdPrs_WFDeflectionRestrictedFace , shared_ptr<StdPrs_WFDeflectionRestrictedFace>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionRestrictedFace::Add),
                    R"#(Defines a display featuring U and V isoparameters. Adds the surface aFace to the StdPrs_WFRestrictedFace algorithm. This face is found in a shape in the presentation object aPresentation, and its display attributes - in particular, the number of U and V isoparameters - are set in the attribute manager aDrawer. aFace is BRepAdaptor_Surface surface created from a face in a topological shape. which is passed as an argument through the BRepAdaptor_Surface surface created from it. This is what allows the topological face to be treated as a geometric surface.)#"  , py::arg("aPresentation"),  py::arg("aFace"),  py::arg("aDrawer")
          )
        .def_static("AddUIso_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionRestrictedFace::AddUIso),
                    R"#(Defines a display featuring U isoparameters respectively. Add the surface aFace to the StdPrs_WFRestrictedFace algorithm. This face is found in a shape in the presentation object aPresentation, and its display attributes - in particular, the number of U isoparameters - are set in the attribute manager aDrawer. aFace is BRepAdaptor_Surface surface created from a face in a topological shape. which is passed to the function as an argument through the BRepAdaptor_Surface surface created from it. This is what allows the topological face to be treated as a geometric surface.)#"  , py::arg("aPresentation"),  py::arg("aFace"),  py::arg("aDrawer")
          )
        .def_static("AddVIso_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionRestrictedFace::AddVIso),
                    R"#(Defines a display featuring V isoparameters respectively. Add the surface aFace to the StdPrs_WFRestrictedFace algorithm. This face is found in a shape in the presentation object aPresentation, and its display attributes - in particular, the number of V isoparameters - are set in the attribute manager aDrawer. aFace is BRepAdaptor_Surface surface created from a face in a topological shape. which is passed to the function as an argument through the BRepAdaptor_Surface surface created from it. This is what allows the topological face to be treated as a geometric surface.)#"  , py::arg("aPresentation"),  py::arg("aFace"),  py::arg("aDrawer")
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&StdPrs_WFDeflectionRestrictedFace::Add),
                    R"#(Defines a display of a delection-specified face. The display will feature U and V isoparameters. Adds the topology aShape to the StdPrs_WFRestrictedFace algorithm. This shape is found in the presentation object aPresentation, and its display attributes - except the number of U and V isoparameters - are set in the attribute manager aDrawer. The function sets the number of U and V isoparameters, NBUiso and NBViso, in the shape. To do this, the arguments DrawUIso and DrawVIso must be true. aFace is BRepAdaptor_Surface surface created from a face in a topological shape. which is passed as an argument through the BRepAdaptor_Surface surface created from it. This is what allows the topological face to be treated as a geometric surface. Curves give a sequence of face curves, it is used if the PrimitiveArray visualization approach is activated (it is activated by default).)#"  , py::arg("aPresentation"),  py::arg("aFace"),  py::arg("DrawUIso"),  py::arg("DrawVIso"),  py::arg("Deflection"),  py::arg("NBUiso"),  py::arg("NBViso"),  py::arg("aDrawer"),  py::arg("Curves")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionRestrictedFace::Match),
                    R"#(None)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aFace"),  py::arg("aDrawer")
          )
        .def_static("MatchUIso_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionRestrictedFace::MatchUIso),
                    R"#(None)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aFace"),  py::arg("aDrawer")
          )
        .def_static("MatchVIso_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionRestrictedFace::MatchVIso),
                    R"#(None)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aFace"),  py::arg("aDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer  ) >(&StdPrs_WFDeflectionRestrictedFace::Match),
                    R"#(None)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("aFace"),  py::arg("aDrawer"),  py::arg("DrawUIso"),  py::arg("DrawVIso"),  py::arg("aDeflection"),  py::arg("NBUiso"),  py::arg("NBViso")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_WFDeflectionSurface from ./opencascade/StdPrs_WFDeflectionSurface.hxx
    klass = m.attr("StdPrs_WFDeflectionSurface");

    // default constructor
    register_default_constructor<StdPrs_WFDeflectionSurface , shared_ptr<StdPrs_WFDeflectionSurface>>(m,"StdPrs_WFDeflectionSurface");

    // nested enums

    static_cast<py::class_<StdPrs_WFDeflectionSurface , shared_ptr<StdPrs_WFDeflectionSurface>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Adaptor3d_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Adaptor3d_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFDeflectionSurface::Add),
                    R"#(Adds the surface aSurface to the presentation object aPresentation, and defines its boundaries and isoparameters. The shape's display attributes are set in the attribute manager aDrawer. These include whether deflection is absolute or relative to the size of the shape. The surface aSurface is a surface object from Adaptor, and provides data from a Geom surface. This makes it possible to use the surface in a geometric algorithm. Note that this surface object is manipulated by handles.)#"  , py::arg("aPresentation"),  py::arg("aSurface"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_WFPoleSurface from ./opencascade/StdPrs_WFPoleSurface.hxx
    klass = m.attr("StdPrs_WFPoleSurface");

    // default constructor
    register_default_constructor<StdPrs_WFPoleSurface , shared_ptr<StdPrs_WFPoleSurface>>(m,"StdPrs_WFPoleSurface");

    // nested enums

    static_cast<py::class_<StdPrs_WFPoleSurface , shared_ptr<StdPrs_WFPoleSurface>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Adaptor3d_Surface & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFPoleSurface::Add),
                    R"#(Adds the surface aSurface to the presentation object aPresentation. The shape's display attributes are set in the attribute manager aDrawer. The surface aSurface is a surface object from Adaptor3d, and provides data from a Geom surface. This makes it possible to use the surface in a geometric algorithm.)#"  , py::arg("aPresentation"),  py::arg("aSurface"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_WFRestrictedFace from ./opencascade/StdPrs_WFRestrictedFace.hxx
    klass = m.attr("StdPrs_WFRestrictedFace");

    // default constructor
    register_default_constructor<StdPrs_WFRestrictedFace , shared_ptr<StdPrs_WFRestrictedFace>>(m,"StdPrs_WFRestrictedFace");

    // nested enums

    static_cast<py::class_<StdPrs_WFRestrictedFace , shared_ptr<StdPrs_WFRestrictedFace>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Integer ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Integer ,  const opencascade::handle<Prs3d_Drawer> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&StdPrs_WFRestrictedFace::Add),
                    R"#(None)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawUIso"),  py::arg("theDrawVIso"),  py::arg("theNbUIso"),  py::arg("theNbVIso"),  py::arg("theDrawer"),  py::arg("theCurves")
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::Add),
                    R"#(None)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::Match),
                    R"#(None)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ"),  py::arg("theDistance"),  py::arg("theFace"),  py::arg("theDrawUIso"),  py::arg("theDrawVIso"),  py::arg("theDeflection"),  py::arg("theNbUIso"),  py::arg("theNbVIso"),  py::arg("theDrawer")
          )
        .def_static("Match_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::Match),
                    R"#(None)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ"),  py::arg("theDistance"),  py::arg("theFace"),  py::arg("theDrawer")
          )
        .def_static("MatchUIso_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::MatchUIso),
                    R"#(None)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ"),  py::arg("theDistance"),  py::arg("theFace"),  py::arg("theDrawer")
          )
        .def_static("MatchVIso_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::MatchVIso),
                    R"#(None)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ"),  py::arg("theDistance"),  py::arg("theFace"),  py::arg("theDrawer")
          )
        .def_static("AddUIso_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::AddUIso),
                    R"#(None)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawer")
          )
        .def_static("AddVIso_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<BRepAdaptor_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFRestrictedFace::AddVIso),
                    R"#(None)#"  , py::arg("thePresentation"),  py::arg("theFace"),  py::arg("theDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_WFShape from ./opencascade/StdPrs_WFShape.hxx
    klass = m.attr("StdPrs_WFShape");

    // default constructor
    register_default_constructor<StdPrs_WFShape , shared_ptr<StdPrs_WFShape>>(m,"StdPrs_WFShape");

    // nested enums

    static_cast<py::class_<StdPrs_WFShape , shared_ptr<StdPrs_WFShape>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  Standard_Boolean  ) >(&StdPrs_WFShape::Add),
                    R"#(Computes wireframe presentation of a shape.)#"  , py::arg("thePresentation"),  py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theIsParallel")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def_static("AddEdgesOnTriangulation_s",
                    (opencascade::handle<Graphic3d_ArrayOfPrimitives> (*)( const TopoDS_Shape & ,  const Standard_Boolean  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfPrimitives> (*)( const TopoDS_Shape & ,  const Standard_Boolean  ) >(&StdPrs_WFShape::AddEdgesOnTriangulation),
                    R"#(Compute free and boundary edges on a triangulation of each face in the given shape.)#"  , py::arg("theShape"),  py::arg("theToExcludeGeometric")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("AddEdgesOnTriangulation_s",
                    (void (*)( NCollection_Sequence<gp_Pnt> & ,  const TopoDS_Shape & ,  const Standard_Boolean  ) ) static_cast<void (*)( NCollection_Sequence<gp_Pnt> & ,  const TopoDS_Shape & ,  const Standard_Boolean  ) >(&StdPrs_WFShape::AddEdgesOnTriangulation),
                    R"#(Compute free and boundary edges on a triangulation of each face in the given shape.)#"  , py::arg("theSegments"),  py::arg("theShape"),  py::arg("theToExcludeGeometric")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("AddAllEdges_s",
                    (opencascade::handle<Graphic3d_ArrayOfPrimitives> (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfPrimitives> (*)( const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFShape::AddAllEdges),
                    R"#(Compute all edges (wire, free, unfree) and put them into single primitive array.)#"  , py::arg("theShape"),  py::arg("theDrawer")
          )
        .def_static("AddVertexes_s",
                    (opencascade::handle<Graphic3d_ArrayOfPoints> (*)( const TopoDS_Shape & ,  Prs3d_VertexDrawMode  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfPoints> (*)( const TopoDS_Shape & ,  Prs3d_VertexDrawMode  ) >(&StdPrs_WFShape::AddVertexes),
                    R"#(Compute vertex presentation for a shape.)#"  , py::arg("theShape"),  py::arg("theVertexMode")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_WFSurface from ./opencascade/StdPrs_WFSurface.hxx
    klass = m.attr("StdPrs_WFSurface");

    // default constructor
    register_default_constructor<StdPrs_WFSurface , shared_ptr<StdPrs_WFSurface>>(m,"StdPrs_WFSurface");

    // nested enums

    static_cast<py::class_<StdPrs_WFSurface , shared_ptr<StdPrs_WFSurface>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Adaptor3d_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Adaptor3d_Surface> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdPrs_WFSurface::Add),
                    R"#(Draws a surface by drawing the isoparametric curves with respect to a fixed number of points given by the Drawer. The number of isoparametric curves to be drawn and their color are controlled by the furnished Drawer.)#"  , py::arg("aPresentation"),  py::arg("aSurface"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdPrs_HLRPolyShape from ./opencascade/StdPrs_HLRPolyShape.hxx
    klass = m.attr("StdPrs_HLRPolyShape");

    // default constructor
    register_default_constructor<StdPrs_HLRPolyShape ,opencascade::handle<StdPrs_HLRPolyShape>>(m,"StdPrs_HLRPolyShape");

    // nested enums

    static_cast<py::class_<StdPrs_HLRPolyShape ,opencascade::handle<StdPrs_HLRPolyShape>  , StdPrs_HLRShapeI >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ComputeHLR",
             (void (StdPrs_HLRPolyShape::*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const opencascade::handle<Graphic3d_Camera> &  ) const) static_cast<void (StdPrs_HLRPolyShape::*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const opencascade::handle<Graphic3d_Camera> &  ) const>(&StdPrs_HLRPolyShape::ComputeHLR),
             R"#(Compute presentation for specified shape.)#"  , py::arg("thePrs"),  py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theProjector")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdPrs_HLRPolyShape::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdPrs_HLRPolyShape::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdPrs_HLRPolyShape::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdPrs_HLRPolyShape::*)() const>(&StdPrs_HLRPolyShape::DynamicType),
             R"#(None)#"
             
         )
;

    // Class StdPrs_HLRShape from ./opencascade/StdPrs_HLRShape.hxx
    klass = m.attr("StdPrs_HLRShape");

    // default constructor
    register_default_constructor<StdPrs_HLRShape ,opencascade::handle<StdPrs_HLRShape>>(m,"StdPrs_HLRShape");

    // nested enums

    static_cast<py::class_<StdPrs_HLRShape ,opencascade::handle<StdPrs_HLRShape>  , StdPrs_HLRShapeI >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ComputeHLR",
             (void (StdPrs_HLRShape::*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const opencascade::handle<Graphic3d_Camera> &  ) const) static_cast<void (StdPrs_HLRShape::*)( const opencascade::handle<Prs3d_Presentation> & ,  const TopoDS_Shape & ,  const opencascade::handle<Prs3d_Drawer> & ,  const opencascade::handle<Graphic3d_Camera> &  ) const>(&StdPrs_HLRShape::ComputeHLR),
             R"#(Compute presentation for specified shape.)#"  , py::arg("thePrs"),  py::arg("theShape"),  py::arg("theDrawer"),  py::arg("theProjector")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdPrs_HLRShape::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdPrs_HLRShape::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdPrs_HLRShape::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdPrs_HLRShape::*)() const>(&StdPrs_HLRShape::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/StdPrs_BRepFont.hxx
// ./opencascade/StdPrs_BRepTextBuilder.hxx
// ./opencascade/StdPrs_BndBox.hxx
// ./opencascade/StdPrs_Curve.hxx
// ./opencascade/StdPrs_DeflectionCurve.hxx
// ./opencascade/StdPrs_HLRPolyShape.hxx
// ./opencascade/StdPrs_HLRShape.hxx
// ./opencascade/StdPrs_HLRShapeI.hxx
// ./opencascade/StdPrs_HLRToolShape.hxx
// ./opencascade/StdPrs_Isolines.hxx
// ./opencascade/StdPrs_Plane.hxx
// ./opencascade/StdPrs_Point.hxx
// ./opencascade/StdPrs_PoleCurve.hxx
// ./opencascade/StdPrs_ShadedShape.hxx
// ./opencascade/StdPrs_ShadedSurface.hxx
// ./opencascade/StdPrs_ShapeTool.hxx
// ./opencascade/StdPrs_ToolPoint.hxx
// ./opencascade/StdPrs_ToolRFace.hxx
// ./opencascade/StdPrs_ToolTriangulatedShape.hxx
// ./opencascade/StdPrs_ToolVertex.hxx
// ./opencascade/StdPrs_Vertex.hxx
// ./opencascade/StdPrs_Volume.hxx
// ./opencascade/StdPrs_WFDeflectionRestrictedFace.hxx
// ./opencascade/StdPrs_WFDeflectionSurface.hxx
// ./opencascade/StdPrs_WFPoleSurface.hxx
// ./opencascade/StdPrs_WFRestrictedFace.hxx
// ./opencascade/StdPrs_WFShape.hxx
// ./opencascade/StdPrs_WFSurface.hxx

// Additional functions

// operators

// register typdefs
    register_template_Prs3d_Point<opencascade::handle<Geom_Point>, StdPrs_ToolPoint>(m,"StdPrs_Point");
    register_template_Prs3d_Point<TopoDS_Vertex, StdPrs_ToolVertex>(m,"StdPrs_Vertex");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
