#!/usr/bin/env python
# Copyright (c) 2011 Google Inc. All rights reserved.
# Copyright (c) 2012 Intel Corporation. All rights reserved.
# Copyright (c) 2013, 2014 Apple Inc. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#     * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Generator templates, which can be filled with string.Template.
# Following are classes that fill the templates from the typechecked model.

class Templates:
    CopyrightBlock = (
    """/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from ${inputFilename}
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py""")

    HeaderSkeleton = (
    """${licenseBlock}

#ifndef ${headerGuard}
#define ${headerGuard}

#if ${guardCondition}
${includes}

${typeForwardDeclarations}

namespace ${inputsNamespace} {
${inputForwardDeclarations}
} // namespace ${inputsNamespace}

namespace ${traitsNamespace} {
${inputTraitDeclarations}
${enumTraitDeclarations}
} // namespace ${traitsNamespace}

namespace ${inputsNamespace} {
${inputClassDeclarations}
} // namespace ${inputsNamespace}

${inputTypeTraitDeclarations}

${forEachMacro}

#endif // ${guardCondition}

#endif // ${filename}_h
""")

    InputTraitsDeclaration = (
    """template<> ${structOrClass} InputTraits<${qualifiedInputName}> {
    static InputQueue queue() { return InputQueue::${queueType}; }
    static const String& type();

    static void encode(JSC::EncodedValue&, const ${qualifiedInputName}&);
    static bool decode(JSC::EncodedValue&, std::unique_ptr<${qualifiedInputName}>&);
};""")

    InputTypeTraitsDeclaration = (
    """SPECIALIZE_TYPE_TRAITS_BEGIN(${qualifiedInputName})
    static bool isType(const NondeterministicInputBase& input) { return input.type() == InputTraits<${qualifiedInputName}>::type(); }
SPECIALIZE_TYPE_TRAITS_END()""")

    EnumTraitDeclaration = (
    """template<> ${structOrClass} EncodingTraits<${encodingTypeArgument}> {
    typedef ${enumType} DecodedType;

    static EncodedValue encodeValue(const ${enumType}& value);
    static bool decodeValue(EncodedValue&, ${enumType}& value);
};""")

    EnumClassTraitDeclaration = (
    """template<> ${structOrClass} EncodingTraits<${encodingTypeArgument}> {
    typedef ${enumType} DecodedType;

    static EncodedValue encodeValue(const ${enumType}& value);
    static bool decodeValue(EncodedValue&, ${enumType}& value);
};""")

    InputClassDeclaration = (
    """class ${inputName} : public ${baseClass} {
public:
${inputConstructor}
${inputDestructor}
${extraDeclarations}
${memberGetters}
${memberDeclarations}
};""")

    ImplementationSkeleton = (
    """${licenseBlock}

#include "config.h"
#include "${filename}.h"

#if ${guardCondition}
${includes}

namespace ${inputsNamespace} {
${inputClassImplementations}
} // namespace ${inputsNamespace}

namespace ${traitsNamespace} {
${inputTraitImplementations}
${enumTraitImplementations}
} // namespace ${traitsNamespace}

#endif // ${guardCondition}
""")

    InputTraitsImplementation = (
    """const String& InputTraits<${qualifiedInputName}>::type()
{
    static NeverDestroyed<const String> type(ASCIILiteral(${inputNameStringLiteral}));
    return type;
}

void InputTraits<${qualifiedInputName}>::encode(EncodedValue& encodedValue, const ${qualifiedInputName}& input)
{
${encodeSteps}
}

bool InputTraits<${qualifiedInputName}>::decode(EncodedValue& encodedValue, std::unique_ptr<${qualifiedInputName}>& input)
{
${decodeSteps}
    input = std::make_unique<${qualifiedInputName}>(${constructorArguments});
    return true;
}""")

    EnumClassTraitImplementation = (
    """EncodedValue EncodingTraits<${encodingTypeArgument}>::encodeValue(const ${enumType}& enumValue)
{
    switch (enumValue) {
${encodeCases}
    default: ASSERT_NOT_REACHED(); return EncodedValue::createString("Error!");
    }
}

bool EncodingTraits<${encodingTypeArgument}>::decodeValue(EncodedValue& encodedValue, ${enumType}& enumValue)
{
    String enumString = encodedValue.convertTo<String>();
${decodeCases}
    return false;
}""")

    EnumClassEncodeCase = (
    """    case ${qualifiedEnumValue}: return EncodedValue::createString("${enumStringValue}");""")

    EnumClassDecodeCase = (
    """    if (enumString == "${enumStringValue}") {
        enumValue = ${qualifiedEnumValue};
        return true;
    }""")

    EnumTraitImplementation = (
    """EncodedValue EncodingTraits<${encodingTypeArgument}>::encodeValue(const ${enumType}& enumValue)
{
    EncodedValue encodedValue = EncodedValue::createArray();
${encodeCases}
    return encodedValue;
}

bool EncodingTraits<${encodingTypeArgument}>::decodeValue(EncodedValue& encodedValue, ${enumType}& enumValue)
{
    Vector<String> enumStrings;
    if (!EncodingTraits<Vector<String>>::decodeValue(encodedValue, enumStrings))
        return false;

    for (const String& enumString : enumStrings) {
${decodeCases}
    }

    return true;
}""")

    EnumEncodeCase = (
    """    if (enumValue & ${qualifiedEnumValue}) {
        encodedValue.append<String>(ASCIILiteral("${enumStringValue}"));
        if (enumValue == ${qualifiedEnumValue})
            return encodedValue;
    }""")

    EnumDecodeCase = (
    """        ${branchKeyword} (enumString == "${enumStringValue}")
            enumValue = static_cast<${qualifiedEnumName}>(enumValue | ${qualifiedEnumValue});""")

    InputClassImplementation = (
    """${inputName}::${inputName}(${constructorFormalsList})
${initializerList}
{
}

${inputName}::~${inputName}()
{
}""")
