% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_factors.R
\name{plot_factor}
\alias{plot_factor}
\title{Beeswarm plot of factor values}
\usage{
plot_factor(
  object,
  factors = 1,
  groups = "all",
  group_by = "group",
  color_by = "group",
  shape_by = NULL,
  add_dots = TRUE,
  dot_size = 2,
  dot_alpha = 1,
  add_violin = FALSE,
  violin_alpha = 0.5,
  color_violin = TRUE,
  add_boxplot = FALSE,
  boxplot_alpha = 0.5,
  color_boxplot = TRUE,
  show_missing = TRUE,
  scale = FALSE,
  dodge = FALSE,
  color_name = "",
  shape_name = "",
  stroke = NULL,
  legend = TRUE,
  rasterize = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{factors}{character vector with the factor names, or numeric vector with the indices of the factors to use, or "all" to plot all factors.}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{group_by}{specifies grouping of samples:
\itemize{
\item (default) the string "group": in this case, the plot will color samples with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the name of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
}}

\item{color_by}{specifies color of samples. This can be either: 
\itemize{
\item (default) the string "group": in this case, the plot will color the dots with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the name of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
}}

\item{shape_by}{specifies shape of samples. This can be either: 
\itemize{
\item (default) the string "group": in this case, the plot will shape the dots with respect to their predefined groups.
\item a character giving the name of a feature that is present in the input data 
\item a character giving the name of a column in the sample metadata slot
\item a vector of the same length as the number of samples specifying the value for each sample. 
}}

\item{add_dots}{logical indicating whether to add dots.}

\item{dot_size}{numeric indicating dot size.}

\item{dot_alpha}{numeric indicating dot transparency.}

\item{add_violin}{logical indicating whether to add violin plots}

\item{violin_alpha}{numeric indicating violin plot transparency.}

\item{color_violin}{logical indicating whether to color violin plots.}

\item{add_boxplot}{logical indicating whether to add box plots}

\item{boxplot_alpha}{numeric indicating boxplot transparency.}

\item{color_boxplot}{logical indicating whether to color box plots.}

\item{show_missing}{logical indicating whether to remove samples for which \code{shape_by} or \code{color_by} is missing.}

\item{scale}{logical indicating whether to scale factor values.}

\item{dodge}{logical indicating whether to dodge the dots (default is FALSE).}

\item{color_name}{name for color legend (usually only used if color_by is not a character itself).}

\item{shape_name}{name for shape legend (usually only used if shape_by is not a character itself).}

\item{stroke}{numeric indicating the stroke size (the black border around the dots).}

\item{legend}{logical indicating whether to add a legend to the plot (default is TRUE).}

\item{rasterize}{logical indicating whether to rasterize the plot (default is FALSE).}
}
\value{
Returns a \code{ggplot2}
}
\description{
Beeswarm plot of the latent factor values.
}
\details{
One of the main steps for the annotation of factors is to visualise and color them using known covariates or phenotypic data. \cr
This function generates a Beeswarm plot of the sample values in a given latent factor. \cr
Similar functions are \code{\link{plot_factors}} for doing scatter plots.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Plot Factors 1 and 2 and colour by "group"
plot_factor(model, factors = c(1,2), color_by="group")

# Plot Factor 3 and colour by the value of a specific feature
plot_factor(model, factors = 3, color_by="feature_981_view_1")

# Add violin plots
plot_factor(model, factors = c(1,2), color_by="group", add_violin = TRUE)

# Scale factor values from -1 to 1
plot_factor(model, factors = c(1,2), scale = TRUE)

}
