package provide DS9 1.0

######
# Begin autogenerated taccle (version 1.3) routines.
# Although taccle itself is protected by the GNU Public License (GPL)
# all user-supplied functions are protected by their respective
# author's license.  See http://mini.net/tcl/taccle for other details.
######

namespace eval analysis {
    variable yylval {}
    variable table
    variable rules
    variable token {}
    variable yycnt 0
    variable yyerr 0
    variable save_state 0

    namespace export yylex
}

proc analysis::YYABORT {} {
    return -code return 1
}

proc analysis::YYACCEPT {} {
    return -code return 0
}

proc analysis::YYERROR {} {
    variable yyerr
    set yyerr 1
}

proc analysis::yyclearin {} {
    variable token
    variable yycnt
    set token {}
    incr yycnt -1
}

proc analysis::yyerror {s} {
    puts stderr $s
}

proc analysis::setupvalues {stack pointer numsyms} {
    upvar 1 1 y
    set y {}
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        set y [lindex $stack $pointer]
        incr pointer
    }
}

proc analysis::unsetupvalues {numsyms} {
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        unset y
    }
}

array set analysis::table {
  17:258 reduce
  27:0 reduce
  10:258,target 2
  6:258 shift
  26:258 reduce
  0:275,target 9
  6:263 shift
  2:0 reduce
  1:258,target 4
  24:0 reduce
  35:257 shift
  41:0,target 29
  33:258,target 35
  25:0,target 15
  10:0,target 1
  22:258,target 28
  35:271 shift
  35:272 shift
  6:284 goto
  11:258,target 30
  14:258 reduce
  35:273 shift
  35:274 shift
  8:283,target 28
  3:258 reduce
  3:260 shift
  2:258,target 10
  23:258 reduce
  35:285 goto
  7:257,target 24
  5:269,target 18
  5:270,target 19
  38:0 reduce
  32:258 reduce
  3:0,target 16
  23:258,target 9
  41:258 reduce
  3:280 goto
  12:258,target 7
  14:0 reduce
  37:0,target 30
  30:0,target 19
  5:267,target 16
  22:0,target 28
  3:280,target 12
  14:0,target 6
  11:258 shift
  3:258,target 16
  0:257 shift
  0:258 shift
  0:260 shift
  0:259 shift
  0:261 shift
  9:0 accept
  19:258 reduce
  20:258 shift
  0:262 shift
  11:0 reduce
  0:264 shift
  0:265 shift
  32:0 reduce
  8:258 shift
  24:258,target 14
  28:258 reduce
  11:281 goto
  0:275 goto
  13:258,target 13
  0:264,target 7
  0:277 goto
  37:258 reduce
  28:0 reduce
  4:258,target 13
  34:0,target 3
  3:0 reduce
  26:0,target 5
  36:258,target 34
  5:282,target 20
  0:262,target 6
  8:283 goto
  11:0,target 18
  16:258 reduce
  25:0 reduce
  25:258,target 15
  5:258 reduce
  25:258 reduce
  6:284,target 23
  14:258,target 6
  35:273,target 39
  5:266 shift
  0:259,target 3
  0:260,target 4
  5:267 shift
  6:263,target 22
  22:0 reduce
  5:268 shift
  5:269 shift
  5:270 shift
  5:258,target 20
  37:258,target 30
  35:271,target 37
  4:0,target 12
  5:282 goto
  0:257,target 1
  26:258,target 5
  13:258 reduce
  39:0 reduce
  40:0 reduce
  38:0,target 31
  31:0,target 17
  15:258,target 21
  23:0,target 9
  2:258 reduce
  22:258 reduce
  6:258,target 21
  36:0 reduce
  31:258 reduce
  38:258,target 31
  11:281,target 31
  10:276,target 29
  12:0 reduce
  27:258,target 27
  39:258 reduce
  40:258 reduce
  10:258 reduce
  16:258,target 22
  35:285,target 41
  8:0,target 26
  1:0,target 4
  7:279,target 26
  18:258 reduce
  7:258,target 25
  30:0 reduce
  27:0,target 27
  7:257 shift
  40:258,target 33
  7:258 shift
  12:0,target 7
  39:258,target 32
  10:276 goto
  27:258 reduce
  4:0 reduce
  28:258,target 8
  5:268,target 17
  26:0 reduce
  36:258 reduce
  17:258,target 23
  3:260,target 11
  1:0 reduce
  7:279 goto
  8:258,target 27
  15:258 reduce
  23:0 reduce
  5:266,target 15
  41:258,target 29
  4:258 shift
  24:258 reduce
  29:258,target 34
  30:258,target 19
  39:0,target 32
  40:0,target 33
  0:265,target 8
  32:0,target 11
  24:0,target 14
  35:257,target 36
  18:258,target 24
  41:0 reduce
  33:258 shift
  4:278 goto
  4:278,target 14
  12:258 reduce
  37:0 reduce
  31:258,target 17
  1:258 reduce
  35:274,target 40
  21:258 shift
  0:261,target 5
  9:0,target 0
  13:0 reduce
  19:258,target 25
  20:258,target 32
  2:0,target 10
  34:0 reduce
  29:258 shift
  30:258 reduce
  36:0,target 34
  28:0,target 8
  35:272,target 38
  13:0,target 13
  8:0 reduce
  10:0 reduce
  0:258,target 2
  38:258 reduce
  31:0 reduce
  32:258,target 11
  0:277,target 10
  21:258,target 33
}

array set analysis::rules {
  9,l 277
  11,l 277
  32,l 285
  6,l 277
  28,l 284
  3,l 275
  25,l 282
  0,l 286
  22,l 282
  18,l 281
  15,l 279
  12,l 278
  33,l 285
  7,l 277
  29,l 284
  30,l 285
  4,l 277
  26,l 283
  1,l 275
  23,l 282
  19,l 281
  20,l 282
  16,l 280
  13,l 278
  34,l 285
  8,l 277
  10,l 277
  31,l 285
  5,l 277
  27,l 283
  2,l 276
  24,l 282
  21,l 282
  17,l 280
  14,l 279
}

array set analysis::rules {
  12,dc 0
  26,dc 0
  3,dc 3
  18,dc 0
  33,dc 1
  9,dc 2
  11,dc 3
  25,dc 1
  2,dc 0
  17,dc 2
  32,dc 1
  8,dc 2
  10,dc 1
  24,dc 1
  1,dc 1
  16,dc 0
  31,dc 1
  7,dc 2
  23,dc 1
  0,dc 1
  15,dc 1
  29,dc 4
  30,dc 1
  6,dc 2
  22,dc 1
  14,dc 1
  28,dc 1
  5,dc 2
  21,dc 1
  13,dc 1
  27,dc 1
  4,dc 1
  19,dc 1
  20,dc 0
  34,dc 1
}

array set analysis::rules {
  7,line 42
  4,line 39
  34,line 85
  1,line 35
  31,line 82
  27,line 74
  24,line 69
  21,line 66
  17,line 58
  14,line 53
  11,line 46
  9,line 44
  6,line 41
  3,line 36
  33,line 84
  29,line 78
  30,line 81
  26,line 73
  23,line 68
  19,line 62
  20,line 65
  16,line 57
  13,line 50
  10,line 45
  8,line 43
  5,line 40
  2,line 35
  32,line 83
  28,line 77
  2,e 1
  25,line 70
  22,line 67
  18,line 61
  15,line 54
  12,line 49
}

array set analysis::lr1_table {
  35 {{29 {0 258} 3} {30 {0 258} 0} {31 {0 258} 0} {32 {0 258} 0} {33 {0 258} 0} {34 {0 258} 0}}
  36 {{34 {0 258} 1}}
  14,trans {}
  37 {{30 {0 258} 1}}
  33,trans {{258 35}}
  38 {{31 {0 258} 1}}
  40 {{33 {0 258} 1}}
  39 {{32 {0 258} 1}}
  41 {{29 {0 258} 4}}
  18,trans {}
  1,trans {}
  37,trans {}
  23,trans {}
  5,trans {{266 15} {267 16} {268 17} {269 18} {270 19} {282 20}}
  27,trans {}
  9,trans {}
  13,trans {}
  32,trans {}
  17,trans {}
  0,trans {{257 1} {258 2} {259 3} {260 4} {261 5} {262 6} {264 7} {265 8} {275 9} {277 10}}
  36,trans {}
  22,trans {}
  4,trans {{258 13} {278 14}}
  41,trans {}
  26,trans {}
  8,trans {{258 27} {283 28}}
  12,trans {}
  31,trans {}
  16,trans {}
  35,trans {{257 36} {271 37} {272 38} {273 39} {274 40} {285 41}}
  21,trans {{258 33}}
  3,trans {{260 11} {280 12}}
  40,trans {}
  39,trans {}
  10 {{1 0 1} {3 0 1} {2 258 0}}
  11 {{17 {0 258} 1} {18 {0 258} 0} {19 {0 258} 0}}
  25,trans {}
  12 {{7 {0 258} 2}}
  7,trans {{257 24} {258 25} {279 26}}
  13 {{13 {0 258} 1}}
  14 {{6 {0 258} 2}}
  15 {{21 258 1}}
  11,trans {{258 30} {281 31}}
  30,trans {}
  29,trans {{258 34}}
  16 {{22 258 1}}
  0 {{0 0 0} {1 0 0} {3 0 0} {4 {0 258} 0} {5 {0 258} 0} {6 {0 258} 0} {7 {0 258} 0} {8 {0 258} 0} {9 {0 258} 0} {10 {0 258} 0} {11 {0 258} 0}}
  17 {{23 258 1}}
  1 {{4 {0 258} 1}}
  18 {{24 258 1}}
  2 {{10 {0 258} 1}}
  19 {{25 258 1}}
  20 {{11 {0 258} 2}}
  15,trans {}
  34,trans {}
  3 {{7 {0 258} 1} {16 {0 258} 0} {17 {0 258} 0}}
  21 {{29 {0 258} 1}}
  4 {{6 {0 258} 1} {12 {0 258} 0} {13 {0 258} 0}}
  22 {{28 {0 258} 1}}
  5 {{11 {0 258} 1} {20 258 0} {21 258 0} {22 258 0} {23 258 0} {24 258 0} {25 258 0}}
  23 {{9 {0 258} 2}}
  20,trans {{258 32}}
  19,trans {}
  6 {{9 {0 258} 1} {28 {0 258} 0} {29 {0 258} 0}}
  2,trans {}
  24 {{14 {0 258} 1}}
  38,trans {}
  7 {{5 {0 258} 1} {14 {0 258} 0} {15 {0 258} 0}}
  25 {{15 {0 258} 1}}
  8 {{8 {0 258} 1} {26 {0 258} 0} {27 {0 258} 0}}
  26 {{5 {0 258} 2}}
  9 {{0 0 1}}
  27 {{27 {0 258} 1}}
  24,trans {}
  6,trans {{258 21} {263 22} {284 23}}
  28 {{8 {0 258} 2}}
  29 {{3 0 2}}
  30 {{19 {0 258} 1}}
  31 {{17 {0 258} 2}}
  32 {{11 {0 258} 3}}
  10,trans {{276 29}}
  28,trans {}
  33 {{29 {0 258} 2}}
  34 {{3 0 3}}
}

array set analysis::token_id_table {
  286,t 1
  286 start'
  280,title {}
  279,title {}
  264,line 18
  270,t 0
  269,t 0
  276,line 35
  265,title TEXT
  284,title {}
  274,t 0
  261,line 15
  257,t 0
  270,title YESNOCANCEL
  269,title YESNO
  273,line 29
  278,t 1
  257,line 7
  262,t 0
  285,line 80
  274,title XYEXEY
  283,t 1
  270,line 25
  269,line 24
  259,title CLEAR
  260,title LOAD
  266,t 0
  278,title {}
  282,line 64
  error error
  271,t 0
  264,title TASK
  266,line 21
  283,title {}
  278,line 48
  275,t 1
  error,line 33
  268,title RETRYCANCEL
  258,t 0
  263,line 17
  error,title {}
  280,t 1
  279,t 1
  275,line 34
  273,title XYEY
  263,t 0
  259,line 13
  260,line 14
  258,title string
  284,t 1
  277,title {}
  272,line 28
  267,t 0
  263,title STDIN
  284,line 76
  282,title {}
  272,t 0
  268,line 23
  267,title OKCANCEL
  286,title {}
  257 INT_
  281,line 60
  276,t 1
  258 STRING_
  259,t 0
  259 CLEAR_
  260 LOAD_
  260,t 0
  272,title XYEX
  261 MESSAGE_
  265,line 19
  262 PLOT_
  281,t 1
  263 STDIN_
  277,line 38
  257,title integer
  264 TASK_
  264,t 0
  276,title {}
  265 TEXT_
  262,line 16
  266 OK_
  285,t 1
  267 OKCANCEL_
  0,t 0
  0 {$}
  262,title PLOT
  268 RETRYCANCEL_
  268,t 0
  281,title {}
  274,line 30
  270 YESNOCANCEL_
  269 YESNO_
  error,t 0
  271 XY_
  272 XYEX_
  258,line 9
  286,line 86
  273,t 0
  273 XYEY_
  266,title OK
  285,title {}
  274 XYEXEY_
  275 command
  271,line 27
  276 @PSEUDO1
  277,t 1
  277 analysis
  271,title XY
  283,line 72
  278 load
  261,t 0
  280 clear
  279 task
  281 clearLoad
  267,line 22
  282,t 1
  282 message
  275,title {}
  283 text
  265,t 0
  284 plot
  280,line 56
  279,line 52
  285 dim
  261,title MESSAGE
}

proc analysis::yyparse {} {
    variable yylval
    variable table
    variable rules
    variable token
    variable yycnt
    variable lr1_table
    variable token_id_table
    variable yyerr
    variable save_state

    set yycnt 0
    set state_stack {0}
    set value_stack {{}}
    set token ""
    set accepted 0
    set yyerr 0
    set save_state 0

    while {$accepted == 0} {
        set state [lindex $state_stack end]
        if {$token == ""} {
            set yylval ""
            set token [yylex]
            set buflval $yylval
	    if {$token>0} {
	        incr yycnt
            }
        }
        if {![info exists table($state:$token)] || $yyerr} {
	    if {!$yyerr} {
	        set save_state $state
	    }
            # pop off states until error token accepted
            while {[llength $state_stack] > 0 && \
                       ![info exists table($state:error)]} {
                set state_stack [lrange $state_stack 0 end-1]
                set value_stack [lrange $value_stack 0 \
                                       [expr {[llength $state_stack] - 1}]]
                set state [lindex $state_stack end]
            }
            if {[llength $state_stack] == 0} {
 
	        set rr { }
                if {[info exists lr1_table($save_state,trans)] && [llength $lr1_table($save_state,trans)] >= 1} {
                    foreach trans $lr1_table($save_state,trans) {
                        foreach {tok_id nextstate} $trans {
			    set ss $token_id_table($tok_id,title)
			    if {$ss != {}} {
			        append rr "$ss, "
                            }
                        }
                    }
                }
		set rr [string trimleft $rr { }]
		set rr [string trimright $rr {, }]
                yyerror "parse error, expecting: $rr"


                return 1
            }
            lappend state_stack [set state $table($state:error,target)]
            lappend value_stack {}
            # consume tokens until it finds an acceptable one
            while {![info exists table($state:$token)]} {
                if {$token == 0} {
                    yyerror "end of file while recovering from error"
                    return 1
                }
                set yylval {}
                set token [yylex]
                set buflval $yylval
            }
            continue
        }
        switch -- $table($state:$token) {
            shift {
                lappend state_stack $table($state:$token,target)
                lappend value_stack $buflval
                set token ""
            }
            reduce {
                set rule $table($state:$token,target)
                set ll $rules($rule,l)
                if {[info exists rules($rule,e)]} {
                    set dc $rules($rule,e)
                } else {
                    set dc $rules($rule,dc)
                }
                set stackpointer [expr {[llength $state_stack]-$dc}]
                setupvalues $value_stack $stackpointer $dc
                set _ $1
                set yylval [lindex $value_stack end]
                switch -- $rule {
                    2 { global ds9; if {!$ds9(init)} {YYERROR} else {yyclearin; YYACCEPT} }
                    4 { AnalysisTask $1 menu }
                    10 { ProcessAnalysisFile $1 }
                    11 { AnalysisMessage $2 $3 }
                    12 { AnalysisCmdLoad }
                    13 { ProcessAnalysisFile $1 }
                    14 { AnalysisTask $1 menu }
                    15 { AnalysisCmdTask $1 }
                    16 { ClearAnalysis }
                    18 { ClearAnalysis; AnalysisCmdLoad }
                    19 { ClearAnalysis; ProcessAnalysisFile $1 }
                    20 { set _ ok }
                    21 { set _ ok }
                    22 { set _ okcancel }
                    23 { set _ retrycancel }
                    24 { set _ yesno }
                    25 { set _ yesnocancel }
                    26 { AnalysisCmdText }
                    27 { AnalysisText apXPA Analysis $1 append }
                    28 { AnalysisCmdPlotStdin }
                    29 { AnalysisCmdPlotLine $1 $2 $3 $4 }
                    30 { set _ xy }
                    31 { set _ xyex }
                    32 { set _ xyey }
                    33 { set _ xyexey }
                    34 { set _ $1 }
                }
                unsetupvalues $dc
                # pop off tokens from the stack if normal rule
                if {![info exists rules($rule,e)]} {
                    incr stackpointer -1
                    set state_stack [lrange $state_stack 0 $stackpointer]
                    set value_stack [lrange $value_stack 0 $stackpointer]
                }
                # now do the goto transition
                lappend state_stack $table([lindex $state_stack end]:$ll,target)
                lappend value_stack $_
            }
            accept {
                set accepted 1
            }
            goto -
            default {
                puts stderr "Internal parser error: illegal command $table($state:$token)"
                return 2
            }
        }
    }
    return 0
}

######
# end autogenerated taccle functions
######

proc analysis::yyerror {msg} {
     variable yycnt
     variable yy_current_buffer
     variable index_

     ParserError $msg $yycnt $yy_current_buffer $index_
}
