// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Paul Bignier
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- CLI SHELL MODE -->

assert_checkalmostequal(sqrtm([8 8 ; 8 8]), [2 2 ; 2 2]);

x = [0 1; 2 4];
w = sqrtm(x);
assert_checkalmostequal(norm(w*w-x), 0, [], 5*%eps);
x(1, 2) = %i;
w = sqrtm(x);
assert_checkalmostequal(norm(w*w-x, 1), 0, [], 15*%eps);


// Error checks
errarg = sci2exp("double");
refMsg = msprintf(_("%s: Wrong type for input argument #%d: Must be in %s.\n"),"sqrtm", 1, errarg);
assert_checkerror("sqrtm(list())", refMsg);
assert_checkerror("sqrtm(%s)", refMsg);
assert_checkerror("sqrtm(%t)", refMsg);

refMsg = msprintf(_("%s: Wrong type for input argument #%d: Must be a square matrix.\n"),"sqrtm", 1);
assert_checkerror("sqrtm([1 2 3; 4 5 6])", refMsg);
assert_checkerror("sqrtm([1 2; 3 4; 5 6])", refMsg);
