/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBColumn;
import adql.db.DBType;
import adql.db.SearchColumnList;
import adql.db.exception.UnresolvedJoinException;
import adql.db.region.Region;
import adql.parser.feature.FeatureSet;
import adql.parser.grammar.ParseException;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.ClauseSelect;
import adql.query.IdentifierField;
import adql.query.SelectItem;
import adql.query.SetOperation;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.from.ADQLJoin;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.translator.JDBCTranslator;
import adql.translator.TranslationException;
import java.util.Iterator;

public class SQLServerTranslator
extends JDBCTranslator {
    protected byte caseSensitivity = 0;
    protected final FeatureSet supportedFeatures = new FeatureSet();

    public SQLServerTranslator() {
        this.caseSensitivity = (byte)15;
        this.initSupportedFeatures();
    }

    public SQLServerTranslator(boolean allCaseSensitive) {
        this.caseSensitivity = (byte)(allCaseSensitive ? 15 : 0);
        this.initSupportedFeatures();
    }

    public SQLServerTranslator(boolean catalog, boolean schema, boolean table, boolean column) {
        this.caseSensitivity = IdentifierField.CATALOG.setCaseSensitive(this.caseSensitivity, catalog);
        this.caseSensitivity = IdentifierField.SCHEMA.setCaseSensitive(this.caseSensitivity, schema);
        this.caseSensitivity = IdentifierField.TABLE.setCaseSensitive(this.caseSensitivity, table);
        this.caseSensitivity = IdentifierField.COLUMN.setCaseSensitive(this.caseSensitivity, column);
        this.initSupportedFeatures();
    }

    protected void initSupportedFeatures() {
        this.supportedFeatures.supportAll();
        this.supportedFeatures.unsupportAll("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
        this.supportedFeatures.unsupport(ComparisonOperator.ILIKE.getFeatureDescription());
        this.supportedFeatures.unsupport(InUnitFunction.FEATURE);
    }

    @Override
    public final FeatureSet getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean isCaseSensitive(IdentifierField field) {
        return field != null && field.isCaseSensitive(this.caseSensitivity);
    }

    @Override
    public String translate(ADQLQuery query) throws TranslationException {
        StringBuffer sql = new StringBuffer();
        if (!query.getWith().isEmpty()) {
            sql.append(this.translate(query.getWith())).append('\n');
        }
        boolean withOffset = query.getOffset() != null && query.getOffset().getValue() > 0;
        sql.append(this.translate(query.getSelect(), !withOffset));
        sql.append("\nFROM ").append(this.translate(query.getFrom()));
        if (!query.getWhere().isEmpty()) {
            sql.append('\n').append(this.translate(query.getWhere()));
        }
        if (!query.getGroupBy().isEmpty()) {
            sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)query.getGroupBy()));
        }
        if (!query.getHaving().isEmpty()) {
            sql.append('\n').append(this.translate(query.getHaving()));
        }
        if (!query.getOrderBy().isEmpty()) {
            sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)query.getOrderBy()));
        }
        if (withOffset) {
            if (query.getOrderBy().isEmpty()) {
                sql.append("\nORDER BY 1 ASC");
            }
            sql.append("\nOFFSET ").append(query.getOffset().getValue()).append(" ROWS");
            if (query.hasLimit()) {
                sql.append(" FETCH NEXT ").append(query.getLimit()).append(" ROWS ONLY");
            }
        }
        return sql.toString();
    }

    @Override
    public String translate(SetOperation set) throws TranslationException {
        boolean extendedSetExp;
        StringBuffer sql = new StringBuffer();
        String tPrefix = "t" + System.currentTimeMillis() + "_";
        int tCnt = 1;
        if (!set.getWith().isEmpty()) {
            sql.append(this.translate(set.getWith())).append('\n');
        }
        boolean bl = extendedSetExp = set.getLeftSet() instanceof SetOperation || !set.getLeftSet().getWith().isEmpty() || !set.getLeftSet().getOrderBy().isEmpty() || set.getLeftSet().getOffset() != null;
        if (extendedSetExp) {
            sql.append("SELECT * FROM\n(");
        }
        sql.append(this.translate(set.getLeftSet()));
        if (extendedSetExp) {
            sql.append(") AS ").append(tPrefix + tCnt++);
        }
        sql.append('\n');
        sql.append((Object)set.getOperation());
        if (set.isWithDuplicates()) {
            sql.append(" ALL");
        }
        sql.append('\n');
        boolean bl2 = extendedSetExp = set.getRightSet() instanceof SetOperation || !set.getRightSet().getWith().isEmpty() || !set.getRightSet().getOrderBy().isEmpty() || set.getRightSet().getOffset() != null;
        if (extendedSetExp) {
            sql.append("SELECT * FROM\n(");
        }
        sql.append(this.translate(set.getRightSet()));
        if (extendedSetExp) {
            sql.append(") AS ").append(tPrefix + tCnt++);
        }
        if (!set.getOrderBy().isEmpty()) {
            sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)set.getOrderBy()));
        }
        if (set.getOffset() != null) {
            sql.append("\nOFFSET ").append(set.getOffset().getValue());
        }
        return sql.toString();
    }

    protected String translate(ClauseSelect clause, boolean topAllowed) throws TranslationException {
        String sql = null;
        for (int i = 0; i < clause.size(); ++i) {
            sql = i == 0 ? clause.getName() + (clause.distinctColumns() ? " DISTINCT" : "") + (topAllowed && clause.hasLimit() ? " TOP " + clause.getLimit() : "") : sql + " " + clause.getSeparator(i);
            sql = sql + " " + this.translate((SelectItem)clause.get(i));
        }
        return sql;
    }

    @Override
    public String translate(ClauseSelect clause) throws TranslationException {
        return this.translate(clause, true);
    }

    @Override
    public String translate(Comparison comp) throws TranslationException {
        switch (comp.getOperator()) {
            case ILIKE: 
            case NOTILIKE: {
                throw new TranslationException("Translation of ILIKE impossible! This is not supported natively in MS-SQL Server.");
            }
        }
        return this.translate(comp.getLeftOperand()) + " " + comp.getOperator().toADQL() + " " + this.translate(comp.getRightOperand());
    }

    @Override
    public String translate(InUnitFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(Concatenation concat) throws TranslationException {
        StringBuffer translated = new StringBuffer();
        for (ADQLOperand op : concat) {
            if (translated.length() > 0) {
                translated.append(" + ");
            }
            translated.append(this.translate(op));
        }
        return translated.toString();
    }

    @Override
    public String translate(ADQLJoin join) throws TranslationException {
        StringBuilder sql = new StringBuilder(this.translate(join.getLeftTable()));
        sql.append(' ').append(join.getJoinType()).append(' ').append(this.translate(join.getRightTable())).append(' ');
        if (join.isNatural()) {
            try {
                StringBuilder buf = new StringBuilder();
                SearchColumnList leftList = join.getLeftTable().getDBColumns();
                SearchColumnList rightList = join.getRightTable().getDBColumns();
                for (DBColumn leftCol : leftList) {
                    DBColumn rightCol = ADQLJoin.findAtMostOneColumn(leftCol.getADQLName(), (byte)0, rightList, false);
                    if (rightCol == null) continue;
                    ADQLJoin.findExactlyOneColumn(leftCol.getADQLName(), (byte)0, leftList, true);
                    if (buf.length() > 0) {
                        buf.append(" AND ");
                    }
                    buf.append(this.translate(this.generateJoinColumn(join.getLeftTable(), leftCol, new ADQLColumn(leftCol.getADQLName()))));
                    buf.append("=");
                    buf.append(this.translate(this.generateJoinColumn(join.getRightTable(), rightCol, new ADQLColumn(rightCol.getADQLName()))));
                }
                sql.append("ON ").append(buf.toString());
            }
            catch (UnresolvedJoinException uje) {
                throw new TranslationException("Impossible to resolve the NATURAL JOIN between " + join.getLeftTable().toADQL() + " and " + join.getRightTable().toADQL() + "!", uje);
            }
        } else if (join.hasJoinedColumns()) {
            try {
                StringBuilder buf = new StringBuilder();
                SearchColumnList leftList = join.getLeftTable().getDBColumns();
                SearchColumnList rightList = join.getRightTable().getDBColumns();
                Iterator<ADQLColumn> itCols = join.getJoinedColumns();
                while (itCols.hasNext()) {
                    ADQLColumn usingCol = itCols.next();
                    DBColumn leftCol = ADQLJoin.findExactlyOneColumn(usingCol.getColumnName(), usingCol.getCaseSensitive(), leftList, true);
                    DBColumn rightCol = ADQLJoin.findExactlyOneColumn(usingCol.getColumnName(), usingCol.getCaseSensitive(), rightList, false);
                    if (buf.length() > 0) {
                        buf.append(" AND ");
                    }
                    buf.append(this.translate(this.generateJoinColumn(join.getLeftTable(), leftCol, usingCol)));
                    buf.append("=");
                    buf.append(this.translate(this.generateJoinColumn(join.getRightTable(), rightCol, usingCol)));
                }
                sql.append("ON ").append(buf.toString());
            }
            catch (UnresolvedJoinException uje) {
                throw new TranslationException("Impossible to resolve the JOIN USING between " + join.getLeftTable().toADQL() + " and " + join.getRightTable().toADQL() + "!", uje);
            }
        } else if (join.getJoinCondition() != null) {
            sql.append(this.translate(join.getJoinCondition()));
        }
        return sql.toString();
    }

    protected ADQLColumn generateJoinColumn(FromContent table, DBColumn colMeta, ADQLColumn joinedColumn) {
        ADQLColumn newCol;
        ADQLColumn aDQLColumn = newCol = joinedColumn == null ? new ADQLColumn(colMeta.getADQLName()) : new ADQLColumn(joinedColumn);
        if (table != null) {
            if (table instanceof ADQLTable) {
                newCol.setAdqlTable((ADQLTable)table);
            } else {
                newCol.setAdqlTable(new ADQLTable(table.getName()));
            }
        }
        newCol.setDBLink(colMeta);
        return newCol;
    }

    @Override
    public String translate(ExtractCoord extractCoord) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoord);
    }

    @Override
    public String translate(ExtractCoordSys extractCoordSys) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoordSys);
    }

    @Override
    public String translate(AreaFunction areaFunction) throws TranslationException {
        return this.getDefaultADQLFunction(areaFunction);
    }

    @Override
    public String translate(CentroidFunction centroidFunction) throws TranslationException {
        return this.getDefaultADQLFunction(centroidFunction);
    }

    @Override
    public String translate(DistanceFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(ContainsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(IntersectsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(PointFunction point) throws TranslationException {
        return this.getDefaultADQLFunction(point);
    }

    @Override
    public String translate(CircleFunction circle) throws TranslationException {
        return this.getDefaultADQLFunction(circle);
    }

    @Override
    public String translate(BoxFunction box) throws TranslationException {
        return this.getDefaultADQLFunction(box);
    }

    @Override
    public String translate(PolygonFunction polygon) throws TranslationException {
        return this.getDefaultADQLFunction(polygon);
    }

    @Override
    public String translate(MathFunction fct) throws TranslationException {
        switch (fct.getType()) {
            case TRUNCATE: {
                if (fct.getNbParameters() >= 2) {
                    return "round(convert(float, " + this.translate(fct.getParameter(0)) + "), convert(float, " + this.translate(fct.getParameter(1)) + "), 1)";
                }
                return "round(convert(float, " + this.translate(fct.getParameter(0)) + "), 0, 1)";
            }
            case MOD: {
                return fct.getNbParameters() >= 2 ? "convert(numeric, " + this.translate(fct.getParameter(0)) + ") % convert(numeric, " + this.translate(fct.getParameter(1)) + ")" : "";
            }
            case ATAN2: {
                return "ATN2(" + this.translate(fct.getParameter(0)) + ", " + this.translate(fct.getParameter(1)) + ")";
            }
            case ABS: {
                return "abs(convert(float, " + this.translate(fct.getParameter(0)) + "))";
            }
            case CEILING: {
                return "ceiling(convert(float, " + this.translate(fct.getParameter(0)) + "))";
            }
            case DEGREES: {
                return "degrees(convert(float, " + this.translate(fct.getParameter(0)) + "))";
            }
            case FLOOR: {
                return "floor(convert(float, " + this.translate(fct.getParameter(0)) + "))";
            }
            case RADIANS: {
                return "radians(convert(float, " + this.translate(fct.getParameter(0)) + "))";
            }
            case ROUND: {
                if (fct.getNbParameters() >= 2) {
                    return "round(convert(float, " + this.translate(fct.getParameter(0)) + "), " + this.translate(fct.getParameter(1)) + ")";
                }
                return "round(convert(float, " + this.translate(fct.getParameter(0)) + "), 0)";
            }
        }
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public DBType convertTypeFromDB(int dbmsType, String rawDbmsTypeName, String dbmsTypeName, String[] params) {
        if (dbmsTypeName == null || dbmsTypeName.trim().length() == 0) {
            return null;
        }
        dbmsTypeName = dbmsTypeName.toLowerCase();
        int lengthParam = -1;
        if (params != null && params.length > 0) {
            try {
                lengthParam = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (dbmsTypeName.equals("smallint") || dbmsTypeName.equals("tinyint") || dbmsTypeName.equals("bit")) {
            return new DBType(DBType.DBDatatype.SMALLINT);
        }
        if (dbmsTypeName.equals("int")) {
            return new DBType(DBType.DBDatatype.INTEGER);
        }
        if (dbmsTypeName.equals("bigint") || dbmsTypeName.equals("unsigned bigint")) {
            return new DBType(DBType.DBDatatype.BIGINT);
        }
        if (dbmsTypeName.equals("real") || dbmsTypeName.equals("float") && lengthParam >= 1 && lengthParam <= 24) {
            return new DBType(DBType.DBDatatype.REAL);
        }
        if (dbmsTypeName.equals("float") || dbmsTypeName.equals("decimal") || dbmsTypeName.equals("numeric")) {
            return new DBType(DBType.DBDatatype.DOUBLE);
        }
        if (dbmsTypeName.equals("binary")) {
            return new DBType(DBType.DBDatatype.BINARY, lengthParam);
        }
        if (dbmsTypeName.equals("varbinary")) {
            return new DBType(DBType.DBDatatype.VARBINARY, lengthParam);
        }
        if (dbmsTypeName.equals("char") || dbmsTypeName.equals("nchar")) {
            return new DBType(DBType.DBDatatype.CHAR, lengthParam);
        }
        if (dbmsTypeName.equals("varchar") || dbmsTypeName.equals("nvarchar")) {
            return new DBType(DBType.DBDatatype.VARCHAR, lengthParam);
        }
        if (dbmsTypeName.equals("image")) {
            return new DBType(DBType.DBDatatype.BLOB);
        }
        if (dbmsTypeName.equals("text") || dbmsTypeName.equals("ntext")) {
            return new DBType(DBType.DBDatatype.CLOB);
        }
        if (dbmsTypeName.equals("timestamp") || dbmsTypeName.equals("datetime") || dbmsTypeName.equals("datetime2") || dbmsTypeName.equals("datetimeoffset") || dbmsTypeName.equals("smalldatetime") || dbmsTypeName.equals("time") || dbmsTypeName.equals("date") || dbmsTypeName.equals("date")) {
            return new DBType(DBType.DBDatatype.TIMESTAMP);
        }
        return null;
    }

    @Override
    public String convertTypeToDB(DBType type) {
        if (type == null) {
            return "varchar";
        }
        switch (type.type) {
            case SMALLINT: 
            case REAL: 
            case BIGINT: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return type.type.toString().toLowerCase();
            }
            case INTEGER: {
                return "int";
            }
            case DOUBLE: {
                return "float(53)";
            }
            case TIMESTAMP: {
                return "datetime";
            }
            case BLOB: {
                return "image";
            }
            case CLOB: {
                return "text";
            }
        }
        return "varchar";
    }

    @Override
    public Region translateGeometryFromDB(Object jdbcColValue) throws ParseException {
        throw new ParseException("Unsupported geometrical value! The value \"" + jdbcColValue + "\" can not be parsed as a region.");
    }

    @Override
    public Object translateGeometryToDB(Region region) throws ParseException {
        throw new ParseException("Geometries can not be uploaded in the database in this implementation!");
    }
}

