## TFSA-2022-017: Assertion failure based denial of service via faulty bin count operations

### CVE Number
CVE-2022-21737

### Impact
The [implementation of `*Bincount` operations](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/bincount_op.cc) allows malicious users to cause denial of service by passing in arguments which would trigger a `CHECK`-fail:

```python
import tensorflow as tf

tf.raw_ops.DenseBincount(
  input=[[0], [1], [2]],
  size=[1],
  weights=[3,2,1],
  binary_output=False)
```

There are several conditions that the input arguments must satisfy. Some are not caught during shape inference and others are not caught during kernel implementation. This results in `CHECK` failures later when the output tensors get allocated.

### Patches
We have patched the issue in GitHub commit [7019ce4f68925fd01cdafde26f8d8c938f47e6f9](https://github.com/tensorflow/tensorflow/commit/7019ce4f68925fd01cdafde26f8d8c938f47e6f9).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Faysal Hossain Shezan from University of Virginia.
