// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
/****************************************************************************/
/*                                                                          */
/* File:      npcheck.h                                                     */
/*                                                                          */
/* Purpose:   check of numerical structures (header file)                   */
/*                                                                          */
/* Author:    Christian Wieners                                                                             */
/*            Institut fuer Computeranwendungen III                                                 */
/*            Universitaet Stuttgart                                                                                */
/*            Pfaffenwaldring 27                                                                                    */
/*            70569 Stuttgart                                                                                               */
/*            email: ug@ica3.uni-stuttgart.de                                                       */
/*                                                                          */
/* History:   Juli 1 97 begin                                               */
/*                                                                          */
/* Remarks:                                                                 */
/*                                                                          */
/****************************************************************************/


/* RCS_ID
   $Header$
 */

/****************************************************************************/
/*                                                                          */
/* auto include mechanism and other include files                           */
/*                                                                          */
/****************************************************************************/

#ifndef __NPCHECK__
#define __NPCHECK__

#include "np.h"

#include "namespace.h"

START_UGDIM_NAMESPACE

/****************************************************************************/
/*                                                                          */
/* defines in the following order                                           */
/*                                                                          */
/*        compile time constants defining static data size (i.e. arrays)    */
/*        other constants                                                   */
/*        macros                                                            */
/*                                                                          */
/****************************************************************************/

/****************************************************************************/
/*                                                                          */
/* data structures exported by the corresponding source file                */
/*                                                                          */
/****************************************************************************/

/****************************************************************************/
/*                                                                          */
/* definition of exported global variables                                  */
/*                                                                          */
/****************************************************************************/

/****************************************************************************/
/*                                                                          */
/* function declarations                                                    */
/*                                                                          */
/****************************************************************************/

INT CheckSymmetryOfMatrix (GRID *theGrid, MATDATA_DESC *A);
INT CheckNP (MULTIGRID *theMG, INT argc, char **argv);

END_UGDIM_NAMESPACE

#endif
