/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H	1

#include "common.h"

/*------------------------------------------------------------------------*/

/* Global widgets */
extern GtkWidget
  *rx_scrolledwindow,
  *scope,
  *waterfall,
  *scope_label;

/* Speed and squelch spin button */
extern GtkSpinButton
  *speed,
  *squelch,
  *ratio;

/* Main window builder */
extern GtkBuilder *main_builder;

/* Runtime config data */
extern rc_data_t rc_data;

/* DSP samples buffer */
extern samples_buffer_t samples_buffer;

/* Waterfall window pixbuf */
extern GdkPixbuf *wfall_pixbuf;
extern guchar *wfall_pixels;
extern gint
  wfall_rowstride,
  wfall_n_channels,
  wfall_width,
  wfall_height;

/* Text buffer for text viewer */
extern GtkTextBuffer *rx_text_buffer;

extern gint
  scope_width,
  scope_height;

/* Average bin values */
extern int *bin_ave;

/* dft in/out buffers */
extern int
  *dft_in_r,
  *dft_out_r,
  *dft_out_i;

/*------------------------------------------------------------------------*/

#endif
