/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:31:52 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedReader;
import java.io.StringReader;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.TextDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class MSPcrunchDocumentEntry_ESTest extends MSPcrunchDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      StringReader stringReader0 = new StringReader("XN/~T");
      BufferedReader bufferedReader0 = new BufferedReader(stringReader0, 24);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(bufferedReader0);
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(document0, readListener0);
      Sequence sequence0 = mSPcrunchDocumentEntry0.getSequence();
      StreamSequence streamSequence0 = mSPcrunchDocumentEntry0.makeNativeSequence(sequence0);
      assertEquals(0, streamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("k0![)k4&!|:bKM>X?");
      StreamSequence streamSequence0 = mSPcrunchDocumentEntry0.makeNativeSequence(emblStreamSequence0);
      assertEquals(17, streamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Only FiniteAlphabets using a char token are supported by UkkonenSuffixTree");
      StreamSequence streamSequence0 = mSPcrunchDocumentEntry0.makeNativeSequence(genbankStreamSequence0);
      assertEquals(64, streamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(mSPcrunchEntryInformation0);
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Object object0 = mSPcrunchDocumentEntry0.makeNativeFeature(genbankStreamFeature0, true);
      assertNotNull(object0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      char[] charArray0 = new char[4];
      Short short0 = new Short((short)13931);
      Integer integer0 = JLayeredPane.DRAG_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-666), (-666), short0, integer0);
      // Undeclared exception!
      try { 
        mSPcrunchDocumentEntry0.makeNativeSequence(partialSequence0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn((LinePushBackReader) null).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(document0, readListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LineGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(document0, readListener0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      MockFile mockFile0 = new MockFile("_p,NwKoZD NXO", "_p,NwKoZD NXO");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(fileDocument0, readListener0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((Entry) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      // Undeclared exception!
      try { 
        mSPcrunchDocumentEntry0.makeNativeFeature((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      boolean boolean0 = mSPcrunchDocumentEntry0.isReadOnly();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      // Undeclared exception!
      try { 
        mSPcrunchDocumentEntry0.makeNativeSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry1 = new MSPcrunchDocumentEntry(mSPcrunchDocumentEntry0, false);
      assertFalse(mSPcrunchDocumentEntry1.equals((Object)mSPcrunchDocumentEntry0));
  }
}
