+++
title = "CantellatedCube"
+++

### CantellatedCube

A cube with truncated edges and vertices as in Fig 7 of [[Croset 2017](/lit/croset2017)]. Can also be obtained by cantellating an octahedron. Also known as [Rhombicuboctahedron](https://en.wikipedia.org/wiki/Rhombicuboctahedron).

<img src="https://upload.wikimedia.org/wikipedia/commons/c/c4/Rhombicuboctahedron_by_Cutting_Rhombic_Dodecahedron.svg" width="30%" >
<!--
<img src="../cut/CantellatedCube_xy.svg" width="30%">
<img src="../cut/CantellatedCube_xz.svg" width="30%">
-->

#### Constructor

```python
CantellatedCube(L, t)
```

Parameters:
- L, length of the full cube
- t, side length of the birectangular prisms removed from the cube’s edges

Constraint:

$ t \le L/2 $ 

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [CantellatedCube]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron with inversion symmetry provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V= L^3 - 6Lt^2 + \dfrac{16}{3} t^3. $$

#### Related shapes

- [Box](/ref/sample/particle/ff/hard/box), a rectangular cuboid.
- [TruncatedCube](/ref/sample/particle/ff/hard/truncatedcube), if truncated vertices only.

Scattering by uncorrelated, oriented cantellated cubes for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/CantellatedCube.png">

Generated by {{% ref-ex "ff/CantellatedCube.py" %}}.

#### History

Introduced in BornAgain 1.17 (Python only). Motivated by [[Croset 2017](/lit/croset2017)].
