pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with System;
with dbus_types_h;

package dbus_threads_h is

   --  skipped empty struct DBusMutex

   --  skipped empty struct DBusCondVar

   type DBusMutexNewFunction is access function return System.Address;  -- ../dbus/dbus-threads.h:46:24

   type DBusMutexFreeFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:48:24

   type DBusMutexLockFunction is access function (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:50:24

   type DBusMutexUnlockFunction is access function (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:52:24

   type DBusRecursiveMutexNewFunction is access function return System.Address;  -- ../dbus/dbus-threads.h:61:24

   type DBusRecursiveMutexFreeFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:64:24

   type DBusRecursiveMutexLockFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:68:24

   type DBusRecursiveMutexUnlockFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:72:24

   type DBusCondVarNewFunction is access function return System.Address;  -- ../dbus/dbus-threads.h:77:26

   type DBusCondVarFreeFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:80:26

   type DBusCondVarWaitFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-threads.h:92:26

   type DBusCondVarWaitTimeoutFunction is access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:101:26

   type DBusCondVarWakeOneFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:108:26

   type DBusCondVarWakeAllFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:114:26

   subtype DBusThreadFunctionsMask is unsigned;
   DBUS_THREAD_FUNCTIONS_MUTEX_NEW_MASK : constant DBusThreadFunctionsMask := 1;
   DBUS_THREAD_FUNCTIONS_MUTEX_FREE_MASK : constant DBusThreadFunctionsMask := 2;
   DBUS_THREAD_FUNCTIONS_MUTEX_LOCK_MASK : constant DBusThreadFunctionsMask := 4;
   DBUS_THREAD_FUNCTIONS_MUTEX_UNLOCK_MASK : constant DBusThreadFunctionsMask := 8;
   DBUS_THREAD_FUNCTIONS_CONDVAR_NEW_MASK : constant DBusThreadFunctionsMask := 16;
   DBUS_THREAD_FUNCTIONS_CONDVAR_FREE_MASK : constant DBusThreadFunctionsMask := 32;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAIT_MASK : constant DBusThreadFunctionsMask := 64;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAIT_TIMEOUT_MASK : constant DBusThreadFunctionsMask := 128;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAKE_ONE_MASK : constant DBusThreadFunctionsMask := 256;
   DBUS_THREAD_FUNCTIONS_CONDVAR_WAKE_ALL_MASK : constant DBusThreadFunctionsMask := 512;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_NEW_MASK : constant DBusThreadFunctionsMask := 1024;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_FREE_MASK : constant DBusThreadFunctionsMask := 2048;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_LOCK_MASK : constant DBusThreadFunctionsMask := 4096;
   DBUS_THREAD_FUNCTIONS_RECURSIVE_MUTEX_UNLOCK_MASK : constant DBusThreadFunctionsMask := 8192;
   DBUS_THREAD_FUNCTIONS_ALL_MASK : constant DBusThreadFunctionsMask := 16383;  -- ../dbus/dbus-threads.h:138:3

   type DBusThreadFunctions is record
      mask : aliased unsigned;  -- ../dbus/dbus-threads.h:163:16
      mutex_new : access function return System.Address;  -- ../dbus/dbus-threads.h:165:24
      mutex_free : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:166:25
      mutex_lock : access function (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:167:25
      mutex_unlock : access function (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:168:27
      condvar_new : access function return System.Address;  -- ../dbus/dbus-threads.h:170:26
      condvar_free : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:171:27
      condvar_wait : access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-threads.h:172:27
      condvar_wait_timeout : access function
           (arg1 : System.Address;
            arg2 : System.Address;
            arg3 : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:173:34
      condvar_wake_one : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:174:30
      condvar_wake_all : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:175:30
      recursive_mutex_new : access function return System.Address;  -- ../dbus/dbus-threads.h:177:33
      recursive_mutex_free : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:178:34
      recursive_mutex_lock : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:179:34
      recursive_mutex_unlock : access procedure (arg1 : System.Address);  -- ../dbus/dbus-threads.h:180:36
      padding1 : access procedure;  -- ../dbus/dbus-threads.h:182:11
      padding2 : access procedure;  -- ../dbus/dbus-threads.h:183:11
      padding3 : access procedure;  -- ../dbus/dbus-threads.h:184:11
      padding4 : access procedure;  -- ../dbus/dbus-threads.h:185:11
   end record;
   pragma Convention (C_Pass_By_Copy, DBusThreadFunctions);  -- ../dbus/dbus-threads.h:187:3

   function dbus_threads_init (arg1 : access constant DBusThreadFunctions) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:189:14
   pragma Import (C, dbus_threads_init, "dbus_threads_init");

   function dbus_threads_init_default return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-threads.h:190:14
   pragma Import (C, dbus_threads_init_default, "dbus_threads_init_default");

end dbus_threads_h;
