/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class MinMaxPriorityQueueTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testContains() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testContains();
}

public void testCorrectOrdering_73ElementBug() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_73ElementBug();
}

public void testCorrectOrdering_mediumHeapsPollFirst() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_mediumHeapsPollFirst();
}

public void testCorrectOrdering_mediumHeapsPollLast() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_mediumHeapsPollLast();
}

public void testCorrectOrdering_randomAccess() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_randomAccess();
}

public void testCorrectOrdering_regression() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_regression();
}

public void testCorrectOrdering_smallHeapsPollFirst() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_smallHeapsPollFirst();
}

public void testCorrectOrdering_smallHeapsPollLast() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCorrectOrdering_smallHeapsPollLast();
}

public void testCreateWithCapacityAndOrdering() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreateWithCapacityAndOrdering();
}

public void testCreateWithOrdering() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreateWithOrdering();
}

public void testCreation_allOptions() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_allOptions();
}

public void testCreation_comparator() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_comparator();
}

public void testCreation_comparator_maximumSize() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_comparator_maximumSize();
}

public void testCreation_comparator_withContents() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_comparator_withContents();
}

public void testCreation_expectedSize() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_expectedSize();
}

public void testCreation_expectedSize_comparator() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_expectedSize_comparator();
}

public void testCreation_expectedSize_maximumSize() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_expectedSize_maximumSize();
}

public void testCreation_expectedSize_withContents() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_expectedSize_withContents();
}

public void testCreation_maximumSize() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_maximumSize();
}

public void testCreation_maximumSize_withContents() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_maximumSize_withContents();
}

public void testCreation_simple() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_simple();
}

public void testCreation_withContents() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testCreation_withContents();
}

public void testExhaustive_pollAndPush() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testExhaustive_pollAndPush();
}

public void testHeapIntact() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testHeapIntact();
}

public void testInvalidatingRemove() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testInvalidatingRemove();
}

public void testInvalidatingRemove2() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testInvalidatingRemove2();
}

public void testIsEvenLevel() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIsEvenLevel();
}

public void testIteratorConcurrentModification() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorConcurrentModification();
}

public void testIteratorInvalidatingIteratorRemove() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorInvalidatingIteratorRemove();
}

public void testIteratorInvalidatingIteratorRemove2() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorInvalidatingIteratorRemove2();
}

public void testIteratorPastEndException() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorPastEndException();
}

public void testIteratorRegressionChildlessUncle() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorRegressionChildlessUncle();
}

public void testIteratorTester() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorTester();
}

public void testIteratorTesterLarger() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testIteratorTesterLarger();
}

public void testRandomAddsAndRemoves() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRandomAddsAndRemoves();
}

public void testRandomAddsAndRemoves_duplicateElements() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRandomAddsAndRemoves_duplicateElements();
}

public void testRandomRemoves() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRandomRemoves();
}

public void testRegression_dataCorruption() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRegression_dataCorruption();
}

public void testRemove() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRemove();
}

public void testRemoveAt() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRemoveAt();
}

public void testRemoveAt_exhaustive() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRemoveAt_exhaustive();
}

public void testRemoveFromStringHeap() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRemoveFromStringHeap();
}

public void testRemoveRegression() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testRemoveRegression();
}

public void testSmall() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testSmall();
}

public void testSmallMinHeap() throws Exception {
  com.google.common.collect.MinMaxPriorityQueueTest testCase = new com.google.common.collect.MinMaxPriorityQueueTest();
  testCase.testSmallMinHeap();
}
}
