/*
 *   Copyright 2015 Marco Martin <mart@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.1
import QtGraphicalEffects 1.0
import org.kde.kirigami 1.0

//TODO: This will become a QQC2 Drawer
//providing just a dummy api for now
Item {
    id: root
    anchors {
        fill: parent
        topMargin: !modal && applicationWindow !== undefined && applicationWindow().header && applicationWindow().controlsVisible ? applicationWindow().header.height : 0
    }
    z: 9999

    default property alias page: mainPage.data
    property Item contentItem
    property bool opened
    property int edge: Qt.LeftEdge
    property real position: 0
    property bool modal: true

    function open () { }
    function close () { }
    signal clicked

    Item {
        id: mainPage
        anchors.fill: parent
        onChildrenChanged: mainPage.children[0].anchors.fill = mainPage
    }
}

