!ifndef SHCNE_ASSOCCHANGED
  !define SHCNE_ASSOCCHANGED 0x08000000
!endif
!ifndef SHCNF_IDLIST
  !define SHCNF_IDLIST 0x0000
!endif

!macro MediaInfo_Extensions_Install_I Extension
  ; Old InfoTip
  DeleteRegKey HKCR "${Extension}\shellex\{00021500-0000-0000-C000-000000000046}"
  DeleteRegKey /ifempty HKCR "${Extension}\shellex"
  ; Old Extension
  ReadRegStr $1 HKCR "${Extension}" ""
  DeleteRegKey HKCR "$1\Shell\Media Info"
  DeleteRegKey HKCR "$1\Shell\MediaInfo"
  DeleteRegKey /ifempty HKCR "$1\Shell"
  DeleteRegKey /ifempty HKCR "$1"
  ; Old Extension (folder...)
  DeleteRegKey HKCR "${Extension}\Shell\MediaInfo"
  DeleteRegKey /ifempty HKCR "${Extension}\Shell"
  ; Old Extension (in 1 version)
  DeleteRegKey HKCR "SystemFileAssociations\${Extension}\Shell\MediaInfo"
  DeleteRegKey /ifempty HKCR "SystemFileAssociations\${Extension}\Shell"

  WriteRegStr HKCU "Software\Classes\SystemFileAssociations\${Extension}\Shell\MediaInfo" "Icon" "$INSTDIR\MediaInfo.exe"
  WriteRegStr HKCU "Software\Classes\SystemFileAssociations\${Extension}\Shell\MediaInfo\Command" "" "$\"$INSTDIR\MediaInfo.exe$\" $\"%1$\""
!macroend

!macro MediaInfo_Extensions_Uninstall_I Extension
  ; InfoTip
  DeleteRegKey HKCU "Software\Classes\${Extension}\shellex\{00021500-0000-0000-C000-000000000046}"
  DeleteRegKey /ifempty HKCU "Software\Classes\${Extension}\shellex"
  ; Extension
  DeleteRegKey HKCU "Software\Classes\SystemFileAssociations\${Extension}\shell\MediaInfo"
  DeleteRegKey /ifempty HKCU "Software\Classes\SystemFileAssociations\${Extension}\shell"
!macroend

!macro MediaInfo_Extensions_Install
  ;Removing Atak_Snajpera's "MediaInfoLite" stuff in registry (not supported by MediaArea.net, but MediaInfo official website has bug reports about this software)
  DeleteRegKey HKCU "Software\\Classes\\*\\Shell\\Media Info"
  DeleteRegKey HKCR "*\\Shell\\MediaInfo"
  DeleteRegKey HKCU "Software\\MediaInfo"

  ; Removing unwanted entries
  !insertmacro MediaInfo_Extensions_Uninstall_I "Directory.Audio"
  !insertmacro MediaInfo_Extensions_Uninstall_I "Directory.Video"
  !insertmacro MediaInfo_Extensions_Uninstall_I "audio"
  !insertmacro MediaInfo_Extensions_Uninstall_I "Folder"
  !insertmacro MediaInfo_Extensions_Uninstall_I "video"

  ; directories
  WriteRegStr HKCU "Software\Classes\Directory\Shell\MediaInfo" "Icon" "$INSTDIR\MediaInfo.exe"
  WriteRegStr HKCU "Software\Classes\Directory\Shell\MediaInfo\Command" "" "$\"$INSTDIR\MediaInfo.exe$\" $\"%1$\""

  ; Per item
  !insertmacro MediaInfo_Extensions_Install_I ".264"
  !insertmacro MediaInfo_Extensions_Install_I ".3g2"
  !insertmacro MediaInfo_Extensions_Install_I ".3ga"
  !insertmacro MediaInfo_Extensions_Install_I ".3gp"
  !insertmacro MediaInfo_Extensions_Install_I ".3gpa"
  !insertmacro MediaInfo_Extensions_Install_I ".3gpp"
  !insertmacro MediaInfo_Extensions_Install_I ".aa3"
  !insertmacro MediaInfo_Extensions_Install_I ".aac"
  !insertmacro MediaInfo_Extensions_Install_I ".aacp"
  !insertmacro MediaInfo_Extensions_Install_I ".adts"
  !insertmacro MediaInfo_Extensions_Install_I ".ac3"
  !insertmacro MediaInfo_Extensions_Install_I ".act"
  !insertmacro MediaInfo_Extensions_Install_I ".aif"
  !insertmacro MediaInfo_Extensions_Install_I ".aifc"
  !insertmacro MediaInfo_Extensions_Install_I ".aiff"
  !insertmacro MediaInfo_Extensions_Install_I ".amr"
  !insertmacro MediaInfo_Extensions_Install_I ".ape"
  !insertmacro MediaInfo_Extensions_Install_I ".asf"
  !insertmacro MediaInfo_Extensions_Install_I ".at3"
  !insertmacro MediaInfo_Extensions_Install_I ".au"
  !insertmacro MediaInfo_Extensions_Install_I ".aud"
  !insertmacro MediaInfo_Extensions_Install_I ".aue"
  !insertmacro MediaInfo_Extensions_Install_I ".avi"
  !insertmacro MediaInfo_Extensions_Install_I ".avif"
  !insertmacro MediaInfo_Extensions_Install_I ".avs"
  !insertmacro MediaInfo_Extensions_Install_I ".bdmv"
  !insertmacro MediaInfo_Extensions_Install_I ".bmp"
  !insertmacro MediaInfo_Extensions_Install_I ".bms"
  !insertmacro MediaInfo_Extensions_Install_I ".braw"
  !insertmacro MediaInfo_Extensions_Install_I ".caf"
  !insertmacro MediaInfo_Extensions_Install_I ".clpi"
  !insertmacro MediaInfo_Extensions_Install_I ".dat"
  !insertmacro MediaInfo_Extensions_Install_I ".dde"
  !insertmacro MediaInfo_Extensions_Install_I ".divx"
  !insertmacro MediaInfo_Extensions_Install_I ".dpg"
  !insertmacro MediaInfo_Extensions_Install_I ".dff"
  !insertmacro MediaInfo_Extensions_Install_I ".dsd"
  !insertmacro MediaInfo_Extensions_Install_I ".dsf"
  !insertmacro MediaInfo_Extensions_Install_I ".dts"
  !insertmacro MediaInfo_Extensions_Install_I ".dtshd"
  !insertmacro MediaInfo_Extensions_Install_I ".dv"
  !insertmacro MediaInfo_Extensions_Install_I ".dvr"
  !insertmacro MediaInfo_Extensions_Install_I ".dvr-ms"
  !insertmacro MediaInfo_Extensions_Install_I ".eac3"
  !insertmacro MediaInfo_Extensions_Install_I ".evo"
  !insertmacro MediaInfo_Extensions_Install_I ".f4a"
  !insertmacro MediaInfo_Extensions_Install_I ".f4b"
  !insertmacro MediaInfo_Extensions_Install_I ".f4v"
  !insertmacro MediaInfo_Extensions_Install_I ".fla"
  !insertmacro MediaInfo_Extensions_Install_I ".flc"
  !insertmacro MediaInfo_Extensions_Install_I ".fli"
  !insertmacro MediaInfo_Extensions_Install_I ".flac"
  !insertmacro MediaInfo_Extensions_Install_I ".flv"
  !insertmacro MediaInfo_Extensions_Install_I ".gvi"
  !insertmacro MediaInfo_Extensions_Install_I ".gif"
  !insertmacro MediaInfo_Extensions_Install_I ".gis"
  !insertmacro MediaInfo_Extensions_Install_I ".h264"
  !insertmacro MediaInfo_Extensions_Install_I ".h3d"
  !insertmacro MediaInfo_Extensions_Install_I ".hdmov"
  !insertmacro MediaInfo_Extensions_Install_I ".heic"
  !insertmacro MediaInfo_Extensions_Install_I ".heif"
  !insertmacro MediaInfo_Extensions_Install_I ".iamf"
  !insertmacro MediaInfo_Extensions_Install_I ".ico"
  !insertmacro MediaInfo_Extensions_Install_I ".ifo"
  !insertmacro MediaInfo_Extensions_Install_I ".ism"
  !insertmacro MediaInfo_Extensions_Install_I ".isma"
  !insertmacro MediaInfo_Extensions_Install_I ".ismv"
  !insertmacro MediaInfo_Extensions_Install_I ".j2k"
  !insertmacro MediaInfo_Extensions_Install_I ".jp2"
  !insertmacro MediaInfo_Extensions_Install_I ".jpeg"
  !insertmacro MediaInfo_Extensions_Install_I ".jpg"
  !insertmacro MediaInfo_Extensions_Install_I ".jps"
  !insertmacro MediaInfo_Extensions_Install_I ".jxl"
  !insertmacro MediaInfo_Extensions_Install_I ".m1s"
  !insertmacro MediaInfo_Extensions_Install_I ".m1t"
  !insertmacro MediaInfo_Extensions_Install_I ".m1v"
  !insertmacro MediaInfo_Extensions_Install_I ".m2p"
  !insertmacro MediaInfo_Extensions_Install_I ".m2s"
  !insertmacro MediaInfo_Extensions_Install_I ".m2t"
  !insertmacro MediaInfo_Extensions_Install_I ".m2ts"
  !insertmacro MediaInfo_Extensions_Install_I ".m2v"
  !insertmacro MediaInfo_Extensions_Install_I ".m4a"
  !insertmacro MediaInfo_Extensions_Install_I ".m4b"
  !insertmacro MediaInfo_Extensions_Install_I ".m4v"
  !insertmacro MediaInfo_Extensions_Install_I ".mac"
  !insertmacro MediaInfo_Extensions_Install_I ".mk3d"
  !insertmacro MediaInfo_Extensions_Install_I ".mka"
  !insertmacro MediaInfo_Extensions_Install_I ".mks"
  !insertmacro MediaInfo_Extensions_Install_I ".mkv"
  !insertmacro MediaInfo_Extensions_Install_I ".mlp"
  !insertmacro MediaInfo_Extensions_Install_I ".mod"
  !insertmacro MediaInfo_Extensions_Install_I ".mov"
  !insertmacro MediaInfo_Extensions_Install_I ".mp+"
  !insertmacro MediaInfo_Extensions_Install_I ".mp2"
  !insertmacro MediaInfo_Extensions_Install_I ".mp3"
  !insertmacro MediaInfo_Extensions_Install_I ".mp4"
  !insertmacro MediaInfo_Extensions_Install_I ".mpc"
  !insertmacro MediaInfo_Extensions_Install_I ".mpd"
  !insertmacro MediaInfo_Extensions_Install_I ".mpe"
  !insertmacro MediaInfo_Extensions_Install_I ".mpeg"
  !insertmacro MediaInfo_Extensions_Install_I ".mpg"
  !insertmacro MediaInfo_Extensions_Install_I ".mpgv"
  !insertmacro MediaInfo_Extensions_Install_I ".mpgx"
  !insertmacro MediaInfo_Extensions_Install_I ".mpls"
  !insertmacro MediaInfo_Extensions_Install_I ".mpm"
  !insertmacro MediaInfo_Extensions_Install_I ".mpo"
  !insertmacro MediaInfo_Extensions_Install_I ".mpv"
  !insertmacro MediaInfo_Extensions_Install_I ".mts"
  !insertmacro MediaInfo_Extensions_Install_I ".mxf"
  !insertmacro MediaInfo_Extensions_Install_I ".oga"
  !insertmacro MediaInfo_Extensions_Install_I ".ogg"
  !insertmacro MediaInfo_Extensions_Install_I ".ogm"
  !insertmacro MediaInfo_Extensions_Install_I ".ogv"
  !insertmacro MediaInfo_Extensions_Install_I ".ogx"
  !insertmacro MediaInfo_Extensions_Install_I ".oma"
  !insertmacro MediaInfo_Extensions_Install_I ".opus"
  !insertmacro MediaInfo_Extensions_Install_I ".png"
  !insertmacro MediaInfo_Extensions_Install_I ".pns"
  !insertmacro MediaInfo_Extensions_Install_I ".qcp"
  !insertmacro MediaInfo_Extensions_Install_I ".qt"
  !insertmacro MediaInfo_Extensions_Install_I ".ra"
  !insertmacro MediaInfo_Extensions_Install_I ".rm"
  !insertmacro MediaInfo_Extensions_Install_I ".rmvb"
  !insertmacro MediaInfo_Extensions_Install_I ".shn"
  !insertmacro MediaInfo_Extensions_Install_I ".smv"
  !insertmacro MediaInfo_Extensions_Install_I ".spdif"
  !insertmacro MediaInfo_Extensions_Install_I ".spx"
  !insertmacro MediaInfo_Extensions_Install_I ".stl"
  !insertmacro MediaInfo_Extensions_Install_I ".swf"
  !insertmacro MediaInfo_Extensions_Install_I ".tak"
  !insertmacro MediaInfo_Extensions_Install_I ".thd"
  !insertmacro MediaInfo_Extensions_Install_I ".thd+ac3"
  !insertmacro MediaInfo_Extensions_Install_I ".tif"
  !insertmacro MediaInfo_Extensions_Install_I ".tiff"
  !insertmacro MediaInfo_Extensions_Install_I ".tmf"
  !insertmacro MediaInfo_Extensions_Install_I ".tp"
  !insertmacro MediaInfo_Extensions_Install_I ".trec"
  !insertmacro MediaInfo_Extensions_Install_I ".trp"
  !insertmacro MediaInfo_Extensions_Install_I ".ts"
  !insertmacro MediaInfo_Extensions_Install_I ".tta"
  !insertmacro MediaInfo_Extensions_Install_I ".ty"
  !insertmacro MediaInfo_Extensions_Install_I ".vob"
  !insertmacro MediaInfo_Extensions_Install_I ".vqf"
  !insertmacro MediaInfo_Extensions_Install_I ".vro"
  !insertmacro MediaInfo_Extensions_Install_I ".w64"
  !insertmacro MediaInfo_Extensions_Install_I ".wav"
  !insertmacro MediaInfo_Extensions_Install_I ".webm"
  !insertmacro MediaInfo_Extensions_Install_I ".webp"
  !insertmacro MediaInfo_Extensions_Install_I ".wma"
  !insertmacro MediaInfo_Extensions_Install_I ".wmv"
  !insertmacro MediaInfo_Extensions_Install_I ".wtv"
  !insertmacro MediaInfo_Extensions_Install_I ".wv"
  !insertmacro MediaInfo_Extensions_Install_I ".wvc"
  !insertmacro MediaInfo_Extensions_Install_I ".y4m"

  ; Notify Windows Shell to refresh
  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'
!macroend

!macro MediaInfo_Extensions_Uninstall
  ;Old stuff
  !insertmacro MediaInfo_Extensions_Install

  ; Global
  DeleteRegKey HKCU "Software\Classes\CLSID\{869C14C8-1830-491F-B575-5F9AB40D2B42}"
  DeleteRegKey HKCU "Software\Classes\MediaInfoShellExt.MediaInfoShellExt_"
  DeleteRegKey HKCU "Software\Classes\MediaInfoShellExt.MediaInfoShellExt_.1"

  ; directories
  DeleteRegKey HKCU "Software\Classes\Directory\Shell\MediaInfo"
  DeleteRegKey /ifempty HKCU "Software\Classes\Directory\Shell"

  !insertmacro MediaInfo_Extensions_Uninstall_I ".264"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".3g2"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".3ga"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".3gp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".3gpa"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".3gpp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aa3"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aac"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aacp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".adts"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ac3"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".act"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aif"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aifc"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aiff"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".amr"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ape"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".asf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".at3"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".au"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aud"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".aue"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".avi"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".avif"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".avs"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".bdmv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".bmp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".bms"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".braw"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".caf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".clpi"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dat"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dde"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".divx"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dpg"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dff"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dsd"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dsf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dts"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dtshd"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dvr"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".dvr-ms"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".eac3"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".evo"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".f4a"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".f4b"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".f4v"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".fla"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".flc"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".fli"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".flac"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".flv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".gvi"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".gif"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".gis"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".h264"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".h3d"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".hdmov"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".heic"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".heif"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".iamf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ico"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ifo"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ism"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".isma"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ismv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".j2k"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".jp2"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".jpeg"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".jpg"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".jps"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".jxl"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m1s"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m1t"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m1v"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m2p"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m2s"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m2t"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m2ts"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m2v"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m4a"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m4b"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".m4v"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mac"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mk3d"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mka"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mks"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mkv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mlp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mod"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mov"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mp+"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mp2"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mp3"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mp4"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpc"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpd"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpe"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpeg"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpg"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpgv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpgx"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpls"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpm"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpo"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mpv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mts"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".mxf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".oga"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ogg"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ogm"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ogv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ogx"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".oma"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".opus"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".png"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".pns"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".qcp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".qt"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ra"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".rm"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".rmvb"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".shn"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".smv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".spdif"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".spx"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".stl"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".swf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".tak"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".thd"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".thd+ac3"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".tif"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".tiff"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".tmf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".tp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".trec"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".trp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ts"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".tta"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".ty"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".vob"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".vqf"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".vro"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".w64"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".wav"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".webm"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".webp"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".wma"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".wmv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".wtv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".wv"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".wvc"
  !insertmacro MediaInfo_Extensions_Uninstall_I ".y4m"

  ; Notify Windows Shell to refresh
  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'
!macroend
