/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "TemplateLexer_p.h"
#include <GTLCore/Token_p.h>

using namespace OpenCTL;

TemplateLexer::TemplateLexer(std::istream* sstream) : LexerBase(sstream)
{
}

TemplateLexer::~TemplateLexer()
{
}

GTLCore::Token TemplateLexer::nextToken()
{
  int lastChar = getNextChar();
  int initial_col = column() - 1;
  if( eof() ) return GTLCore::Token(GTLCore::Token::END_OF_FILE, line(), initial_col);
  CHAR_IS_TOKEN( '(', STARTBRACKET );
  CHAR_IS_TOKEN( ')', ENDBRACKET );
  CHAR_IS_TOKEN( ',', COMA );
  CHAR_IS_TOKEN( '=', EQUAL );
  if( lastChar == '@' ) {
    GTLCore::String identifierStr = getIdentifier(0);
    IDENTIFIER_IS_KEYWORD( "allchannels", ALLCHANNELS );
    IDENTIFIER_IS_KEYWORD( "colorchannels", COLORCHANNELS );
    IDENTIFIER_IS_KEYWORD( "alphachannel", ALPHACHANNEL );
    IDENTIFIER_IS_KEYWORD( "alpha", ALPHA );
    IDENTIFIER_IS_KEYWORD( "alphamax", ALPHAMAX );
    IDENTIFIER_IS_KEYWORD( "alphamin", ALPHAMIN );
    IDENTIFIER_IS_KEYWORD( "alphaunit", ALPHAUNIT );
    IDENTIFIER_IS_KEYWORD( "operation", OPERATION );
    IDENTIFIER_IS_KEYWORD( "type", TYPE );
    IDENTIFIER_IS_KEYWORD( "max", MAX );
    IDENTIFIER_IS_KEYWORD( "min", MIN );
    IDENTIFIER_IS_KEYWORD( "unit", UNIT );
    IDENTIFIER_IS_KEYWORD( "var", VAR );
    IDENTIFIER_IS_KEYWORD( "out", OUTPUT );
    IDENTIFIER_IS_KEYWORD( "output", OUTPUT );
    IDENTIFIER_IS_KEYWORD( "in", INPUT );
    IDENTIFIER_IS_KEYWORD( "input", INPUT );
    IDENTIFIER_IS_KEYWORD( "include", INCLUDE );
    return GTLCore::Token(GTLCore::Token::STRING_CONSTANT, "@" + identifierStr,line(), initial_col);
  }
  GTLCore::String str;
  str = lastChar;
  while(not eof())
  {
    lastChar = getNextChar();
    if( lastChar == '@' or lastChar == '(' or lastChar == ')' or lastChar == ',' or lastChar == '=' or eof() )
    {
      unget();
      break;
    } else {
      str += lastChar;
    }
  }
  return GTLCore::Token(GTLCore::Token::STRING_CONSTANT, str, line(), initial_col);
}
