/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ErrorMessages_p.h"
#include "CompilationMessage.h"

using namespace GTLCore;

CompilationMessage* ErrorMessages::unimplemented(const String& what)
{
  return new CompilationMessage(CompilationMessage::ERROR, "Unimplemented: " + what);
}

CompilationMessage* ErrorMessages::assigningValueToConstant()
{
  return new CompilationMessage(CompilationMessage::ERROR, "Can't assign a value to a constant after initialisation.");
}

CompilationMessage* ErrorMessages::variableIsPrimitive()
{
  return new CompilationMessage(CompilationMessage::ERROR, "The variable is a primitive type.");
}

CompilationMessage* ErrorMessages::variableIsArray()
{
  return new CompilationMessage(CompilationMessage::ERROR, "The variable is an array.");
}

CompilationMessage* ErrorMessages::variableIsStructure()
{
  return new CompilationMessage(CompilationMessage::ERROR, "The variable is a structure.");
}

CompilationMessage* ErrorMessages::unknownStructureMember(const String& member)
{
  return new CompilationMessage(CompilationMessage::ERROR, "Unknown structure member: " + member);
}
