/*
 *  Copyright (c) 2007-2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_SCOPED_NAME_H_
#define _GTLCORE_SCOPED_NAME_H_

#include <GTLCore/String.h>

namespace GTLCore {
  /**
   * @ingroup GTLCore
   * Define a name (function, variable...) and its namespace.
   */
  class GTLCORE_EXPORT ScopedName {
    public:
      ScopedName();
      ScopedName( const String& _nameSpace, const String& _name);
      ScopedName( const ScopedName&);
      ScopedName& operator=(const ScopedName& rhs);
      ~ScopedName();
      String toString() const;
      bool isEmpty() const;
      bool operator<( const ScopedName& sn ) const;
      bool operator==( const ScopedName& sn ) const;
      const String& name() const;
      const String& nameSpace() const;
    private:
      void deref();
      struct Private;
      Private* d;
  };
}

#endif
