/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "TimeValue_p.h"

#include "Color.h"
#include "Macros_p.h"

using namespace GTLCore;

TimeValue::~TimeValue()
{

}

TimeVectorArrayValue::TimeVectorArrayValue( const GTLCore::Type* type, std::vector<TimeValue*> timeValues ) : m_type(type), m_timeValues(timeValues)
{
}

TimeVectorArrayValue::~TimeVectorArrayValue()
{
}

Value TimeVectorArrayValue::value(double t) const
{
  std::vector< Value > values;
  foreach(const TimeValue* val, m_timeValues)
  {
    values.push_back(val->value(t));
  }
  
  return Value(values, m_type );
}

TimeColorValue::TimeColorValue( const TimeController* redController, const TimeController* greenController, const TimeController* blueController, const TimeController* alphaController ) : m_red(redController), m_green(greenController), m_blue(blueController), m_alpha(alphaController)
{
}

TimeColorValue::~TimeColorValue()
{
}

Value TimeColorValue::value(double t) const
{
    return Color(float(m_red->valueAt(t)), float(m_green->valueAt(t)), float(m_blue->valueAt(t)), float(m_alpha->valueAt(t)));
}
