///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __COLUMN_CHANNEL_MAPPING_EDITOR_H
#define __COLUMN_CHANNEL_MAPPING_EDITOR_H

#include <core/Core.h>
#include <atomviz/AtomViz.h>
#include "ColumnChannelMapping.h"

namespace AtomViz {

/**
 * \brief A widget that lets the user edit a ColumnChannelMapping.
 *
 * This widget class can be placed into a dialog box.
 *
 * \sa ColumnChannelMapping
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT ColumnChannelMappingEditor : public QWidget
{
public:

	/// \brief Initializes the widget.
	ColumnChannelMappingEditor(QWidget* parent = 0);

	/// \brief Fills the editor with the given mapping.
	void setMapping(const ColumnChannelMapping& mapping);

	/// \brief Returns the current contents of the editor.
	/// \throws Exception if the current mapping in the editor is not valid.
	ColumnChannelMapping mapping() const;

protected:

	/// \brief Returns the string representation of a data channel type.
	static QString dataChannelTypeToString(int type);

protected Q_SLOTS:

	/// Updates the entries in the "Presets" menu.
	void updatePresetMenu();

	/// Loads a preset.
	void onLoadPreset();

	/// Saves a preset under a new name.
	void onSavePresetAs();

	/// Saves a preset under an existing name.
	void onSavePreset();

	/// Deletes a preset.
	void onDeletePreset();

	/// Creates the default mapping if column names are available.
	void onAutoAssignColumns();

private:

	/// The main table widget that entries for each data column of the input file.
	QTableWidget* tableWidget;

	/// This menu is shown when the "Presets" menu button is pressed.
	QMenu presetMenu;

	QPushButton* autoAssignButton;

	Q_OBJECT
};

};	// End of namespace AtomViz

#endif // __COLUMN_CHANNEL_MAPPING_EDITOR_H
