###############################################################################
# 
#  Copyright (2008) Alexander Stukowski
#
#  This file is part of OVITO (Open Visualization Tool).
#
#  OVITO is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  OVITO is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
###############################################################################

# Finds the Computational Geometry Algorithms Library (CGAL).

# This module defines
#  CGAL_INCLUDE_DIR, where to find CGAL/*.h.
#  CGAL_LIBRARIES, libraries to link against to use CGAL.
#  CGAL_FOUND, If false, do not try to use CGAL.
#
#  Also defined, but not for general use are
#  CGAL_LIBRARY, where to find the CGAL library.

FIND_PATH(CGAL_INCLUDE_DIR CGAL/Segment_tree_k.h
  /usr/local/include
  /usr/include
)

SET(CGAL_NAMES ${CGAL_NAMES} CGAL)
FIND_LIBRARY(CGAL_LIBRARY
  NAMES ${CGAL_NAMES}
  PATHS /usr/lib /usr/local/lib
)

IF(CGAL_INCLUDE_DIR)
  IF(CGAL_LIBRARY)
    SET(CGAL_FOUND "YES")
    SET(CGAL_LIBRARIES ${CGAL_LIBRARY})
  ENDIF(CGAL_LIBRARY)
ENDIF(CGAL_INCLUDE_DIR)
