# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MonitoringSummary(Model):
    """Summary of the replication monitoring data for this vault.

    :param un_healthy_vm_count: Count of unhealthy VMs.
    :type un_healthy_vm_count: int
    :param un_healthy_provider_count: Count of unhealthy replication
     providers.
    :type un_healthy_provider_count: int
    :param events_count: Count of all critical warnings.
    :type events_count: int
    :param deprecated_provider_count: Count of all deprecated recovery service
     providers.
    :type deprecated_provider_count: int
    :param supported_provider_count: Count of all the supported recovery
     service providers.
    :type supported_provider_count: int
    :param unsupported_provider_count: Count of all the unsupported recovery
     service providers.
    :type unsupported_provider_count: int
    """

    _attribute_map = {
        'un_healthy_vm_count': {'key': 'unHealthyVmCount', 'type': 'int'},
        'un_healthy_provider_count': {'key': 'unHealthyProviderCount', 'type': 'int'},
        'events_count': {'key': 'eventsCount', 'type': 'int'},
        'deprecated_provider_count': {'key': 'deprecatedProviderCount', 'type': 'int'},
        'supported_provider_count': {'key': 'supportedProviderCount', 'type': 'int'},
        'unsupported_provider_count': {'key': 'unsupportedProviderCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(MonitoringSummary, self).__init__(**kwargs)
        self.un_healthy_vm_count = kwargs.get('un_healthy_vm_count', None)
        self.un_healthy_provider_count = kwargs.get('un_healthy_provider_count', None)
        self.events_count = kwargs.get('events_count', None)
        self.deprecated_provider_count = kwargs.get('deprecated_provider_count', None)
        self.supported_provider_count = kwargs.get('supported_provider_count', None)
        self.unsupported_provider_count = kwargs.get('unsupported_provider_count', None)
