# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import CostManagementClientConfiguration
from .operations import SettingsOperations
from .operations import ViewsOperations
from .operations import AlertsOperations
from .operations import ForecastOperations
from .operations import DimensionsOperations
from .operations import QueryOperations
from .operations import GenerateReservationDetailsReportOperations
from .operations import Operations
from .operations import ExportsOperations
from . import models


class CostManagementClient(object):
    """CostManagementClient.

    :ivar settings: SettingsOperations operations
    :vartype settings: azure.mgmt.costmanagement.operations.SettingsOperations
    :ivar views: ViewsOperations operations
    :vartype views: azure.mgmt.costmanagement.operations.ViewsOperations
    :ivar alerts: AlertsOperations operations
    :vartype alerts: azure.mgmt.costmanagement.operations.AlertsOperations
    :ivar forecast: ForecastOperations operations
    :vartype forecast: azure.mgmt.costmanagement.operations.ForecastOperations
    :ivar dimensions: DimensionsOperations operations
    :vartype dimensions: azure.mgmt.costmanagement.operations.DimensionsOperations
    :ivar query: QueryOperations operations
    :vartype query: azure.mgmt.costmanagement.operations.QueryOperations
    :ivar generate_reservation_details_report: GenerateReservationDetailsReportOperations operations
    :vartype generate_reservation_details_report: azure.mgmt.costmanagement.operations.GenerateReservationDetailsReportOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.costmanagement.operations.Operations
    :ivar exports: ExportsOperations operations
    :vartype exports: azure.mgmt.costmanagement.operations.ExportsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = CostManagementClientConfiguration(credential, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.settings = SettingsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.views = ViewsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.alerts = AlertsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.forecast = ForecastOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.dimensions = DimensionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.query = QueryOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.generate_reservation_details_report = GenerateReservationDetailsReportOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.exports = ExportsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        http_request.url = self._client.format_url(http_request.url)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> CostManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
