# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddDataLakeStoreParameters(_serialization.Model):
    """The parameters used to add a new Data Lake Store account.

    :ivar suffix: The optional suffix for the Data Lake Store account.
    :vartype suffix: str
    """

    _attribute_map = {
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, suffix: Optional[str] = None, **kwargs):
        """
        :keyword suffix: The optional suffix for the Data Lake Store account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.suffix = suffix


class AddDataLakeStoreWithAccountParameters(_serialization.Model):
    """The parameters used to add a new Data Lake Store account while creating a new Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the Data Lake Store account to add. Required.
    :vartype name: str
    :ivar suffix: The optional suffix for the Data Lake Store account.
    :vartype suffix: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, name: str, suffix: Optional[str] = None, **kwargs):
        """
        :keyword name: The unique name of the Data Lake Store account to add. Required.
        :paramtype name: str
        :keyword suffix: The optional suffix for the Data Lake Store account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.suffix = suffix


class AddStorageAccountParameters(_serialization.Model):
    """The parameters used to add a new Azure Storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar access_key: The access key associated with this Azure Storage account that will be used
     to connect to it. Required.
    :vartype access_key: str
    :ivar suffix: The optional suffix for the storage account.
    :vartype suffix: str
    """

    _validation = {
        "access_key": {"required": True},
    }

    _attribute_map = {
        "access_key": {"key": "properties.accessKey", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, access_key: str, suffix: str = "azuredatalakestore.net", **kwargs):
        """
        :keyword access_key: The access key associated with this Azure Storage account that will be
         used to connect to it. Required.
        :paramtype access_key: str
        :keyword suffix: The optional suffix for the storage account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.access_key = access_key
        self.suffix = suffix


class AddStorageAccountWithAccountParameters(_serialization.Model):
    """The parameters used to add a new Azure Storage account while creating a new Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the Azure Storage account to add. Required.
    :vartype name: str
    :ivar access_key: The access key associated with this Azure Storage account that will be used
     to connect to it. Required.
    :vartype access_key: str
    :ivar suffix: The optional suffix for the storage account.
    :vartype suffix: str
    """

    _validation = {
        "name": {"required": True},
        "access_key": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_key": {"key": "properties.accessKey", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, name: str, access_key: str, suffix: str = "azuredatalakestore.net", **kwargs):
        """
        :keyword name: The unique name of the Azure Storage account to add. Required.
        :paramtype name: str
        :keyword access_key: The access key associated with this Azure Storage account that will be
         used to connect to it. Required.
        :paramtype access_key: str
        :keyword suffix: The optional suffix for the storage account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_key = access_key
        self.suffix = suffix


class CapabilityInformation(_serialization.Model):
    """Subscription-level properties and limits for Data Lake Analytics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: The subscription credentials that uniquely identifies the subscription.
    :vartype subscription_id: str
    :ivar state: The subscription state. Known values are: "Registered", "Suspended", "Deleted",
     "Unregistered", and "Warned".
    :vartype state: str or ~azure.mgmt.datalake.analytics.account.models.SubscriptionState
    :ivar max_account_count: The maximum supported number of accounts under this subscription.
    :vartype max_account_count: int
    :ivar account_count: The current number of accounts under this subscription.
    :vartype account_count: int
    :ivar migration_state: The Boolean value of true or false to indicate the maintenance state.
    :vartype migration_state: bool
    """

    _validation = {
        "subscription_id": {"readonly": True},
        "state": {"readonly": True},
        "max_account_count": {"readonly": True},
        "account_count": {"readonly": True},
        "migration_state": {"readonly": True},
    }

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "max_account_count": {"key": "maxAccountCount", "type": "int"},
        "account_count": {"key": "accountCount", "type": "int"},
        "migration_state": {"key": "migrationState", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.subscription_id = None
        self.state = None
        self.max_account_count = None
        self.account_count = None
        self.migration_state = None


class CheckNameAvailabilityParameters(_serialization.Model):
    """Data Lake Analytics account name availability check parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The Data Lake Analytics name to check availability for. Required.
    :vartype name: str
    :ivar type: The resource type. Note: This should not be set by the user, as the constant value
     is Microsoft.DataLakeAnalytics/accounts. Required. "Microsoft.DataLakeAnalytics/accounts"
    :vartype type: str or
     ~azure.mgmt.datalake.analytics.account.models.CheckNameAvailabilityParametersType
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Union[str, "_models.CheckNameAvailabilityParametersType"], **kwargs):
        """
        :keyword name: The Data Lake Analytics name to check availability for. Required.
        :paramtype name: str
        :keyword type: The resource type. Note: This should not be set by the user, as the constant
         value is Microsoft.DataLakeAnalytics/accounts. Required. "Microsoft.DataLakeAnalytics/accounts"
        :paramtype type: str or
         ~azure.mgmt.datalake.analytics.account.models.CheckNameAvailabilityParametersType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class SubResource(_serialization.Model):
    """The resource model definition for a nested resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ComputePolicy(SubResource):
    """Data Lake Analytics compute policy information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar object_id: The AAD object identifier for the entity to create a policy for.
    :vartype object_id: str
    :ivar object_type: The type of AAD object the object identifier refers to. Known values are:
     "User", "Group", and "ServicePrincipal".
    :vartype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
    :ivar max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
     can use to submit jobs.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum priority per job this user can use to submit jobs.
    :vartype min_priority_per_job: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "object_id": {"readonly": True},
        "object_type": {"readonly": True},
        "max_degree_of_parallelism_per_job": {"readonly": True, "minimum": 1},
        "min_priority_per_job": {"readonly": True, "minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "object_id": {"key": "properties.objectId", "type": "str"},
        "object_type": {"key": "properties.objectType", "type": "str"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.object_id = None
        self.object_type = None
        self.max_degree_of_parallelism_per_job = None
        self.min_priority_per_job = None


class ComputePolicyListResult(_serialization.Model):
    """The list of compute policies in the account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.ComputePolicy]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ComputePolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CreateComputePolicyWithAccountParameters(_serialization.Model):
    """The parameters used to create a new compute policy while creating a new Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the compute policy to create. Required.
    :vartype name: str
    :ivar object_id: The AAD object identifier for the entity to create a policy for. Required.
    :vartype object_id: str
    :ivar object_type: The type of AAD object the object identifier refers to. Required. Known
     values are: "User", "Group", and "ServicePrincipal".
    :vartype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
    :ivar max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
     can use to submit jobs. This property, the min priority per job property, or both must be
     passed.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum priority per job this user can use to submit jobs. This
     property, the max degree of parallelism per job property, or both must be passed.
    :vartype min_priority_per_job: int
    """

    _validation = {
        "name": {"required": True},
        "object_id": {"required": True},
        "object_type": {"required": True},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "object_id": {"key": "properties.objectId", "type": "str"},
        "object_type": {"key": "properties.objectType", "type": "str"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        object_id: str,
        object_type: Union[str, "_models.AADObjectType"],
        max_degree_of_parallelism_per_job: Optional[int] = None,
        min_priority_per_job: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The unique name of the compute policy to create. Required.
        :paramtype name: str
        :keyword object_id: The AAD object identifier for the entity to create a policy for. Required.
        :paramtype object_id: str
        :keyword object_type: The type of AAD object the object identifier refers to. Required. Known
         values are: "User", "Group", and "ServicePrincipal".
        :paramtype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
        :keyword max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
         can use to submit jobs. This property, the min priority per job property, or both must be
         passed.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword min_priority_per_job: The minimum priority per job this user can use to submit jobs.
         This property, the max degree of parallelism per job property, or both must be passed.
        :paramtype min_priority_per_job: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.object_id = object_id
        self.object_type = object_type
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job


class CreateDataLakeAnalyticsAccountParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters to use for creating a Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar default_data_lake_store_account: The default Data Lake Store account associated with this
     account. Required.
    :vartype default_data_lake_store_account: str
    :ivar data_lake_store_accounts: The list of Data Lake Store accounts associated with this
     account. Required.
    :vartype data_lake_store_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.AddDataLakeStoreWithAccountParameters]
    :ivar storage_accounts: The list of Azure Blob Storage accounts associated with this account.
    :vartype storage_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.AddStorageAccountWithAccountParameters]
    :ivar compute_policies: The list of compute policies associated with this account.
    :vartype compute_policies:
     list[~azure.mgmt.datalake.analytics.account.models.CreateComputePolicyWithAccountParameters]
    :ivar firewall_rules: The list of firewall rules associated with this account.
    :vartype firewall_rules:
     list[~azure.mgmt.datalake.analytics.account.models.CreateFirewallRuleWithAccountParameters]
    :ivar firewall_state: The current state of the IP address firewall for this account. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
    :ivar firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
    :ivar new_tier: The commitment tier for the next month. Known values are: "Consumption",
     "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
     "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
     "Commitment_100000AUHours", and "Commitment_500000AUHours".
    :vartype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
    :ivar max_job_count: The maximum supported jobs running under the account at the same time.
    :vartype max_job_count: int
    :ivar max_degree_of_parallelism: The maximum supported degree of parallelism for this account.
    :vartype max_degree_of_parallelism: int
    :ivar max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
     for this account.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum supported priority per job for this account.
    :vartype min_priority_per_job: int
    :ivar query_store_retention: The number of days that job metadata is retained.
    :vartype query_store_retention: int
    """

    _validation = {
        "location": {"required": True},
        "default_data_lake_store_account": {"required": True},
        "data_lake_store_accounts": {"required": True},
        "max_job_count": {"minimum": 1},
        "max_degree_of_parallelism": {"minimum": 1},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"minimum": 1},
        "query_store_retention": {"maximum": 180, "minimum": 1},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "default_data_lake_store_account": {"key": "properties.defaultDataLakeStoreAccount", "type": "str"},
        "data_lake_store_accounts": {
            "key": "properties.dataLakeStoreAccounts",
            "type": "[AddDataLakeStoreWithAccountParameters]",
        },
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[AddStorageAccountWithAccountParameters]"},
        "compute_policies": {"key": "properties.computePolicies", "type": "[CreateComputePolicyWithAccountParameters]"},
        "firewall_rules": {"key": "properties.firewallRules", "type": "[CreateFirewallRuleWithAccountParameters]"},
        "firewall_state": {"key": "properties.firewallState", "type": "str"},
        "firewall_allow_azure_ips": {"key": "properties.firewallAllowAzureIps", "type": "str"},
        "new_tier": {"key": "properties.newTier", "type": "str"},
        "max_job_count": {"key": "properties.maxJobCount", "type": "int"},
        "max_degree_of_parallelism": {"key": "properties.maxDegreeOfParallelism", "type": "int"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
        "query_store_retention": {"key": "properties.queryStoreRetention", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        default_data_lake_store_account: str,
        data_lake_store_accounts: List["_models.AddDataLakeStoreWithAccountParameters"],
        tags: Optional[Dict[str, str]] = None,
        storage_accounts: Optional[List["_models.AddStorageAccountWithAccountParameters"]] = None,
        compute_policies: Optional[List["_models.CreateComputePolicyWithAccountParameters"]] = None,
        firewall_rules: Optional[List["_models.CreateFirewallRuleWithAccountParameters"]] = None,
        firewall_state: Optional[Union[str, "_models.FirewallState"]] = None,
        firewall_allow_azure_ips: Optional[Union[str, "_models.FirewallAllowAzureIpsState"]] = None,
        new_tier: Optional[Union[str, "_models.TierType"]] = None,
        max_job_count: int = 3,
        max_degree_of_parallelism: int = 30,
        max_degree_of_parallelism_per_job: int = 32,
        min_priority_per_job: Optional[int] = None,
        query_store_retention: int = 30,
        **kwargs
    ):
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword default_data_lake_store_account: The default Data Lake Store account associated with
         this account. Required.
        :paramtype default_data_lake_store_account: str
        :keyword data_lake_store_accounts: The list of Data Lake Store accounts associated with this
         account. Required.
        :paramtype data_lake_store_accounts:
         list[~azure.mgmt.datalake.analytics.account.models.AddDataLakeStoreWithAccountParameters]
        :keyword storage_accounts: The list of Azure Blob Storage accounts associated with this
         account.
        :paramtype storage_accounts:
         list[~azure.mgmt.datalake.analytics.account.models.AddStorageAccountWithAccountParameters]
        :keyword compute_policies: The list of compute policies associated with this account.
        :paramtype compute_policies:
         list[~azure.mgmt.datalake.analytics.account.models.CreateComputePolicyWithAccountParameters]
        :keyword firewall_rules: The list of firewall rules associated with this account.
        :paramtype firewall_rules:
         list[~azure.mgmt.datalake.analytics.account.models.CreateFirewallRuleWithAccountParameters]
        :keyword firewall_state: The current state of the IP address firewall for this account. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
        :keyword firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
         within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_allow_azure_ips: str or
         ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
        :keyword new_tier: The commitment tier for the next month. Known values are: "Consumption",
         "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
         "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
         "Commitment_100000AUHours", and "Commitment_500000AUHours".
        :paramtype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
        :keyword max_job_count: The maximum supported jobs running under the account at the same time.
        :paramtype max_job_count: int
        :keyword max_degree_of_parallelism: The maximum supported degree of parallelism for this
         account.
        :paramtype max_degree_of_parallelism: int
        :keyword max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
         for this account.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword min_priority_per_job: The minimum supported priority per job for this account.
        :paramtype min_priority_per_job: int
        :keyword query_store_retention: The number of days that job metadata is retained.
        :paramtype query_store_retention: int
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.default_data_lake_store_account = default_data_lake_store_account
        self.data_lake_store_accounts = data_lake_store_accounts
        self.storage_accounts = storage_accounts
        self.compute_policies = compute_policies
        self.firewall_rules = firewall_rules
        self.firewall_state = firewall_state
        self.firewall_allow_azure_ips = firewall_allow_azure_ips
        self.new_tier = new_tier
        self.max_job_count = max_job_count
        self.max_degree_of_parallelism = max_degree_of_parallelism
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job
        self.query_store_retention = query_store_retention


class CreateFirewallRuleWithAccountParameters(_serialization.Model):
    """The parameters used to create a new firewall rule while creating a new Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the firewall rule to create. Required.
    :vartype name: str
    :ivar start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol. Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol. Required.
    :vartype end_ip_address: str
    """

    _validation = {
        "name": {"required": True},
        "start_ip_address": {"required": True},
        "end_ip_address": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(self, *, name: str, start_ip_address: str, end_ip_address: str, **kwargs):
        """
        :keyword name: The unique name of the firewall rule to create. Required.
        :paramtype name: str
        :keyword start_ip_address: The start IP address for the firewall rule. This can be either ipv4
         or ipv6. Start and End should be in the same protocol. Required.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
         ipv6. Start and End should be in the same protocol. Required.
        :paramtype end_ip_address: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class CreateOrUpdateComputePolicyParameters(_serialization.Model):
    """The parameters used to create a new compute policy.

    All required parameters must be populated in order to send to Azure.

    :ivar object_id: The AAD object identifier for the entity to create a policy for. Required.
    :vartype object_id: str
    :ivar object_type: The type of AAD object the object identifier refers to. Required. Known
     values are: "User", "Group", and "ServicePrincipal".
    :vartype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
    :ivar max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
     can use to submit jobs. This property, the min priority per job property, or both must be
     passed.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum priority per job this user can use to submit jobs. This
     property, the max degree of parallelism per job property, or both must be passed.
    :vartype min_priority_per_job: int
    """

    _validation = {
        "object_id": {"required": True},
        "object_type": {"required": True},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"minimum": 1},
    }

    _attribute_map = {
        "object_id": {"key": "properties.objectId", "type": "str"},
        "object_type": {"key": "properties.objectType", "type": "str"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
    }

    def __init__(
        self,
        *,
        object_id: str,
        object_type: Union[str, "_models.AADObjectType"],
        max_degree_of_parallelism_per_job: Optional[int] = None,
        min_priority_per_job: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword object_id: The AAD object identifier for the entity to create a policy for. Required.
        :paramtype object_id: str
        :keyword object_type: The type of AAD object the object identifier refers to. Required. Known
         values are: "User", "Group", and "ServicePrincipal".
        :paramtype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
        :keyword max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
         can use to submit jobs. This property, the min priority per job property, or both must be
         passed.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword min_priority_per_job: The minimum priority per job this user can use to submit jobs.
         This property, the max degree of parallelism per job property, or both must be passed.
        :paramtype min_priority_per_job: int
        """
        super().__init__(**kwargs)
        self.object_id = object_id
        self.object_type = object_type
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job


class CreateOrUpdateFirewallRuleParameters(_serialization.Model):
    """The parameters used to create a new firewall rule.

    All required parameters must be populated in order to send to Azure.

    :ivar start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol. Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol. Required.
    :vartype end_ip_address: str
    """

    _validation = {
        "start_ip_address": {"required": True},
        "end_ip_address": {"required": True},
    }

    _attribute_map = {
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(self, *, start_ip_address: str, end_ip_address: str, **kwargs):
        """
        :keyword start_ip_address: The start IP address for the firewall rule. This can be either ipv4
         or ipv6. Start and End should be in the same protocol. Required.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
         ipv6. Start and End should be in the same protocol. Required.
        :paramtype end_ip_address: str
        """
        super().__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class Resource(_serialization.Model):
    """The resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class DataLakeAnalyticsAccount(Resource):  # pylint: disable=too-many-instance-attributes
    """A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar account_id: The unique identifier associated with this Data Lake Analytics account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Analytics account. Known
     values are: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending", "Resuming",
     "Deleting", "Deleted", "Undeleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountStatus
    :ivar state: The state of the Data Lake Analytics account. Known values are: "Active" and
     "Suspended".
    :vartype state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    :ivar default_data_lake_store_account_type: The type of the default Data Lake Store account
     associated with this account.
    :vartype default_data_lake_store_account_type: str
    :ivar default_data_lake_store_account: The default Data Lake Store account associated with this
     account.
    :vartype default_data_lake_store_account: str
    :ivar data_lake_store_accounts: The list of Data Lake Store accounts associated with this
     account.
    :vartype data_lake_store_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
    :ivar public_data_lake_store_accounts: The list of Data Lake Store accounts associated with
     this account.
    :vartype public_data_lake_store_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
    :ivar storage_accounts: The list of Azure Blob Storage accounts associated with this account.
    :vartype storage_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.StorageAccountInformation]
    :ivar compute_policies: The list of compute policies associated with this account.
    :vartype compute_policies: list[~azure.mgmt.datalake.analytics.account.models.ComputePolicy]
    :ivar hive_metastores: The list of hiveMetastores associated with this account.
    :vartype hive_metastores: list[~azure.mgmt.datalake.analytics.account.models.HiveMetastore]
    :ivar virtual_network_rules: The list of virtualNetwork rules associated with this account.
    :vartype virtual_network_rules:
     list[~azure.mgmt.datalake.analytics.account.models.VirtualNetworkRule]
    :ivar firewall_rules: The list of firewall rules associated with this account.
    :vartype firewall_rules: list[~azure.mgmt.datalake.analytics.account.models.FirewallRule]
    :ivar firewall_state: The current state of the IP address firewall for this account. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
    :ivar firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
    :ivar new_tier: The commitment tier for the next month. Known values are: "Consumption",
     "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
     "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
     "Commitment_100000AUHours", and "Commitment_500000AUHours".
    :vartype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
    :ivar current_tier: The commitment tier in use for the current month. Known values are:
     "Consumption", "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
     "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
     "Commitment_100000AUHours", and "Commitment_500000AUHours".
    :vartype current_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
    :ivar max_job_count: The maximum supported jobs running under the account at the same time.
    :vartype max_job_count: int
    :ivar max_active_job_count_per_user: The maximum supported active jobs under the account at the
     same time.
    :vartype max_active_job_count_per_user: int
    :ivar max_queued_job_count_per_user: The maximum supported jobs queued under the account at the
     same time.
    :vartype max_queued_job_count_per_user: int
    :ivar max_job_running_time_in_min: The maximum supported active jobs under the account at the
     same time.
    :vartype max_job_running_time_in_min: int
    :ivar system_max_job_count: The system defined maximum supported jobs running under the account
     at the same time, which restricts the maximum number of running jobs the user can set for the
     account.
    :vartype system_max_job_count: int
    :ivar max_degree_of_parallelism: The maximum supported degree of parallelism for this account.
    :vartype max_degree_of_parallelism: int
    :ivar system_max_degree_of_parallelism: The system defined maximum supported degree of
     parallelism for this account, which restricts the maximum value of parallelism the user can set
     for the account.
    :vartype system_max_degree_of_parallelism: int
    :ivar max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
     for this account.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum supported priority per job for this account.
    :vartype min_priority_per_job: int
    :ivar query_store_retention: The number of days that job metadata is retained.
    :vartype query_store_retention: int
    :ivar debug_data_access_level: The current state of the DebugDataAccessLevel for this account.
     Known values are: "All", "Customer", and "None".
    :vartype debug_data_access_level: str or
     ~azure.mgmt.datalake.analytics.account.models.DebugDataAccessLevel
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
        "account_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "state": {"readonly": True},
        "creation_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "endpoint": {"readonly": True},
        "default_data_lake_store_account_type": {"readonly": True},
        "default_data_lake_store_account": {"readonly": True},
        "data_lake_store_accounts": {"readonly": True},
        "storage_accounts": {"readonly": True},
        "compute_policies": {"readonly": True},
        "hive_metastores": {"readonly": True},
        "virtual_network_rules": {"readonly": True},
        "firewall_rules": {"readonly": True},
        "current_tier": {"readonly": True},
        "max_job_count": {"minimum": 1},
        "max_active_job_count_per_user": {"readonly": True},
        "max_queued_job_count_per_user": {"readonly": True},
        "max_job_running_time_in_min": {"readonly": True},
        "system_max_job_count": {"readonly": True},
        "max_degree_of_parallelism": {"minimum": 1},
        "system_max_degree_of_parallelism": {"readonly": True},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"readonly": True, "minimum": 1},
        "query_store_retention": {"maximum": 180, "minimum": 1},
        "debug_data_access_level": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "account_id": {"key": "properties.accountId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "default_data_lake_store_account_type": {"key": "properties.defaultDataLakeStoreAccountType", "type": "str"},
        "default_data_lake_store_account": {"key": "properties.defaultDataLakeStoreAccount", "type": "str"},
        "data_lake_store_accounts": {
            "key": "properties.dataLakeStoreAccounts",
            "type": "[DataLakeStoreAccountInformation]",
        },
        "public_data_lake_store_accounts": {
            "key": "properties.publicDataLakeStoreAccounts",
            "type": "[DataLakeStoreAccountInformation]",
        },
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccountInformation]"},
        "compute_policies": {"key": "properties.computePolicies", "type": "[ComputePolicy]"},
        "hive_metastores": {"key": "properties.hiveMetastores", "type": "[HiveMetastore]"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "firewall_rules": {"key": "properties.firewallRules", "type": "[FirewallRule]"},
        "firewall_state": {"key": "properties.firewallState", "type": "str"},
        "firewall_allow_azure_ips": {"key": "properties.firewallAllowAzureIps", "type": "str"},
        "new_tier": {"key": "properties.newTier", "type": "str"},
        "current_tier": {"key": "properties.currentTier", "type": "str"},
        "max_job_count": {"key": "properties.maxJobCount", "type": "int"},
        "max_active_job_count_per_user": {"key": "properties.maxActiveJobCountPerUser", "type": "int"},
        "max_queued_job_count_per_user": {"key": "properties.maxQueuedJobCountPerUser", "type": "int"},
        "max_job_running_time_in_min": {"key": "properties.maxJobRunningTimeInMin", "type": "int"},
        "system_max_job_count": {"key": "properties.systemMaxJobCount", "type": "int"},
        "max_degree_of_parallelism": {"key": "properties.maxDegreeOfParallelism", "type": "int"},
        "system_max_degree_of_parallelism": {"key": "properties.systemMaxDegreeOfParallelism", "type": "int"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
        "query_store_retention": {"key": "properties.queryStoreRetention", "type": "int"},
        "debug_data_access_level": {"key": "properties.debugDataAccessLevel", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        public_data_lake_store_accounts: Optional[List["_models.DataLakeStoreAccountInformation"]] = None,
        firewall_state: Optional[Union[str, "_models.FirewallState"]] = None,
        firewall_allow_azure_ips: Optional[Union[str, "_models.FirewallAllowAzureIpsState"]] = None,
        new_tier: Optional[Union[str, "_models.TierType"]] = None,
        max_job_count: int = 3,
        max_degree_of_parallelism: int = 30,
        max_degree_of_parallelism_per_job: Optional[int] = None,
        query_store_retention: int = 30,
        **kwargs
    ):
        """
        :keyword public_data_lake_store_accounts: The list of Data Lake Store accounts associated with
         this account.
        :paramtype public_data_lake_store_accounts:
         list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
        :keyword firewall_state: The current state of the IP address firewall for this account. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
        :keyword firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
         within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_allow_azure_ips: str or
         ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
        :keyword new_tier: The commitment tier for the next month. Known values are: "Consumption",
         "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
         "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
         "Commitment_100000AUHours", and "Commitment_500000AUHours".
        :paramtype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
        :keyword max_job_count: The maximum supported jobs running under the account at the same time.
        :paramtype max_job_count: int
        :keyword max_degree_of_parallelism: The maximum supported degree of parallelism for this
         account.
        :paramtype max_degree_of_parallelism: int
        :keyword max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
         for this account.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword query_store_retention: The number of days that job metadata is retained.
        :paramtype query_store_retention: int
        """
        super().__init__(**kwargs)
        self.account_id = None
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.endpoint = None
        self.default_data_lake_store_account_type = None
        self.default_data_lake_store_account = None
        self.data_lake_store_accounts = None
        self.public_data_lake_store_accounts = public_data_lake_store_accounts
        self.storage_accounts = None
        self.compute_policies = None
        self.hive_metastores = None
        self.virtual_network_rules = None
        self.firewall_rules = None
        self.firewall_state = firewall_state
        self.firewall_allow_azure_ips = firewall_allow_azure_ips
        self.new_tier = new_tier
        self.current_tier = None
        self.max_job_count = max_job_count
        self.max_active_job_count_per_user = None
        self.max_queued_job_count_per_user = None
        self.max_job_running_time_in_min = None
        self.system_max_job_count = None
        self.max_degree_of_parallelism = max_degree_of_parallelism
        self.system_max_degree_of_parallelism = None
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = None
        self.query_store_retention = query_store_retention
        self.debug_data_access_level = None


class DataLakeAnalyticsAccountBasic(Resource):  # pylint: disable=too-many-instance-attributes
    """A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar account_id: The unique identifier associated with this Data Lake Analytics account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Analytics account. Known
     values are: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending", "Resuming",
     "Deleting", "Deleted", "Undeleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountStatus
    :ivar state: The state of the Data Lake Analytics account. Known values are: "Active" and
     "Suspended".
    :vartype state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
        "account_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "state": {"readonly": True},
        "creation_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "account_id": {"key": "properties.accountId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.account_id = None
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.endpoint = None


class DataLakeAnalyticsAccountListResult(_serialization.Model):
    """Data Lake Analytics account list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value:
     list[~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountBasic]
    :ivar count: The current number of data lake analytics accounts under this subscription.
    :vartype count: int
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "count": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataLakeAnalyticsAccountBasic]"},
        "count": {"key": "count", "type": "int"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.count = None
        self.next_link = None


class DataLakeAnalyticsAccountPropertiesBasic(_serialization.Model):
    """The basic account specific properties that are associated with an underlying Data Lake Analytics account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: The unique identifier associated with this Data Lake Analytics account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Analytics account. Known
     values are: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending", "Resuming",
     "Deleting", "Deleted", "Undeleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountStatus
    :ivar state: The state of the Data Lake Analytics account. Known values are: "Active" and
     "Suspended".
    :vartype state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    """

    _validation = {
        "account_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "state": {"readonly": True},
        "creation_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "account_id": {"key": "accountId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.account_id = None
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.endpoint = None


class DataLakeAnalyticsAccountProperties(
    DataLakeAnalyticsAccountPropertiesBasic
):  # pylint: disable=too-many-instance-attributes
    """The account specific properties that are associated with an underlying Data Lake Analytics account. Returned only when retrieving a specific account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: The unique identifier associated with this Data Lake Analytics account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Analytics account. Known
     values are: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending", "Resuming",
     "Deleting", "Deleted", "Undeleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountStatus
    :ivar state: The state of the Data Lake Analytics account. Known values are: "Active" and
     "Suspended".
    :vartype state: str or
     ~azure.mgmt.datalake.analytics.account.models.DataLakeAnalyticsAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    :ivar default_data_lake_store_account_type: The type of the default Data Lake Store account
     associated with this account.
    :vartype default_data_lake_store_account_type: str
    :ivar default_data_lake_store_account: The default Data Lake Store account associated with this
     account.
    :vartype default_data_lake_store_account: str
    :ivar data_lake_store_accounts: The list of Data Lake Store accounts associated with this
     account.
    :vartype data_lake_store_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
    :ivar public_data_lake_store_accounts: The list of Data Lake Store accounts associated with
     this account.
    :vartype public_data_lake_store_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
    :ivar storage_accounts: The list of Azure Blob Storage accounts associated with this account.
    :vartype storage_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.StorageAccountInformation]
    :ivar compute_policies: The list of compute policies associated with this account.
    :vartype compute_policies: list[~azure.mgmt.datalake.analytics.account.models.ComputePolicy]
    :ivar hive_metastores: The list of hiveMetastores associated with this account.
    :vartype hive_metastores: list[~azure.mgmt.datalake.analytics.account.models.HiveMetastore]
    :ivar virtual_network_rules: The list of virtualNetwork rules associated with this account.
    :vartype virtual_network_rules:
     list[~azure.mgmt.datalake.analytics.account.models.VirtualNetworkRule]
    :ivar firewall_rules: The list of firewall rules associated with this account.
    :vartype firewall_rules: list[~azure.mgmt.datalake.analytics.account.models.FirewallRule]
    :ivar firewall_state: The current state of the IP address firewall for this account. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
    :ivar firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
    :ivar new_tier: The commitment tier for the next month. Known values are: "Consumption",
     "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
     "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
     "Commitment_100000AUHours", and "Commitment_500000AUHours".
    :vartype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
    :ivar current_tier: The commitment tier in use for the current month. Known values are:
     "Consumption", "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
     "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
     "Commitment_100000AUHours", and "Commitment_500000AUHours".
    :vartype current_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
    :ivar max_job_count: The maximum supported jobs running under the account at the same time.
    :vartype max_job_count: int
    :ivar max_active_job_count_per_user: The maximum supported active jobs under the account at the
     same time.
    :vartype max_active_job_count_per_user: int
    :ivar max_queued_job_count_per_user: The maximum supported jobs queued under the account at the
     same time.
    :vartype max_queued_job_count_per_user: int
    :ivar max_job_running_time_in_min: The maximum supported active jobs under the account at the
     same time.
    :vartype max_job_running_time_in_min: int
    :ivar system_max_job_count: The system defined maximum supported jobs running under the account
     at the same time, which restricts the maximum number of running jobs the user can set for the
     account.
    :vartype system_max_job_count: int
    :ivar max_degree_of_parallelism: The maximum supported degree of parallelism for this account.
    :vartype max_degree_of_parallelism: int
    :ivar system_max_degree_of_parallelism: The system defined maximum supported degree of
     parallelism for this account, which restricts the maximum value of parallelism the user can set
     for the account.
    :vartype system_max_degree_of_parallelism: int
    :ivar max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
     for this account.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum supported priority per job for this account.
    :vartype min_priority_per_job: int
    :ivar query_store_retention: The number of days that job metadata is retained.
    :vartype query_store_retention: int
    :ivar debug_data_access_level: The current state of the DebugDataAccessLevel for this account.
     Known values are: "All", "Customer", and "None".
    :vartype debug_data_access_level: str or
     ~azure.mgmt.datalake.analytics.account.models.DebugDataAccessLevel
    """

    _validation = {
        "account_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "state": {"readonly": True},
        "creation_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "endpoint": {"readonly": True},
        "default_data_lake_store_account_type": {"readonly": True},
        "default_data_lake_store_account": {"readonly": True},
        "data_lake_store_accounts": {"readonly": True},
        "storage_accounts": {"readonly": True},
        "compute_policies": {"readonly": True},
        "hive_metastores": {"readonly": True},
        "virtual_network_rules": {"readonly": True},
        "firewall_rules": {"readonly": True},
        "current_tier": {"readonly": True},
        "max_job_count": {"minimum": 1},
        "max_active_job_count_per_user": {"readonly": True},
        "max_queued_job_count_per_user": {"readonly": True},
        "max_job_running_time_in_min": {"readonly": True},
        "system_max_job_count": {"readonly": True},
        "max_degree_of_parallelism": {"minimum": 1},
        "system_max_degree_of_parallelism": {"readonly": True},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"readonly": True, "minimum": 1},
        "query_store_retention": {"maximum": 180, "minimum": 1},
        "debug_data_access_level": {"readonly": True},
    }

    _attribute_map = {
        "account_id": {"key": "accountId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "default_data_lake_store_account_type": {"key": "defaultDataLakeStoreAccountType", "type": "str"},
        "default_data_lake_store_account": {"key": "defaultDataLakeStoreAccount", "type": "str"},
        "data_lake_store_accounts": {"key": "dataLakeStoreAccounts", "type": "[DataLakeStoreAccountInformation]"},
        "public_data_lake_store_accounts": {
            "key": "publicDataLakeStoreAccounts",
            "type": "[DataLakeStoreAccountInformation]",
        },
        "storage_accounts": {"key": "storageAccounts", "type": "[StorageAccountInformation]"},
        "compute_policies": {"key": "computePolicies", "type": "[ComputePolicy]"},
        "hive_metastores": {"key": "hiveMetastores", "type": "[HiveMetastore]"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "firewall_rules": {"key": "firewallRules", "type": "[FirewallRule]"},
        "firewall_state": {"key": "firewallState", "type": "str"},
        "firewall_allow_azure_ips": {"key": "firewallAllowAzureIps", "type": "str"},
        "new_tier": {"key": "newTier", "type": "str"},
        "current_tier": {"key": "currentTier", "type": "str"},
        "max_job_count": {"key": "maxJobCount", "type": "int"},
        "max_active_job_count_per_user": {"key": "maxActiveJobCountPerUser", "type": "int"},
        "max_queued_job_count_per_user": {"key": "maxQueuedJobCountPerUser", "type": "int"},
        "max_job_running_time_in_min": {"key": "maxJobRunningTimeInMin", "type": "int"},
        "system_max_job_count": {"key": "systemMaxJobCount", "type": "int"},
        "max_degree_of_parallelism": {"key": "maxDegreeOfParallelism", "type": "int"},
        "system_max_degree_of_parallelism": {"key": "systemMaxDegreeOfParallelism", "type": "int"},
        "max_degree_of_parallelism_per_job": {"key": "maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "minPriorityPerJob", "type": "int"},
        "query_store_retention": {"key": "queryStoreRetention", "type": "int"},
        "debug_data_access_level": {"key": "debugDataAccessLevel", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        public_data_lake_store_accounts: Optional[List["_models.DataLakeStoreAccountInformation"]] = None,
        firewall_state: Optional[Union[str, "_models.FirewallState"]] = None,
        firewall_allow_azure_ips: Optional[Union[str, "_models.FirewallAllowAzureIpsState"]] = None,
        new_tier: Optional[Union[str, "_models.TierType"]] = None,
        max_job_count: int = 3,
        max_degree_of_parallelism: int = 30,
        max_degree_of_parallelism_per_job: Optional[int] = None,
        query_store_retention: int = 30,
        **kwargs
    ):
        """
        :keyword public_data_lake_store_accounts: The list of Data Lake Store accounts associated with
         this account.
        :paramtype public_data_lake_store_accounts:
         list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
        :keyword firewall_state: The current state of the IP address firewall for this account. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
        :keyword firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
         within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_allow_azure_ips: str or
         ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
        :keyword new_tier: The commitment tier for the next month. Known values are: "Consumption",
         "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
         "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
         "Commitment_100000AUHours", and "Commitment_500000AUHours".
        :paramtype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
        :keyword max_job_count: The maximum supported jobs running under the account at the same time.
        :paramtype max_job_count: int
        :keyword max_degree_of_parallelism: The maximum supported degree of parallelism for this
         account.
        :paramtype max_degree_of_parallelism: int
        :keyword max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
         for this account.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword query_store_retention: The number of days that job metadata is retained.
        :paramtype query_store_retention: int
        """
        super().__init__(**kwargs)
        self.default_data_lake_store_account_type = None
        self.default_data_lake_store_account = None
        self.data_lake_store_accounts = None
        self.public_data_lake_store_accounts = public_data_lake_store_accounts
        self.storage_accounts = None
        self.compute_policies = None
        self.hive_metastores = None
        self.virtual_network_rules = None
        self.firewall_rules = None
        self.firewall_state = firewall_state
        self.firewall_allow_azure_ips = firewall_allow_azure_ips
        self.new_tier = new_tier
        self.current_tier = None
        self.max_job_count = max_job_count
        self.max_active_job_count_per_user = None
        self.max_queued_job_count_per_user = None
        self.max_job_running_time_in_min = None
        self.system_max_job_count = None
        self.max_degree_of_parallelism = max_degree_of_parallelism
        self.system_max_degree_of_parallelism = None
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = None
        self.query_store_retention = query_store_retention
        self.debug_data_access_level = None


class DataLakeStoreAccountInformation(SubResource):
    """Data Lake Store account information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar suffix: The optional suffix for the Data Lake Store account.
    :vartype suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "suffix": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.suffix = None


class DataLakeStoreAccountInformationListResult(_serialization.Model):
    """Data Lake Store account list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value:
     list[~azure.mgmt.datalake.analytics.account.models.DataLakeStoreAccountInformation]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataLakeStoreAccountInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.datalake.analytics.account.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.datalake.analytics.account.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.datalake.analytics.account.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.datalake.analytics.account.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FirewallRule(SubResource):
    """Data Lake Analytics firewall rule information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype end_ip_address: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "start_ip_address": {"readonly": True},
        "end_ip_address": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.start_ip_address = None
        self.end_ip_address = None


class FirewallRuleListResult(_serialization.Model):
    """Data Lake Analytics firewall rule list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.FirewallRule]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class HiveMetastore(SubResource):
    """HiveMetastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar server_uri: The serverUri for the Hive MetaStore.
    :vartype server_uri: str
    :ivar database_name: The databaseName for the Hive MetaStore.
    :vartype database_name: str
    :ivar runtime_version: The runtimeVersion for the Hive MetaStore.
    :vartype runtime_version: str
    :ivar user_name: The userName for the Hive MetaStore.
    :vartype user_name: str
    :ivar password: The password for the Hive MetaStore.
    :vartype password: str
    :ivar nested_resource_provisioning_state: The current state of the NestedResource. Known values
     are: "Succeeded", "Canceled", and "Failed".
    :vartype nested_resource_provisioning_state: str or
     ~azure.mgmt.datalake.analytics.account.models.NestedResourceProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "server_uri": {"readonly": True},
        "database_name": {"readonly": True},
        "runtime_version": {"readonly": True},
        "user_name": {"readonly": True},
        "password": {"readonly": True},
        "nested_resource_provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "server_uri": {"key": "properties.serverUri", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "runtime_version": {"key": "properties.runtimeVersion", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "nested_resource_provisioning_state": {"key": "properties.nestedResourceProvisioningState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.server_uri = None
        self.database_name = None
        self.runtime_version = None
        self.user_name = None
        self.password = None
        self.nested_resource_provisioning_state = None


class HiveMetastoreListResult(_serialization.Model):
    """Data Lake Analytics HiveMetastore list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.HiveMetastore]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HiveMetastore]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class NameAvailabilityInformation(_serialization.Model):
    """Data Lake Analytics account name availability result information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The Boolean value of true or false to indicate whether the Data Lake
     Analytics account name is available or not.
    :vartype name_available: bool
    :ivar reason: The reason why the Data Lake Analytics account name is not available, if
     nameAvailable is false.
    :vartype reason: str
    :ivar message: The message describing why the Data Lake Analytics account name is not
     available, if nameAvailable is false.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class Operation(_serialization.Model):
    """An available operation for Data Lake Analytics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar display: The display information for the operation.
    :vartype display: ~azure.mgmt.datalake.analytics.account.models.OperationDisplay
    :ivar properties: The OperationMetaPropertyInfo for the operation.
    :vartype properties: ~azure.mgmt.datalake.analytics.account.models.OperationMetaPropertyInfo
    :ivar origin: The intended executor of the operation. Known values are: "user", "system", and
     "user,system".
    :vartype origin: str or ~azure.mgmt.datalake.analytics.account.models.OperationOrigin
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "properties": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "properties": {"key": "properties", "type": "OperationMetaPropertyInfo"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display = None
        self.properties = None
        self.origin = None


class OperationDisplay(_serialization.Model):
    """The display information for a particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider of the operation.
    :vartype provider: str
    :ivar resource: The resource type of the operation.
    :vartype resource: str
    :ivar operation: A friendly name of the operation.
    :vartype operation: str
    :ivar description: A friendly description of the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """The list of available operations for Data Lake Analytics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.Operation]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationMetaLogSpecification(_serialization.Model):
    """OperationMetaLogSpecification.

    :ivar name: The name for OperationMetaLogSpecification.
    :vartype name: str
    :ivar display_name: The displayName for OperationMetaLogSpecification.
    :vartype display_name: str
    :ivar blob_duration: The blobDuration for OperationMetaLogSpecification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name for OperationMetaLogSpecification.
        :paramtype name: str
        :keyword display_name: The displayName for OperationMetaLogSpecification.
        :paramtype display_name: str
        :keyword blob_duration: The blobDuration for OperationMetaLogSpecification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class OperationMetaMetricAvailabilitiesSpecification(_serialization.Model):
    """OperationMetaMetricAvailabilitiesSpecification.

    :ivar time_grain: The timegrain for OperationMetaMetricAvailabilitiesSpecification.
    :vartype time_grain: str
    :ivar blob_duration: The blobDuration for OperationMetaMetricAvailabilitiesSpecification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs):
        """
        :keyword time_grain: The timegrain for OperationMetaMetricAvailabilitiesSpecification.
        :paramtype time_grain: str
        :keyword blob_duration: The blobDuration for OperationMetaMetricAvailabilitiesSpecification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class OperationMetaMetricSpecification(_serialization.Model):
    """OperationMetaMetricSpecification.

    :ivar name: The name for OperationMetaMetricSpecification.
    :vartype name: str
    :ivar display_description: The displayName for OperationMetaMetricSpecification.
    :vartype display_description: str
    :ivar display_name: The displayName for OperationMetaMetricSpecification.
    :vartype display_name: str
    :ivar unit: The unit for OperationMetaMetricSpecification.
    :vartype unit: str
    :ivar aggregation_type: The aggregationType for OperationMetaMetricSpecification.
    :vartype aggregation_type: str
    :ivar availabilities: The availabilities for OperationMetaMetricSpecification.
    :vartype availabilities:
     list[~azure.mgmt.datalake.analytics.account.models.OperationMetaMetricAvailabilitiesSpecification]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[OperationMetaMetricAvailabilitiesSpecification]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_description: Optional[str] = None,
        display_name: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        availabilities: Optional[List["_models.OperationMetaMetricAvailabilitiesSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name for OperationMetaMetricSpecification.
        :paramtype name: str
        :keyword display_description: The displayName for OperationMetaMetricSpecification.
        :paramtype display_description: str
        :keyword display_name: The displayName for OperationMetaMetricSpecification.
        :paramtype display_name: str
        :keyword unit: The unit for OperationMetaMetricSpecification.
        :paramtype unit: str
        :keyword aggregation_type: The aggregationType for OperationMetaMetricSpecification.
        :paramtype aggregation_type: str
        :keyword availabilities: The availabilities for OperationMetaMetricSpecification.
        :paramtype availabilities:
         list[~azure.mgmt.datalake.analytics.account.models.OperationMetaMetricAvailabilitiesSpecification]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_description = display_description
        self.display_name = display_name
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities


class OperationMetaPropertyInfo(_serialization.Model):
    """OperationMetaPropertyInfo.

    :ivar service_specification: The operations OperationMetaServiceSpecification.
    :vartype service_specification:
     ~azure.mgmt.datalake.analytics.account.models.OperationMetaServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "OperationMetaServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.OperationMetaServiceSpecification"] = None, **kwargs
    ):
        """
        :keyword service_specification: The operations OperationMetaServiceSpecification.
        :paramtype service_specification:
         ~azure.mgmt.datalake.analytics.account.models.OperationMetaServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class OperationMetaServiceSpecification(_serialization.Model):
    """OperationMetaServiceSpecification.

    :ivar metric_specifications: The metricSpecifications for OperationMetaServiceSpecification.
    :vartype metric_specifications:
     list[~azure.mgmt.datalake.analytics.account.models.OperationMetaMetricSpecification]
    :ivar log_specifications: The logSpecifications for OperationMetaServiceSpecification.
    :vartype log_specifications:
     list[~azure.mgmt.datalake.analytics.account.models.OperationMetaLogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[OperationMetaMetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[OperationMetaLogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.OperationMetaMetricSpecification"]] = None,
        log_specifications: Optional[List["_models.OperationMetaLogSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications: The metricSpecifications for OperationMetaServiceSpecification.
        :paramtype metric_specifications:
         list[~azure.mgmt.datalake.analytics.account.models.OperationMetaMetricSpecification]
        :keyword log_specifications: The logSpecifications for OperationMetaServiceSpecification.
        :paramtype log_specifications:
         list[~azure.mgmt.datalake.analytics.account.models.OperationMetaLogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class SasTokenInformation(_serialization.Model):
    """SAS token information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_token: The access token for the associated Azure Storage Container.
    :vartype access_token: str
    """

    _validation = {
        "access_token": {"readonly": True},
    }

    _attribute_map = {
        "access_token": {"key": "accessToken", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.access_token = None


class SasTokenInformationListResult(_serialization.Model):
    """The SAS response that contains the storage account, container and associated SAS token for connection use.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.SasTokenInformation]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SasTokenInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageAccountInformation(SubResource):
    """Azure Storage account information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar suffix: The optional suffix for the storage account.
    :vartype suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "suffix": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.suffix = None


class StorageAccountInformationListResult(_serialization.Model):
    """Azure Storage account list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.StorageAccountInformation]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccountInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageContainer(SubResource):
    """Azure Storage blob container information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar last_modified_time: The last modified time of the blob container.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.last_modified_time = None


class StorageContainerListResult(_serialization.Model):
    """The list of blob containers associated with the storage account attached to the Data Lake Analytics account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.StorageContainer]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageContainer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class UpdateComputePolicyParameters(_serialization.Model):
    """The parameters used to update a compute policy.

    :ivar object_id: The AAD object identifier for the entity to create a policy for.
    :vartype object_id: str
    :ivar object_type: The type of AAD object the object identifier refers to. Known values are:
     "User", "Group", and "ServicePrincipal".
    :vartype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
    :ivar max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
     can use to submit jobs. This property, the min priority per job property, or both must be
     passed.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum priority per job this user can use to submit jobs. This
     property, the max degree of parallelism per job property, or both must be passed.
    :vartype min_priority_per_job: int
    """

    _validation = {
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"minimum": 1},
    }

    _attribute_map = {
        "object_id": {"key": "properties.objectId", "type": "str"},
        "object_type": {"key": "properties.objectType", "type": "str"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
    }

    def __init__(
        self,
        *,
        object_id: Optional[str] = None,
        object_type: Optional[Union[str, "_models.AADObjectType"]] = None,
        max_degree_of_parallelism_per_job: Optional[int] = None,
        min_priority_per_job: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword object_id: The AAD object identifier for the entity to create a policy for.
        :paramtype object_id: str
        :keyword object_type: The type of AAD object the object identifier refers to. Known values are:
         "User", "Group", and "ServicePrincipal".
        :paramtype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
        :keyword max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
         can use to submit jobs. This property, the min priority per job property, or both must be
         passed.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword min_priority_per_job: The minimum priority per job this user can use to submit jobs.
         This property, the max degree of parallelism per job property, or both must be passed.
        :paramtype min_priority_per_job: int
        """
        super().__init__(**kwargs)
        self.object_id = object_id
        self.object_type = object_type
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job


class UpdateComputePolicyWithAccountParameters(_serialization.Model):
    """The parameters used to update a compute policy while updating a Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the compute policy to update. Required.
    :vartype name: str
    :ivar object_id: The AAD object identifier for the entity to create a policy for.
    :vartype object_id: str
    :ivar object_type: The type of AAD object the object identifier refers to. Known values are:
     "User", "Group", and "ServicePrincipal".
    :vartype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
    :ivar max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
     can use to submit jobs. This property, the min priority per job property, or both must be
     passed.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum priority per job this user can use to submit jobs. This
     property, the max degree of parallelism per job property, or both must be passed.
    :vartype min_priority_per_job: int
    """

    _validation = {
        "name": {"required": True},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "object_id": {"key": "properties.objectId", "type": "str"},
        "object_type": {"key": "properties.objectType", "type": "str"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        object_id: Optional[str] = None,
        object_type: Optional[Union[str, "_models.AADObjectType"]] = None,
        max_degree_of_parallelism_per_job: Optional[int] = None,
        min_priority_per_job: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The unique name of the compute policy to update. Required.
        :paramtype name: str
        :keyword object_id: The AAD object identifier for the entity to create a policy for.
        :paramtype object_id: str
        :keyword object_type: The type of AAD object the object identifier refers to. Known values are:
         "User", "Group", and "ServicePrincipal".
        :paramtype object_type: str or ~azure.mgmt.datalake.analytics.account.models.AADObjectType
        :keyword max_degree_of_parallelism_per_job: The maximum degree of parallelism per job this user
         can use to submit jobs. This property, the min priority per job property, or both must be
         passed.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword min_priority_per_job: The minimum priority per job this user can use to submit jobs.
         This property, the max degree of parallelism per job property, or both must be passed.
        :paramtype min_priority_per_job: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.object_id = object_id
        self.object_type = object_type
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job


class UpdateDataLakeAnalyticsAccountParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters that can be used to update an existing Data Lake Analytics account.

    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar data_lake_store_accounts: The list of Data Lake Store accounts associated with this
     account.
    :vartype data_lake_store_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.UpdateDataLakeStoreWithAccountParameters]
    :ivar storage_accounts: The list of Azure Blob storage accounts associated with this account.
    :vartype storage_accounts:
     list[~azure.mgmt.datalake.analytics.account.models.UpdateStorageAccountWithAccountParameters]
    :ivar compute_policies: The list of compute policies associated with this account.
    :vartype compute_policies:
     list[~azure.mgmt.datalake.analytics.account.models.UpdateComputePolicyWithAccountParameters]
    :ivar firewall_rules: The list of firewall rules associated with this account.
    :vartype firewall_rules:
     list[~azure.mgmt.datalake.analytics.account.models.UpdateFirewallRuleWithAccountParameters]
    :ivar firewall_state: The current state of the IP address firewall for this account. Disabling
     the firewall does not remove existing rules, they will just be ignored until the firewall is
     re-enabled. Known values are: "Enabled" and "Disabled".
    :vartype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
    :ivar firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
     values are: "Enabled" and "Disabled".
    :vartype firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
    :ivar new_tier: The commitment tier to use for next month. Known values are: "Consumption",
     "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
     "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
     "Commitment_100000AUHours", and "Commitment_500000AUHours".
    :vartype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
    :ivar max_job_count: The maximum supported jobs running under the account at the same time.
    :vartype max_job_count: int
    :ivar max_degree_of_parallelism: The maximum supported degree of parallelism for this account.
    :vartype max_degree_of_parallelism: int
    :ivar max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
     for this account.
    :vartype max_degree_of_parallelism_per_job: int
    :ivar min_priority_per_job: The minimum supported priority per job for this account.
    :vartype min_priority_per_job: int
    :ivar query_store_retention: The number of days that job metadata is retained.
    :vartype query_store_retention: int
    """

    _validation = {
        "max_job_count": {"minimum": 1},
        "max_degree_of_parallelism": {"minimum": 1},
        "max_degree_of_parallelism_per_job": {"minimum": 1},
        "min_priority_per_job": {"minimum": 1},
        "query_store_retention": {"maximum": 180, "minimum": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "data_lake_store_accounts": {
            "key": "properties.dataLakeStoreAccounts",
            "type": "[UpdateDataLakeStoreWithAccountParameters]",
        },
        "storage_accounts": {
            "key": "properties.storageAccounts",
            "type": "[UpdateStorageAccountWithAccountParameters]",
        },
        "compute_policies": {"key": "properties.computePolicies", "type": "[UpdateComputePolicyWithAccountParameters]"},
        "firewall_rules": {"key": "properties.firewallRules", "type": "[UpdateFirewallRuleWithAccountParameters]"},
        "firewall_state": {"key": "properties.firewallState", "type": "str"},
        "firewall_allow_azure_ips": {"key": "properties.firewallAllowAzureIps", "type": "str"},
        "new_tier": {"key": "properties.newTier", "type": "str"},
        "max_job_count": {"key": "properties.maxJobCount", "type": "int"},
        "max_degree_of_parallelism": {"key": "properties.maxDegreeOfParallelism", "type": "int"},
        "max_degree_of_parallelism_per_job": {"key": "properties.maxDegreeOfParallelismPerJob", "type": "int"},
        "min_priority_per_job": {"key": "properties.minPriorityPerJob", "type": "int"},
        "query_store_retention": {"key": "properties.queryStoreRetention", "type": "int"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        data_lake_store_accounts: Optional[List["_models.UpdateDataLakeStoreWithAccountParameters"]] = None,
        storage_accounts: Optional[List["_models.UpdateStorageAccountWithAccountParameters"]] = None,
        compute_policies: Optional[List["_models.UpdateComputePolicyWithAccountParameters"]] = None,
        firewall_rules: Optional[List["_models.UpdateFirewallRuleWithAccountParameters"]] = None,
        firewall_state: Optional[Union[str, "_models.FirewallState"]] = None,
        firewall_allow_azure_ips: Optional[Union[str, "_models.FirewallAllowAzureIpsState"]] = None,
        new_tier: Optional[Union[str, "_models.TierType"]] = None,
        max_job_count: Optional[int] = None,
        max_degree_of_parallelism: Optional[int] = None,
        max_degree_of_parallelism_per_job: Optional[int] = None,
        min_priority_per_job: Optional[int] = None,
        query_store_retention: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword data_lake_store_accounts: The list of Data Lake Store accounts associated with this
         account.
        :paramtype data_lake_store_accounts:
         list[~azure.mgmt.datalake.analytics.account.models.UpdateDataLakeStoreWithAccountParameters]
        :keyword storage_accounts: The list of Azure Blob storage accounts associated with this
         account.
        :paramtype storage_accounts:
         list[~azure.mgmt.datalake.analytics.account.models.UpdateStorageAccountWithAccountParameters]
        :keyword compute_policies: The list of compute policies associated with this account.
        :paramtype compute_policies:
         list[~azure.mgmt.datalake.analytics.account.models.UpdateComputePolicyWithAccountParameters]
        :keyword firewall_rules: The list of firewall rules associated with this account.
        :paramtype firewall_rules:
         list[~azure.mgmt.datalake.analytics.account.models.UpdateFirewallRuleWithAccountParameters]
        :keyword firewall_state: The current state of the IP address firewall for this account.
         Disabling the firewall does not remove existing rules, they will just be ignored until the
         firewall is re-enabled. Known values are: "Enabled" and "Disabled".
        :paramtype firewall_state: str or ~azure.mgmt.datalake.analytics.account.models.FirewallState
        :keyword firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
         within Azure through the firewall. If the firewall is disabled, this is not enforced. Known
         values are: "Enabled" and "Disabled".
        :paramtype firewall_allow_azure_ips: str or
         ~azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState
        :keyword new_tier: The commitment tier to use for next month. Known values are: "Consumption",
         "Commitment_100AUHours", "Commitment_500AUHours", "Commitment_1000AUHours",
         "Commitment_5000AUHours", "Commitment_10000AUHours", "Commitment_50000AUHours",
         "Commitment_100000AUHours", and "Commitment_500000AUHours".
        :paramtype new_tier: str or ~azure.mgmt.datalake.analytics.account.models.TierType
        :keyword max_job_count: The maximum supported jobs running under the account at the same time.
        :paramtype max_job_count: int
        :keyword max_degree_of_parallelism: The maximum supported degree of parallelism for this
         account.
        :paramtype max_degree_of_parallelism: int
        :keyword max_degree_of_parallelism_per_job: The maximum supported degree of parallelism per job
         for this account.
        :paramtype max_degree_of_parallelism_per_job: int
        :keyword min_priority_per_job: The minimum supported priority per job for this account.
        :paramtype min_priority_per_job: int
        :keyword query_store_retention: The number of days that job metadata is retained.
        :paramtype query_store_retention: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.data_lake_store_accounts = data_lake_store_accounts
        self.storage_accounts = storage_accounts
        self.compute_policies = compute_policies
        self.firewall_rules = firewall_rules
        self.firewall_state = firewall_state
        self.firewall_allow_azure_ips = firewall_allow_azure_ips
        self.new_tier = new_tier
        self.max_job_count = max_job_count
        self.max_degree_of_parallelism = max_degree_of_parallelism
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job
        self.query_store_retention = query_store_retention


class UpdateDataLakeStoreWithAccountParameters(_serialization.Model):
    """The parameters used to update a Data Lake Store account while updating a Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the Data Lake Store account to update. Required.
    :vartype name: str
    :ivar suffix: The optional suffix for the Data Lake Store account.
    :vartype suffix: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, name: str, suffix: Optional[str] = None, **kwargs):
        """
        :keyword name: The unique name of the Data Lake Store account to update. Required.
        :paramtype name: str
        :keyword suffix: The optional suffix for the Data Lake Store account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.suffix = suffix


class UpdateFirewallRuleParameters(_serialization.Model):
    """The parameters used to update a firewall rule.

    :ivar start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype end_ip_address: str
    """

    _attribute_map = {
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(self, *, start_ip_address: Optional[str] = None, end_ip_address: Optional[str] = None, **kwargs):
        """
        :keyword start_ip_address: The start IP address for the firewall rule. This can be either ipv4
         or ipv6. Start and End should be in the same protocol.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
         ipv6. Start and End should be in the same protocol.
        :paramtype end_ip_address: str
        """
        super().__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class UpdateFirewallRuleWithAccountParameters(_serialization.Model):
    """The parameters used to update a firewall rule while updating a Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the firewall rule to update. Required.
    :vartype name: str
    :ivar start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype end_ip_address: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(
        self, *, name: str, start_ip_address: Optional[str] = None, end_ip_address: Optional[str] = None, **kwargs
    ):
        """
        :keyword name: The unique name of the firewall rule to update. Required.
        :paramtype name: str
        :keyword start_ip_address: The start IP address for the firewall rule. This can be either ipv4
         or ipv6. Start and End should be in the same protocol.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
         ipv6. Start and End should be in the same protocol.
        :paramtype end_ip_address: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class UpdateStorageAccountParameters(_serialization.Model):
    """The parameters used to update an Azure Storage account.

    :ivar access_key: The updated access key associated with this Azure Storage account that will
     be used to connect to it.
    :vartype access_key: str
    :ivar suffix: The optional suffix for the storage account.
    :vartype suffix: str
    """

    _attribute_map = {
        "access_key": {"key": "properties.accessKey", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, access_key: Optional[str] = None, suffix: Optional[str] = None, **kwargs):
        """
        :keyword access_key: The updated access key associated with this Azure Storage account that
         will be used to connect to it.
        :paramtype access_key: str
        :keyword suffix: The optional suffix for the storage account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.access_key = access_key
        self.suffix = suffix


class UpdateStorageAccountWithAccountParameters(_serialization.Model):
    """The parameters used to update an Azure Storage account while updating a Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The unique name of the Azure Storage account to update. Required.
    :vartype name: str
    :ivar access_key: The updated access key associated with this Azure Storage account that will
     be used to connect to it.
    :vartype access_key: str
    :ivar suffix: The optional suffix for the storage account.
    :vartype suffix: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_key": {"key": "properties.accessKey", "type": "str"},
        "suffix": {"key": "properties.suffix", "type": "str"},
    }

    def __init__(self, *, name: str, access_key: Optional[str] = None, suffix: Optional[str] = None, **kwargs):
        """
        :keyword name: The unique name of the Azure Storage account to update. Required.
        :paramtype name: str
        :keyword access_key: The updated access key associated with this Azure Storage account that
         will be used to connect to it.
        :paramtype access_key: str
        :keyword suffix: The optional suffix for the storage account.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_key = access_key
        self.suffix = suffix


class VirtualNetworkRule(SubResource):
    """Data Lake Analytics  VirtualNetwork Rule information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar subnet_id: The resource identifier for the subnet.
    :vartype subnet_id: str
    :ivar virtual_network_rule_state: The current state of the VirtualNetwork Rule. Known values
     are: "Active", "NetworkSourceDeleted", and "Failed".
    :vartype virtual_network_rule_state: str or
     ~azure.mgmt.datalake.analytics.account.models.VirtualNetworkRuleState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "subnet_id": {"readonly": True},
        "virtual_network_rule_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "virtual_network_rule_state": {"key": "properties.virtualNetworkRuleState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.subnet_id = None
        self.virtual_network_rule_state = None


class VirtualNetworkRuleListResult(_serialization.Model):
    """Data Lake Analytics VirtualNetwork rule list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.analytics.account.models.VirtualNetworkRule]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None
