# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementCachesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_get(self, resource_group):
        response = await self.client.caches.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            cache_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.caches.begin_create_or_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                cache_name="str",
                body={
                    "location": "str",
                    "properties": {
                        "cacheSubnetResourceId": "str",
                        "encryptionKeySource": "str",
                        "filepath": "str",
                        "originClusterInformation": {
                            "peerAddresses": ["str"],
                            "peerClusterName": "str",
                            "peerVolumeName": "str",
                            "peerVserverName": "str",
                        },
                        "peeringSubnetResourceId": "str",
                        "size": 0,
                        "actualThroughputMibps": 0.0,
                        "cacheState": "str",
                        "cifsChangeNotifications": "str",
                        "encryption": "str",
                        "exportPolicy": [
                            {
                                "allowedClients": "str",
                                "chownMode": "str",
                                "cifs": bool,
                                "hasRootAccess": bool,
                                "kerberos5ReadOnly": bool,
                                "kerberos5ReadWrite": bool,
                                "kerberos5iReadOnly": bool,
                                "kerberos5iReadWrite": bool,
                                "kerberos5pReadOnly": bool,
                                "kerberos5pReadWrite": bool,
                                "nfsv3": bool,
                                "nfsv41": bool,
                                "ruleIndex": 0,
                                "unixReadOnly": bool,
                                "unixReadWrite": bool,
                            }
                        ],
                        "globalFileLocking": "str",
                        "kerberos": "str",
                        "keyVaultPrivateEndpointResourceId": "str",
                        "language": "str",
                        "ldap": "str",
                        "ldapServerType": "str",
                        "maximumNumberOfFiles": 0,
                        "mountTargets": [{"ipAddress": "str", "mountTargetId": "str", "smbServerFqdn": "str"}],
                        "protocolTypes": ["str"],
                        "provisioningState": "str",
                        "smbSettings": {
                            "smbAccessBasedEnumerations": "str",
                            "smbEncryption": "str",
                            "smbNonBrowsable": "str",
                        },
                        "throughputMibps": 0.0,
                        "writeBack": "str",
                    },
                    "etag": "str",
                    "id": "str",
                    "name": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "zones": ["str"],
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_begin_update(self, resource_group):
        response = await (
            await self.client.caches.begin_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                cache_name="str",
                body={
                    "properties": {
                        "cifsChangeNotifications": "str",
                        "exportPolicy": [
                            {
                                "allowedClients": "str",
                                "chownMode": "str",
                                "cifs": bool,
                                "hasRootAccess": bool,
                                "kerberos5ReadOnly": bool,
                                "kerberos5ReadWrite": bool,
                                "kerberos5iReadOnly": bool,
                                "kerberos5iReadWrite": bool,
                                "kerberos5pReadOnly": bool,
                                "kerberos5pReadWrite": bool,
                                "nfsv3": bool,
                                "nfsv41": bool,
                                "ruleIndex": 0,
                                "unixReadOnly": bool,
                                "unixReadWrite": bool,
                            }
                        ],
                        "keyVaultPrivateEndpointResourceId": "str",
                        "protocolTypes": ["str"],
                        "size": 0,
                        "smbSettings": {
                            "smbAccessBasedEnumerations": "str",
                            "smbEncryption": "str",
                            "smbNonBrowsable": "str",
                        },
                        "throughputMibps": 0.0,
                        "writeBack": "str",
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_begin_delete(self, resource_group):
        response = await (
            await self.client.caches.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                cache_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_list_by_capacity_pools(self, resource_group):
        response = self.client.caches.list_by_capacity_pools(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_list_peering_passphrases(self, resource_group):
        response = await self.client.caches.list_peering_passphrases(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            cache_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_caches_begin_pool_change(self, resource_group):
        response = await (
            await self.client.caches.begin_pool_change(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                cache_name="str",
                body={"newPoolResourceId": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
