% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path_file}
\alias{path_file}
\alias{path_dir}
\alias{path_ext}
\alias{path_ext_remove}
\alias{path_ext_set}
\alias{path_ext<-}
\title{Manipulate file paths}
\usage{
path_file(path)

path_dir(path)

path_ext(path)

path_ext_remove(path)

path_ext_set(path, ext)

path_ext(path) <- value
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{ext, value}{The new file extension.}
}
\description{
\code{path_file()} returns the filename portion of the path, \code{path_dir()} returns
the directory portion. \code{path_ext()} returns the last extension (if any) for a
path. \code{path_ext_remove()} removes the last extension and returns the rest of
the path. \code{path_ext_set()} replaces the extension with a new extension. If
there is no existing extension the new extension is appended.
}
\details{
Note because these are not full file paths they return regular character
vectors, not \code{fs_path()} objects.
}
\examples{
path_file("dir/file.zip")

path_dir("dir/file.zip")

path_ext("dir/file.zip")

path_ext("file.tar.gz")

path_ext_remove("file.tar.gz")

# Only one level of extension is removed
path_ext_set(path_ext_remove("file.tar.gz"), "zip")
}
\seealso{
\code{\link[base:basename]{base::basename()}}, \code{\link[base:dirname]{base::dirname()}}
}
