% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.R
\name{modeling-usethis}
\alias{modeling-usethis}
\alias{create_modeling_package}
\alias{use_modeling_deps}
\alias{use_modeling_files}
\title{Create a modeling package}
\usage{
create_modeling_package(path, model, fields = NULL, open = interactive())

use_modeling_deps()

use_modeling_files(model)
}
\arguments{
\item{path}{A path. If it exists, it is used. If it does not exist,
it is created, provided that the parent path exists.}

\item{model}{A string. The name of the high level modeling function that
users will call. For example, \code{"linear_regression"}. This will be used to
populate the skeleton. Spaces are not allowed.}

\item{fields}{A named list of fields to add to DESCRIPTION,
potentially overriding default values. See \code{usethis::use_description()} for
how you can set personalized defaults using package options.}

\item{open}{If TRUE, activates the new project:
\itemize{
\item If RStudio desktop, the package is opened in a new session.
\item If on RStudio server, the current RStudio project is activated.
\item Otherwise, the working directory and active project is changed.
}}
}
\value{
\code{create_modeling_package()} returns the project path invisibly.

\code{use_modeling_deps()} returns invisibly.

\code{use_modeling_files()} return \code{model} invisibly.
}
\description{
\code{create_modeling_package()} will:
\itemize{
\item Call \code{usethis::create_package()} to set up a new R package.
\item Call \code{use_modeling_deps()}.
\item Call \code{use_modeling_files()}.
}

\code{use_modeling_deps()} will:
\itemize{
\item Add hardhat, rlang, and stats to Imports
\item Add recipes to Suggests
\item If roxygen2 is available, use roxygen markdown
}

\code{use_modeling_files()} will:
\itemize{
\item Add a package documentation file
\item Generate and populate 3 files in \verb{R/}:
\itemize{
\item \code{{{model}}-constructor.R}
\item \code{{{model}}-fit.R}
\item \code{{{model}}-predict.R}
}
}
}
