// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from EventEngine.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl._event {
  public class Engine_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("event.Engine:1.0.1", null);

    public Engine_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Engine_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Engine_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Engine_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class EventDesc : ICloneable {
      public object Clone() {
        EventDesc copy = new EventDesc();
        copy.eventDescType = this.eventDescType;
        copy.eventType = this.eventType;
        copy.dynNodeContext = this.dynNodeContext;
        copy.idComp = this.idComp;
        copy.name = this.name;
        copy.entries = this.entries;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["eventDescType"] = (int)this.eventDescType;
        json["eventType"] = (int)this.eventType;
        json["dynNodeContext"] = this.dynNodeContext;
        json["idComp"] = this.idComp;
        json["name"] = this.name;
        json["entries"] = new JsonArray(this.entries.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static EventDesc Decode(LightJson.JsonObject json, Agent agent) {
        EventDesc inst = new EventDesc();
        inst.eventDescType = (Com.Raritan.Idl._event.Engine_1_0_1.EventDesc.Type)(int)json["eventDescType"];
        inst.eventType = (Com.Raritan.Idl._event.Event.Type)(int)json["eventType"];
        inst.dynNodeContext = (string)json["dynNodeContext"];
        inst.idComp = (string)json["idComp"];
        inst.name = (string)json["name"];
        inst.entries = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.EventDesc>(json["entries"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.Engine_1_0_1.EventDesc.Decode(_value, agent)));
        return inst;
      }


      public enum Type {
        NODE,
        DYN_NODE,
        LEAF,
      }
      public Com.Raritan.Idl._event.Engine_1_0_1.EventDesc.Type eventDescType = Com.Raritan.Idl._event.Engine_1_0_1.EventDesc.Type.NODE;
      public Com.Raritan.Idl._event.Event.Type eventType = Com.Raritan.Idl._event.Event.Type.STATE;
      public string dynNodeContext = "";
      public string idComp = "";
      public string name = "";
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.Engine_1_0_1.EventDesc> entries = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.EventDesc>();
    }

    public class ListEventDescsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.Engine_1_0_1.EventDesc> eventDescs;
    }

    public ListEventDescsResult listEventDescs(System.Collections.Generic.IEnumerable<string> eventIdPrefix) {
      var _parameters = new LightJson.JsonObject();
      _parameters["eventIdPrefix"] = new JsonArray(eventIdPrefix.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("listEventDescs", _parameters);
      var _ret = new ListEventDescsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.eventDescs = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.EventDesc>(_result["eventDescs"].AsJsonArray.Select(
        _value => Com.Raritan.Idl._event.Engine_1_0_1.EventDesc.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest listEventDescs(System.Collections.Generic.IEnumerable<string> eventIdPrefix, AsyncRpcResponse<ListEventDescsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listEventDescs(eventIdPrefix, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listEventDescs(System.Collections.Generic.IEnumerable<string> eventIdPrefix, AsyncRpcResponse<ListEventDescsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["eventIdPrefix"] = new JsonArray(eventIdPrefix.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("listEventDescs", _parameters,
        _result => {
          try {
            var _ret = new ListEventDescsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.eventDescs = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.EventDesc>(_result["eventDescs"].AsJsonArray.Select(
              _value => Com.Raritan.Idl._event.Engine_1_0_1.EventDesc.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListActionTypesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public ListActionTypesResult listActionTypes() {
      JsonObject _parameters = null;
      var _result = RpcCall("listActionTypes", _parameters);
      var _ret = new ListActionTypesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest listActionTypes(AsyncRpcResponse<ListActionTypesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listActionTypes(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listActionTypes(AsyncRpcResponse<ListActionTypesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listActionTypes", _parameters,
        _result => {
          try {
            var _ret = new ListActionTypesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class Action : ICloneable {
      public object Clone() {
        Action copy = new Action();
        copy.id = this.id;
        copy.name = this.name;
        copy.isSystem = this.isSystem;
        copy.type = this.type;
        copy.arguments = this.arguments;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["name"] = this.name;
        json["isSystem"] = this.isSystem;
        json["type"] = this.type;
        json["arguments"] = new JsonArray(this.arguments.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static Action Decode(LightJson.JsonObject json, Agent agent) {
        Action inst = new Action();
        inst.id = (string)json["id"];
        inst.name = (string)json["name"];
        inst.isSystem = (bool)json["isSystem"];
        inst.type = (string)json["type"];
        inst.arguments = new System.Collections.Generic.List<Com.Raritan.Idl._event.KeyValue>(json["arguments"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.KeyValue.Decode(_value, agent)));
        return inst;
      }

      public string id = "";
      public string name = "";
      public bool isSystem = false;
      public string type = "";
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> arguments = new System.Collections.Generic.List<Com.Raritan.Idl._event.KeyValue>();
    }

    public class AddActionResult {
      public int _ret_;
      public string actionId;
    }

    public AddActionResult addAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action) {
      var _parameters = new LightJson.JsonObject();
      _parameters["action"] = action.Encode();

      var _result = RpcCall("addAction", _parameters);
      var _ret = new AddActionResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.actionId = (string)_result["actionId"];
      return _ret;
    }

    public AsyncRequest addAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, AsyncRpcResponse<AddActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addAction(action, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, AsyncRpcResponse<AddActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["action"] = action.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addAction", _parameters,
        _result => {
          try {
            var _ret = new AddActionResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.actionId = (string)_result["actionId"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyActionResult {
      public int _ret_;
    }

    public ModifyActionResult modifyAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action) {
      var _parameters = new LightJson.JsonObject();
      _parameters["action"] = action.Encode();

      var _result = RpcCall("modifyAction", _parameters);
      var _ret = new ModifyActionResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, AsyncRpcResponse<ModifyActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyAction(action, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, AsyncRpcResponse<ModifyActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["action"] = action.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyAction", _parameters,
        _result => {
          try {
            var _ret = new ModifyActionResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteActionResult {
      public int _ret_;
    }

    public DeleteActionResult deleteAction(string actionId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["actionId"] = actionId;

      var _result = RpcCall("deleteAction", _parameters);
      var _ret = new DeleteActionResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteAction(string actionId, AsyncRpcResponse<DeleteActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteAction(actionId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteAction(string actionId, AsyncRpcResponse<DeleteActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["actionId"] = actionId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteAction", _parameters,
        _result => {
          try {
            var _ret = new DeleteActionResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListActionsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.Engine_1_0_1.Action> _ret_;
    }

    public ListActionsResult listActions() {
      JsonObject _parameters = null;
      var _result = RpcCall("listActions", _parameters);
      var _ret = new ListActionsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.Action>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl._event.Engine_1_0_1.Action.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest listActions(AsyncRpcResponse<ListActionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listActions(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listActions(AsyncRpcResponse<ListActionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listActions", _parameters,
        _result => {
          try {
            var _ret = new ListActionsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.Action>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl._event.Engine_1_0_1.Action.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TriggerActionResult {
      public int _ret_;
      public string errMsg;
    }

    public TriggerActionResult triggerAction(string actionId, System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context) {
      var _parameters = new LightJson.JsonObject();
      _parameters["actionId"] = actionId;
      _parameters["context"] = new JsonArray(context.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("triggerAction", _parameters);
      var _ret = new TriggerActionResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.errMsg = (string)_result["errMsg"];
      return _ret;
    }

    public AsyncRequest triggerAction(string actionId, System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context, AsyncRpcResponse<TriggerActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return triggerAction(actionId, context, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest triggerAction(string actionId, System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context, AsyncRpcResponse<TriggerActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["actionId"] = actionId;
        _parameters["context"] = new JsonArray(context.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("triggerAction", _parameters,
        _result => {
          try {
            var _ret = new TriggerActionResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.errMsg = (string)_result["errMsg"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestActionResult {
      public int _ret_;
      public string errMsg;
    }

    public TestActionResult testAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context) {
      var _parameters = new LightJson.JsonObject();
      _parameters["action"] = action.Encode();
      _parameters["context"] = new JsonArray(context.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("testAction", _parameters);
      var _ret = new TestActionResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.errMsg = (string)_result["errMsg"];
      return _ret;
    }

    public AsyncRequest testAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context, AsyncRpcResponse<TestActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testAction(action, context, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testAction(Com.Raritan.Idl._event.Engine_1_0_1.Action action, System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context, AsyncRpcResponse<TestActionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["action"] = action.Encode();
        _parameters["context"] = new JsonArray(context.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testAction", _parameters,
        _result => {
          try {
            var _ret = new TestActionResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.errMsg = (string)_result["errMsg"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class Condition : ICloneable {
      public object Clone() {
        Condition copy = new Condition();
        copy.negate = this.negate;
        copy.operation = this.operation;
        copy.matchType = this.matchType;
        copy.eventId = this.eventId;
        copy.conditions = this.conditions;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["negate"] = this.negate;
        json["operation"] = (int)this.operation;
        json["matchType"] = (int)this.matchType;
        json["eventId"] = new JsonArray(this.eventId.Select(
          _value => (JsonValue)(_value)));
        json["conditions"] = new JsonArray(this.conditions.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static Condition Decode(LightJson.JsonObject json, Agent agent) {
        Condition inst = new Condition();
        inst.negate = (bool)json["negate"];
        inst.operation = (Com.Raritan.Idl._event.Engine_1_0_1.Condition.Op)(int)json["operation"];
        inst.matchType = (Com.Raritan.Idl._event.Engine_1_0_1.Condition.MatchType)(int)json["matchType"];
        inst.eventId = new System.Collections.Generic.List<string>(json["eventId"].AsJsonArray.Select(
          _value => (string)_value));
        inst.conditions = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.Condition>(json["conditions"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.Engine_1_0_1.Condition.Decode(_value, agent)));
        return inst;
      }


      public enum Op {
        AND,
        OR,
        XOR,
      }

      public enum MatchType {
        ASSERTED,
        DEASSERTED,
        BOTH,
      }
      public bool negate = false;
      public Com.Raritan.Idl._event.Engine_1_0_1.Condition.Op operation = Com.Raritan.Idl._event.Engine_1_0_1.Condition.Op.AND;
      public Com.Raritan.Idl._event.Engine_1_0_1.Condition.MatchType matchType = Com.Raritan.Idl._event.Engine_1_0_1.Condition.MatchType.ASSERTED;
      public System.Collections.Generic.IEnumerable<string> eventId = new System.Collections.Generic.List<string>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.Engine_1_0_1.Condition> conditions = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.Condition>();
    }

    public class Rule : ICloneable {
      public object Clone() {
        Rule copy = new Rule();
        copy.id = this.id;
        copy.name = this.name;
        copy.isSystem = this.isSystem;
        copy.isEnabled = this.isEnabled;
        copy.isAutoRearm = this.isAutoRearm;
        copy.hasMatched = this.hasMatched;
        copy.condition = this.condition;
        copy.actionIds = this.actionIds;
        copy.arguments = this.arguments;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["name"] = this.name;
        json["isSystem"] = this.isSystem;
        json["isEnabled"] = this.isEnabled;
        json["isAutoRearm"] = this.isAutoRearm;
        json["hasMatched"] = this.hasMatched;
        json["condition"] = this.condition.Encode();
        json["actionIds"] = new JsonArray(this.actionIds.Select(
          _value => (JsonValue)(_value)));
        json["arguments"] = new JsonArray(this.arguments.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static Rule Decode(LightJson.JsonObject json, Agent agent) {
        Rule inst = new Rule();
        inst.id = (string)json["id"];
        inst.name = (string)json["name"];
        inst.isSystem = (bool)json["isSystem"];
        inst.isEnabled = (bool)json["isEnabled"];
        inst.isAutoRearm = (bool)json["isAutoRearm"];
        inst.hasMatched = (bool)json["hasMatched"];
        inst.condition = Com.Raritan.Idl._event.Engine_1_0_1.Condition.Decode(json["condition"], agent);
        inst.actionIds = new System.Collections.Generic.List<string>(json["actionIds"].AsJsonArray.Select(
          _value => (string)_value));
        inst.arguments = new System.Collections.Generic.List<Com.Raritan.Idl._event.KeyValue>(json["arguments"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.KeyValue.Decode(_value, agent)));
        return inst;
      }

      public string id = "";
      public string name = "";
      public bool isSystem = false;
      public bool isEnabled = false;
      public bool isAutoRearm = false;
      public bool hasMatched = false;
      public Com.Raritan.Idl._event.Engine_1_0_1.Condition condition = new Com.Raritan.Idl._event.Engine_1_0_1.Condition();
      public System.Collections.Generic.IEnumerable<string> actionIds = new System.Collections.Generic.List<string>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> arguments = new System.Collections.Generic.List<Com.Raritan.Idl._event.KeyValue>();
    }

    public class AddRuleResult {
      public int _ret_;
      public string ruleId;
    }

    public AddRuleResult addRule(Com.Raritan.Idl._event.Engine_1_0_1.Rule rule) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rule"] = rule.Encode();

      var _result = RpcCall("addRule", _parameters);
      var _ret = new AddRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.ruleId = (string)_result["ruleId"];
      return _ret;
    }

    public AsyncRequest addRule(Com.Raritan.Idl._event.Engine_1_0_1.Rule rule, AsyncRpcResponse<AddRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addRule(rule, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addRule(Com.Raritan.Idl._event.Engine_1_0_1.Rule rule, AsyncRpcResponse<AddRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rule"] = rule.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addRule", _parameters,
        _result => {
          try {
            var _ret = new AddRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.ruleId = (string)_result["ruleId"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyRuleResult {
      public int _ret_;
    }

    public ModifyRuleResult modifyRule(Com.Raritan.Idl._event.Engine_1_0_1.Rule rule) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rule"] = rule.Encode();

      var _result = RpcCall("modifyRule", _parameters);
      var _ret = new ModifyRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyRule(Com.Raritan.Idl._event.Engine_1_0_1.Rule rule, AsyncRpcResponse<ModifyRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyRule(rule, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyRule(Com.Raritan.Idl._event.Engine_1_0_1.Rule rule, AsyncRpcResponse<ModifyRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rule"] = rule.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyRule", _parameters,
        _result => {
          try {
            var _ret = new ModifyRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EnableRuleResult {
      public int _ret_;
    }

    public EnableRuleResult enableRule(string ruleId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ruleId"] = ruleId;

      var _result = RpcCall("enableRule", _parameters);
      var _ret = new EnableRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest enableRule(string ruleId, AsyncRpcResponse<EnableRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return enableRule(ruleId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest enableRule(string ruleId, AsyncRpcResponse<EnableRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ruleId"] = ruleId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("enableRule", _parameters,
        _result => {
          try {
            var _ret = new EnableRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DisableRuleResult {
      public int _ret_;
    }

    public DisableRuleResult disableRule(string ruleId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ruleId"] = ruleId;

      var _result = RpcCall("disableRule", _parameters);
      var _ret = new DisableRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest disableRule(string ruleId, AsyncRpcResponse<DisableRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return disableRule(ruleId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest disableRule(string ruleId, AsyncRpcResponse<DisableRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ruleId"] = ruleId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("disableRule", _parameters,
        _result => {
          try {
            var _ret = new DisableRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteRuleResult {
      public int _ret_;
    }

    public DeleteRuleResult deleteRule(string ruleId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ruleId"] = ruleId;

      var _result = RpcCall("deleteRule", _parameters);
      var _ret = new DeleteRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteRule(string ruleId, AsyncRpcResponse<DeleteRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteRule(ruleId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteRule(string ruleId, AsyncRpcResponse<DeleteRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ruleId"] = ruleId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteRule", _parameters,
        _result => {
          try {
            var _ret = new DeleteRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListRulesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.Engine_1_0_1.Rule> _ret_;
    }

    public ListRulesResult listRules() {
      JsonObject _parameters = null;
      var _result = RpcCall("listRules", _parameters);
      var _ret = new ListRulesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.Rule>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl._event.Engine_1_0_1.Rule.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest listRules(AsyncRpcResponse<ListRulesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listRules(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listRules(AsyncRpcResponse<ListRulesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listRules", _parameters,
        _result => {
          try {
            var _ret = new ListRulesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl._event.Engine_1_0_1.Rule>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl._event.Engine_1_0_1.Rule.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeliverEventResult {
      public int _ret_;
    }

    public DeliverEventResult deliverEvent(Com.Raritan.Idl._event.Event _event) {
      var _parameters = new LightJson.JsonObject();
      _parameters["event"] = _event.Encode();

      var _result = RpcCall("deliverEvent", _parameters);
      var _ret = new DeliverEventResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deliverEvent(Com.Raritan.Idl._event.Event _event, AsyncRpcResponse<DeliverEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deliverEvent(_event, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deliverEvent(Com.Raritan.Idl._event.Event _event, AsyncRpcResponse<DeliverEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["event"] = _event.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deliverEvent", _parameters,
        _result => {
          try {
            var _ret = new DeliverEventResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class RearmRuleResult {
      public int _ret_;
    }

    public RearmRuleResult rearmRule(string ruleId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ruleId"] = ruleId;

      var _result = RpcCall("rearmRule", _parameters);
      var _ret = new RearmRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest rearmRule(string ruleId, AsyncRpcResponse<RearmRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return rearmRule(ruleId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest rearmRule(string ruleId, AsyncRpcResponse<RearmRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ruleId"] = ruleId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("rearmRule", _parameters,
        _result => {
          try {
            var _ret = new RearmRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
