// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Nameplate.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {

  public class Nameplate_2_0_0 : ICloneable {
    public object Clone() {
      Nameplate_2_0_0 copy = new Nameplate_2_0_0();
      copy.manufacturer = this.manufacturer;
      copy.brand = this.brand;
      copy.model = this.model;
      copy.partNumber = this.partNumber;
      copy.serialNumber = this.serialNumber;
      copy.rating = this.rating;
      copy.imageFileURL = this.imageFileURL;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["manufacturer"] = this.manufacturer;
      json["brand"] = this.brand;
      json["model"] = this.model;
      json["partNumber"] = this.partNumber;
      json["serialNumber"] = this.serialNumber;
      json["rating"] = this.rating.Encode();
      json["imageFileURL"] = this.imageFileURL;
      return json;
    }

    public static Nameplate_2_0_0 Decode(LightJson.JsonObject json, Agent agent) {
      Nameplate_2_0_0 inst = new Nameplate_2_0_0();
      inst.manufacturer = (string)json["manufacturer"];
      inst.brand = (string)json["brand"];
      inst.model = (string)json["model"];
      inst.partNumber = (string)json["partNumber"];
      inst.serialNumber = (string)json["serialNumber"];
      inst.rating = Com.Raritan.Idl.pdumodel.Nameplate_2_0_0.Rating.Decode(json["rating"], agent);
      inst.imageFileURL = (string)json["imageFileURL"];
      return inst;
    }


    public class Rating : ICloneable {
      public object Clone() {
        Rating copy = new Rating();
        copy.voltage = this.voltage;
        copy.current = this.current;
        copy.frequency = this.frequency;
        copy.power = this.power;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["voltage"] = this.voltage;
        json["current"] = this.current;
        json["frequency"] = this.frequency;
        json["power"] = this.power;
        return json;
      }

      public static Rating Decode(LightJson.JsonObject json, Agent agent) {
        Rating inst = new Rating();
        inst.voltage = (string)json["voltage"];
        inst.current = (string)json["current"];
        inst.frequency = (string)json["frequency"];
        inst.power = (string)json["power"];
        return inst;
      }

      public string voltage = "";
      public string current = "";
      public string frequency = "";
      public string power = "";
    }
    public string manufacturer = "";
    public string brand = "";
    public string model = "";
    public string partNumber = "";
    public string serialNumber = "";
    public Com.Raritan.Idl.pdumodel.Nameplate_2_0_0.Rating rating = new Com.Raritan.Idl.pdumodel.Nameplate_2_0_0.Rating();
    public string imageFileURL = "";
  }
}
