# 宮保拼音鍵盤佈局

## 七指禪

兼容通用電腦鍵盤

    --------------------------
    指法 左 4 3 2 2   2 3 4 右
    --------------------------
    上排    C L D T   U R O
    中排    S H G K - I N E
    下排    Z F B P   Ü
    拇指            A 
    --------------------------
    指法            1 右
    --------------------------

每隻手 1—5 指分別是拇指、食指、中指、無名指、小指。
本方案用 7 根手指並擊，小指與左手拇指不用。故名「七指禪」。

### 宮保拼音 3.0 的佈局更新

1. 簡化右手半區的韻母。
   韻母⟨er, ï⟩以及⟨ai, ei, ou⟩的韻尾合併爲鍵位 R；
   韻母區由 11 鍵縮減爲 8 鍵。
2. 只用 QWERTY 字母區，不用符號鍵。
3. 優化鼻音韻母的指法，精簡活用組合。
4. 重定義並擊鍵序。
5. 鍵碼改用大寫字母，以明示與拼音的區別。

### 並擊鍵序

    SCZHLFGDBKTP-IUÜANREO

### 聲母鍵

按照聲母表順序，以下 12 個聲母鍵與拼音字母一致。

    B = ⟨b⟩
    P = ⟨p⟩
    F = ⟨f⟩
    
    D = ⟨d⟩
    T = ⟨t⟩
    L = ⟨l⟩
    
    G = ⟨g⟩
    K = ⟨k⟩
    H = ⟨h⟩
    
    Z = ⟨z⟩
    C = ⟨c⟩
    S = ⟨s⟩
    
鍵盤佈局上缺少的聲母用並擊輸入。

### 並擊聲母

    ZF = ⟨zh⟩
    CL = ⟨ch⟩
    SH = ⟨sh⟩

    FB = ⟨m⟩
    LD = ⟨n⟩
    HG = ⟨r⟩
    
註：ZH, CH 活用爲 ZF, CL，以求指法簡便。 

### 增補：⟨p, t, k⟩的替代並擊組合

聲母⟨p, t, k⟩用獨立按鍵 P T K 輸入；
若特殊鍵盤上缺少這些鍵位，可改用並擊：
    
    ZB = ⟨p⟩
    CD = ⟨t⟩
    SG = ⟨k⟩

### ⟨j, q, x⟩

聲母 ⟨j, q, x⟩ 用 G, K, H 與介音 I, Ü 組合。 

    GI = ⟨ji⟩
    KI = ⟨qi⟩
    HI = ⟨xi⟩

    GÜ = ⟨ju⟩
    KÜ = ⟨qu⟩
    HÜ = ⟨xu⟩
    
### 增補：尖音⟨j, q, x⟩
分尖團音的官話方言，用 Z, C, S 與 I/Ü 並擊輸入尖音：

    ZI = ⟨zyi⟩
    CI = ⟨cyi⟩
    SI = ⟨syi⟩

    ZÜ = ⟨zü⟩
    CÜ = ⟨cü⟩
    SÜ = ⟨sü⟩
    
### 韻母（陰聲韻）

    I = ⟨i⟩
    U = ⟨u⟩
    Ü = ⟨ü⟩

    A = ⟨a⟩
    IA = ⟨ia⟩
    UA = ⟨ua⟩

    AE = ⟨'a⟩
    
    O = ⟨o⟩
    IO = ⟨io⟩
    UO = ⟨uo⟩

    E = ⟨e⟩
    IE = ⟨ie⟩
    ÜE = ⟨üe⟩

    AR = ⟨ai⟩
    UAR = ⟨uai⟩

    RE = ⟨ei⟩
    UR = ⟨uei⟩
    
    AO = ⟨ao⟩
    IAO = ⟨iao⟩
    
    RO = ⟨ou⟩
    IR = ⟨iou⟩

    R = ⟨er / ï⟩

註：

1. A 鍵單擊輸出空格。音節⟨a⟩改作並擊 AE。
2. 在不致混淆時，通常省略韻母 ⟨e⟩，只擊出聲母。 
3. 舌尖元音⟨ï⟩組成音節⟨zhi, chi, shi, ri, zi, ci, si⟩，通常省略。
4. R 兼表韻尾 ⟨-i, -u⟩，可與 A, E, U, O, I 並擊，合成韻母 ⟨ai, ei, uei, ou, iou⟩。
5. 部分聲母拼⟨ei⟩可以把韻母省略爲 R。\
   但聲母⟨zh, sh, z, c, s⟩後須用 R, RE 區分⟨ï, ei⟩兩韻，如 ZR = ⟨zi⟩，ZRE = ⟨zei⟩。
    
### 韻母（陽聲韻）

    N = ⟨en⟩
    IN = ⟨in⟩
    UN = ⟨uen⟩
    ÜN = ⟨ün⟩
    
    AN = ⟨an⟩
    IAN = ⟨ian⟩
    UAN = ⟨uan⟩
    ÜAN = ⟨üan⟩

    NE = ⟨eng⟩
    INE = ⟨ing⟩
    URO = UNE = ⟨ueng / ong⟩
    IRO = ÜNE = ⟨iong⟩

    ANE = ⟨ang⟩
    IANE = ⟨iang⟩
    UARO = UANE = ⟨uang⟩
    
註：

1. ⟨en, eng⟩ 中的拼音字母⟨e⟩省略。
2. 爲指法簡便，UNE 在合口呼韻母⟨uang, ueng / ong⟩中可以活用爲與 U 位於同一行上的 URO 三鍵並擊。
3. 爲指法簡便，ÜNE 在撮口呼韻母⟨iong⟩中可以活用爲 IRO，介音亦隨之上移一行改作 I，與拼寫對應。

## 八指禪

分體式佈局

用於分體鍵盤或有拆分空格設計的鍵盤，左右手拇指各司一鍵以利並擊。

    --------------------------
    指法 左 4 3 2 2   2 3 4 右
    --------------------------
    上排      L D     U R O
    中排    S C Z G - I N E 
    下排      F B     Ü
    拇指          H A
    --------------------------
    指法       左 1 1 右
    --------------------------

### 並擊鍵序

    SCLFZDBGH-IUÜANREO

### 聲母

    B = ⟨b⟩
    BH = ⟨p⟩
    FB = ⟨m⟩
    F = ⟨f⟩

    D = ⟨d⟩
    DH = ⟨t⟩
    LD = ⟨n⟩
    L = ⟨l⟩

    G = ⟨g⟩
    GH = ⟨k⟩
    H = ⟨h⟩

    GI = ⟨j⟩
    GHI = ⟨q⟩
    HI = ⟨x⟩
    
    ZI = ⟨j⟩
    CI = ⟨q⟩
    SI = ⟨x⟩

    ZH = ⟨zh⟩
    CH = ⟨ch⟩
    SH = ⟨sh⟩
    CZ = ⟨r⟩

    Z = ⟨z⟩
    C = ⟨c⟩
    S = ⟨s⟩

註：

1. Z, C, S 與 I, Ü 組合時表示⟨j, q, x⟩。
   組成音節⟨zhi, chi, shi, ri, zi, ci, si⟩的舌尖元音⟨ï⟩通常省略。
2. G, GH, H 與 I, Ü 組合時表示⟨j, q, x⟩。
   Z 組與 G 組兩可。用家可固定使用一種指法，或根據尖團音拼寫。

### 韻母

同「七指禪」

### 適用鍵盤型號及鍵位設定

這款佈局用於支持自定義鍵位、分體式或分裂空格的鍵盤，如 Ergodox、Corne、Alice 等等。

可通過 VIA、Vial、QMK Configurator 等工具將右手拇指大鍵編程爲空格，左手拇指大鍵編程爲字母 A。
左手拇指鍵也可以設爲分號、單引號、Control 等，輸入方案裏有對應的可選配置。

參與輸入法並擊的按鍵必須是單一功能的按鍵。
不能在這些鍵位上設置一鍵兩用（tap-hold）、一鍵多用（tap-dance）、自動上檔（auto-shift）、鍵盤固件的並擊（combo）功能。

## 八指禪兼容佈局

兼容通用電腦鍵盤。
以「八指禪」佈局爲基礎，兼收「七指禪」的部分聲母鍵及組合聲母。

    -------------------------------------
    指法  左 5  4  3  2  2     2  3  4 右
    -------------------------------------
    上排        C' L  D  T'    U  R  O
    中排     H' S  C  Z  G  -  I  N  E
    下排        Z' F  B  P'    Ü
    拇指                    A
    -------------------------------------
    指法                    1 右
    -------------------------------------

H' 用左手小指擊發，代替拇指位的 H。
其他加 ' 的冗餘按鍵，是爲方便用家從「七指禪」過渡到本式而增設。

### 兼容「七指禪」聲母

    P' = ⟨p⟩
    T' = ⟨t⟩
    Z'F = ⟨zh⟩
    C'L = ⟨ch⟩
    SC = ⟨sh⟩

### H' 的通借鍵

在並擊聲母中將 S, C 等用作 H' 的通借鍵，以分擔左手小指的壓力。

    BZ' = BH' = ⟨p⟩
    DC' = DH' = ⟨t⟩
    GC = GS = GH' = ⟨k⟩
    ZS = ZH' = ⟨zh⟩

若大量打字或長時間練習，請務必習用通借鍵，謹防小指過度疲勞。

## 九宮格

### 二重奏佈局

使用 3×3 分體鍵盤，或 3 行的直列鍵盤。

    -------------------------
    指法 左 4 3 2   2 3 4 右
    -------------------------
    上排    B D G   U R O
    中排    S C Z - I N E
    下排    F L H   A Ü
    -------------------------
    指法     左 1   1 右
    -------------------------

註：H、A 兩鍵根據並擊組合靈活選用拇指、食指兩種指法。

### 獨奏佈局

右手單手操作 3×3 鍵盤，兩次並擊輸入一個音節。

    ----------------------
    指法    2 3 4   2 3 4
    ----------------------
    上排    G D B   U R O
    中排    Z C S   I N E
    下排    H L F   A Ü _
    ----------------------
    指法    1 右    1 右
    ----------------------

### 並擊鍵序

    SBFCDLZGH-IUANRÜEO

### 並擊聲母

    BD = ⟨p⟩
    DG = ⟨t⟩
    GH = ⟨k⟩
    FL = ⟨m⟩
    LH = ⟨n⟩
    ZH = ⟨zh⟩
    CH = ⟨ch⟩
    SH = ⟨sh⟩
    CZ = ⟨r⟩
    SC = ⟨'⟩

註：⟨'⟩爲零聲母。也用於以⟨i, u, ü⟩開頭的音節。如：SC / UO = ⟨wo⟩。

助記：

1. BD, FL, DG, LH 可聯繫⟨b-p, f-m, d-t, l-n⟩近似的發音部位。
2. CZ = ⟨r⟩位於韻母 IN = ⟨in⟩相對的位置，反映兩者的歷史語音有相同的發音部位。
3. 表示零聲母的 SC 位於韻母 NE 相對的位置，反映疑影母與韻尾⟨ng⟩的歷史語音關聯。

### 並擊韻母

略同「七指禪」。

惟獨奏時，單擊右下角空白鍵代表默認韻母，如 G / _ = ⟨ge⟩。

### 指法說明

1. ZH 用拇指、食指並擊，也可用食指同時擊發上下兩鍵。
2. IA 用拇指、食指並擊，也可用食指同時擊發上下兩鍵。
3. ÜN 用中指同時擊發上下兩鍵。

## 速錄鍵盤佈局

使用客製化速錄鍵盤。

    -------------------------------—-
    指法 左 5 4 3 2       2 3 4 5 右
    ---------------------------------
    上排    E N I G D | D G I N E
    下排    O A U Z B | B Z U A O
            ----------|----------
    拇指區        H S | S H
    ---------------------------------
    指法         左 1   1 右
    ---------------------------------

左手半區爲右手半區的鏡像。

### 並擊鍵序

    BDGZSHIUANEO

左右手各錄一組，均按此順序。書寫時左右兩部分用 `-` 隔開。

### 並擊聲母

    BH = ⟨p⟩
    BS = ⟨f⟩
    BZ = ⟨m⟩
    
    DH = ⟨t⟩
    DS = ⟨l⟩
    DG = ⟨n⟩

    GH = ⟨k⟩

    GI = ⟨j⟩
    GHI = ⟨q⟩
    HI = ⟨x⟩

    ZS = ⟨c⟩

    ZH = ⟨zh⟩
    ZSH = ⟨ch⟩
    SH = ⟨sh⟩
    ZG = ⟨r⟩
    
### 增補：尖音⟨j, q, x⟩
分尖團音的官話方言，用 Z, ZS, S 與 I 並擊輸入尖音：

    ZI = ⟨zy⟩
    ZSI = ⟨cy⟩
    SI = ⟨sy⟩
    
### 並擊韻母

    IU = ⟨ü⟩
    EO = ⟨er⟩

指法：用 3 號指、5 號指並擊上下兩鍵。

    A = ⟨a⟩
    IA = ⟨ia⟩
    UA = ⟨ua⟩

    E = ⟨e / ei⟩
    IE = ⟨ie⟩
    UE = ⟨uei⟩
    IUE = ⟨üe⟩

    AE = ⟨ai⟩
    UAE = ⟨uai⟩

    O = ⟨o / ou⟩
    UO = ⟨uo⟩
    IO = ⟨io / iou⟩

    AO = ⟨ao⟩
    IAO = ⟨iao⟩

    N = ⟨en⟩
    IN = ⟨in⟩
    UN = ⟨uen⟩
    IUN = ⟨ün⟩

    AN = ⟨an⟩
    IAN = ⟨ian⟩
    UAN = ⟨uan⟩
    IUAN = ⟨üan⟩

註：`[AN]` 用 4 號指並擊上下兩鍵。

    NE = ⟨eng⟩
    INE = ⟨ing⟩
    UAO = ⟨ong / ueng / yong⟩
    IUAO = ⟨iong⟩

註：
  - `[UAO]` 是 `[UNE]` 指法更便利的通借並擊碼。
  - `[UAO]` 的零聲母音節⟨weng⟩只有「翁」等幾個字，可兼表音節⟨yong⟩。

    ANO = ⟨ang⟩
    NO = ⟨ang⟩
    INO = ⟨iang⟩
    UNO = ⟨uang⟩

註：`[NO]` 是 `[ANO]` 的簡化形式。
