## TFSA-2021-141: Reference binding to nullptr in unicode encoding

### CVE Number
CVE-2021-37667

### Impact
An attacker can cause undefined behavior via binding a reference to null pointer
in `tf.raw_ops.UnicodeEncode`:

```python
import tensorflow as tf
from tensorflow.python.ops import gen_string_ops

gen_string_ops.unicode_encode(
  input_values=[],
  input_splits=[],
  output_encoding='UTF-8',
  errors='ignore',
  replacement_char='a')
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/kernels/unicode_ops.cc#L533-L539)
reads the first dimension of the `input_splits` tensor before validating that
this tensor is not empty:

```cc
  const Tensor& input_splits = context->input(1);
  const auto input_splits_flat = input_splits.flat<SPLITS_TYPE>();
  TensorShape output_shape({input_splits.dim_size(0) - 1});
```

### Patches
We have patched the issue in GitHub commit
[2e0ee46f1a47675152d3d865797a18358881d7a6](https://github.com/tensorflow/tensorflow/commit/2e0ee46f1a47675152d3d865797a18358881d7a6).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
