/* @HEADER@ */
// ************************************************************************
// 
//                             Sundance
//                 Copyright 2011 Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Kevin Long (kevin.long@ttu.edu)
// 

/* @HEADER@ */

#include "SundanceOut.hpp"
#include "PlayaTabs.hpp"
#include "SundanceFunctionalAssemblyKernel.hpp"
#include "SundanceIntegralGroup.hpp"
#include "Teuchos_Time.hpp"
#include "Teuchos_TimeMonitor.hpp"

using namespace Sundance;
using namespace Teuchos;
using Playa::MPIComm;
using Playa::MPIDataType;
using Playa::MPIOp;

using std::setw;
using std::endl;
      
FunctionalAssemblyKernel::FunctionalAssemblyKernel(
  const MPIComm& comm,
  double* value,
  int verb
  )
  : AssemblyKernelBase(verb),
    comm_(comm),
    value_(value),
    localValue_(0.0)
{}

void FunctionalAssemblyKernel::postLoopFinalization()
{
  Tabs tab;
  SUNDANCE_MSG3(verb(), tab << "reducing functional values across processors");
  SUNDANCE_MSG3(verb(), tab << "local value=" << localValue_);
  double globalVal = localValue_;
  
  comm_.allReduce((void*) &localValue_, (void*) &globalVal, 1, 
    MPIDataType::doubleType(), MPIOp::sumOp());

  *value_ = globalVal;

  SUNDANCE_MSG3(verb(), tab << "reduced value = " << *value_);
}

void FunctionalAssemblyKernel::fill(
  bool isBC, 
  const IntegralGroup& group,
  const RCP<Array<double> >& localValues) 
{
  Tabs tab;
  SUNDANCE_MSG2(verb(), tab << "adding local increment " << (*localValues)[0]
    << " to local value" << std::endl << tab << "Before: " << localValue_);
  
  localValue_ += (*localValues)[0];
  SUNDANCE_MSG2(verb(), tab << "After: " << localValue_);
}
  

