// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Garay`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x00060C,
    0x00061B,
    0x00061F
  ],
  ranges: [
    [0x010D40, 0x010D65],
    [0x010D69, 0x010D85],
    [0x010D8E, 0x010D8F]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Garay}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Garay}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Gara}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Gara}"
);
testPropertyEscapes(
  /^\p{scx=Garay}+$/u,
  matchSymbols,
  "\\p{scx=Garay}"
);
testPropertyEscapes(
  /^\p{scx=Gara}+$/u,
  matchSymbols,
  "\\p{scx=Gara}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00060B],
    [0x00060D, 0x00061A],
    [0x00061C, 0x00061E],
    [0x000620, 0x00DBFF],
    [0x00E000, 0x010D3F],
    [0x010D66, 0x010D68],
    [0x010D86, 0x010D8D],
    [0x010D90, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Garay}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Garay}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Gara}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Gara}"
);
testPropertyEscapes(
  /^\P{scx=Garay}+$/u,
  nonMatchSymbols,
  "\\P{scx=Garay}"
);
testPropertyEscapes(
  /^\P{scx=Gara}+$/u,
  nonMatchSymbols,
  "\\P{scx=Gara}"
);

reportCompare(0, 0);
