#pragma once

//multi-precision arithmetic
//warning: each size is quadratically more expensive than the size before it!

#include <stdexcept>

#include <nall/stdint.hpp>
#include <nall/string.hpp>
#include <nall/range.hpp>
#include <nall/traits.hpp>

#include <nall/arithmetic/unsigned.hpp>

namespace nall {
  template<u32 Bits> struct ArithmeticNatural;
  template<> struct ArithmeticNatural<  8> { using type = u8;   };
  template<> struct ArithmeticNatural< 16> { using type = u16;  };
  template<> struct ArithmeticNatural< 32> { using type = u32;  };
  template<> struct ArithmeticNatural< 64> { using type = u64;  };
  #if defined(__SIZEOF_INT128__)
  template<> struct ArithmeticNatural<128> { using type = u128; };
  #endif
}

#if !defined(__SIZEOF_INT128__)
#define PairBits 128
#define TypeBits  64
#define HalfBits  32
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits
#endif

#define PairBits 256
#define TypeBits 128
#define HalfBits  64
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits

#define PairBits 512
#define TypeBits 256
#define HalfBits 128
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits

#define PairBits 1024
#define TypeBits  512
#define HalfBits  256
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits

#define PairBits 2048
#define TypeBits 1024
#define HalfBits  512
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits

#define PairBits 4096
#define TypeBits 2048
#define HalfBits 1024
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits

#define PairBits 8192
#define TypeBits 4096
#define HalfBits 2048
#include <nall/arithmetic/natural.hpp>
#undef PairBits
#undef TypeBits
#undef HalfBits

namespace nall {
  //TODO: these types are for expressing smaller bit ranges in class interfaces
  //for instance, XChaCha20 taking a 192-bit nonce
  //however, they still allow more bits than expressed ...
  //some sort of wrapper needs to be devised to ensure these sizes are masked and wrap appropriately

  using u192 = u256;
}
